/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class ServerConfigUtil {
    private ServerConfigUtil() {
    }

    public static String getSpecificBindAddress() {
        String address = System.getProperty("jboss.bind.address");
        if (address == null || address.equals("0.0.0.0")) {
            return null;
        }
        return address;
    }

    public static InetAddress fixRemoteAddress(InetAddress address) {
        try {
            if (address == null || InetAddress.getByName("0.0.0.0").equals(address)) {
                return InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public static String fixRemoteAddress(String address) {
        try {
            if (address == null || "0.0.0.0".equals(address)) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public static String shortUrlFromServerHome(String longUrl) {
        String serverHomeUrl = System.getProperty("jboss.home.url");
        if (longUrl == null || serverHomeUrl == null) {
            return longUrl;
        }
        if (longUrl.startsWith(serverHomeUrl)) {
            return ".../" + longUrl.substring(serverHomeUrl.length());
        }
        String jarServerHomeUrl = "jar:" + serverHomeUrl;
        if (longUrl.startsWith(jarServerHomeUrl)) {
            return ".../" + longUrl.substring(jarServerHomeUrl.length());
        }
        return longUrl;
    }
}

