/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerInternals;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb.EjbUtil50;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.metadata.serviceref.ServiceReferenceHandler;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.omg.CORBA.ORB;

public abstract class AbstractWarDeployment {
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    protected Logger log = Logger.getLogger(this.getClass());
    protected MBeanServer server;
    protected MainDeployerInternals mainDeployer;
    protected Kernel kernel;
    protected DeploymentUnit unit;
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain;
    protected String policyRegistrationName;
    protected PolicyRegistration policyRegistration;
    protected String securityManagementName;
    protected ISecurityManagement securityManagement;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    public static String shortWarUrlFromServerHome(String warUrl) {
        String serverHomeUrl = System.getProperty("jboss.server.home.url");
        if (warUrl == null || serverHomeUrl == null) {
            return warUrl;
        }
        if (warUrl.startsWith(serverHomeUrl)) {
            return ".../" + warUrl.substring(serverHomeUrl.length());
        }
        return warUrl;
    }

    public abstract void init(Object var1) throws Exception;

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public MainDeployerInternals getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerInternals mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        if (this.defaultSecurityDomain == null) {
            throw new IllegalStateException("Default Security Domain is null");
        }
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    protected PersistenceUnitDependencyResolver getPersistenceUnitDependencyResolver() {
        return this.persistenceUnitDependencyResolver;
    }

    @Inject
    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    public String getPolicyRegistrationName() {
        return this.policyRegistrationName;
    }

    public void setPolicyRegistrationName(String policyRegistrationName) {
        this.policyRegistrationName = policyRegistrationName;
    }

    public PolicyRegistration getPolicyRegistration() {
        return this.policyRegistration;
    }

    public void setPolicyRegistration(PolicyRegistration policyRegistration) {
        this.policyRegistration = policyRegistration;
    }

    public String getSecurityManagementName() {
        return this.securityManagementName;
    }

    public void setSecurityManagementName(String securityManagement) {
        this.securityManagementName = securityManagement;
    }

    public ISecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WebApplication start(DeploymentUnit unit, JBossWebMetaData metaData) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader appClassLoader = thread.getContextClassLoader();
        WebApplication webApp = null;
        try {
            String warURLString;
            ClassLoader warLoader = unit.getClassLoader();
            thread.setContextClassLoader(warLoader);
            String webContext = metaData.getContextRoot();
            URL warUrl = (URL)unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
            if (warUrl == null && unit instanceof VFSDeploymentUnit) {
                VFSDeploymentUnit vdu = (VFSDeploymentUnit)VFSDeploymentUnit.class.cast(unit);
                warUrl = VFSUtils.getRealURL((VirtualFile)vdu.getRoot());
            }
            String string = warURLString = warUrl != null ? warUrl.toExternalForm() : unit.getName();
            if (warURLString.startsWith("jar:")) {
                warURLString = warURLString.substring(4, warURLString.length() - 2);
            }
            this.log.debug((Object)("webContext: " + webContext));
            this.log.debug((Object)("warURL: " + warURLString));
            String contextID = metaData.getJaccContextID();
            if (contextID == null) {
                contextID = unit.getSimpleName();
            }
            metaData.setJaccContextID(contextID);
            webApp = new WebApplication(metaData);
            webApp.setClassLoader(warLoader);
            webApp.setDeploymentUnit(unit);
            this.performDeploy(webApp, warURLString);
        }
        finally {
            thread.setContextClassLoader(appClassLoader);
        }
        return webApp;
    }

    public synchronized void stop(DeploymentUnit di, WebApplication webApp) throws Exception {
        URL warURL = webApp.getURL();
        String warUrl = warURL.toString();
        this.performUndeploy(webApp, warUrl);
    }

    protected abstract void performDeploy(WebApplication var1, String var2) throws Exception;

    protected abstract void performUndeploy(WebApplication var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEnc(ClassLoader loader, WebApplication webApp) throws Exception {
        if (loader == null) {
            throw new IllegalArgumentException("Classloader passed to process ENC refs is null");
        }
        this.log.debug((Object)"AbstractWebContainer.parseWebAppDescriptors, Begin");
        InitialContext iniCtx = new InitialContext();
        Context envCtx = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader currentLoader = currentThread.getContextClassLoader();
        JBossWebMetaData metaData = webApp.getMetaData();
        try {
            this.log.debug((Object)("Creating ENC using ClassLoader: " + loader));
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                this.log.debug((Object)(".." + parent));
            }
            currentThread.setContextClassLoader(loader);
            envCtx = (Context)iniCtx.lookup("java:comp");
            ORB orb = null;
            try {
                ObjectName ORB_NAME = new ObjectName("jboss:service=CorbaORB");
                orb = (ORB)this.server.getAttribute(ORB_NAME, "ORB");
                if (orb != null) {
                    NonSerializableFactory.rebind((Context)envCtx, (String)"ORB", (Object)orb);
                    this.log.debug((Object)"Bound java:comp/ORB");
                }
            }
            catch (Throwable t) {
                this.log.debug((Object)("Unable to retrieve orb" + t.toString()));
            }
            envCtx.bind("UserTransaction", (Object)new LinkRef("UserTransaction"));
            this.log.debug((Object)"Linked java:comp/UserTransaction to JNDI name: UserTransaction");
            envCtx = envCtx.createSubcontext("env");
            this.processEncReferences(webApp, envCtx);
        }
        finally {
            currentThread.setContextClassLoader(currentLoader);
        }
        String securityDomain = metaData.getSecurityDomain();
        this.log.debug((Object)"linkSecurityDomain");
        this.linkSecurityDomain(securityDomain, envCtx);
        this.log.debug((Object)"AbstractWebContainer.parseWebAppDescriptors, End");
    }

    protected void processEncReferences(WebApplication webApp, Context envCtx) throws ClassNotFoundException, NamingException {
        DeploymentUnit unit = webApp.getDeploymentUnit();
        JBossWebMetaData metaData = webApp.getMetaData();
        EnvironmentEntriesMetaData envEntries = metaData.getEnvironmentEntries();
        this.log.debug((Object)"addEnvEntries");
        this.addEnvEntries(envEntries, envCtx);
        ResourceEnvironmentReferencesMetaData resourceEnvRefs = metaData.getResourceEnvironmentReferences();
        this.log.debug((Object)"linkResourceEnvRefs");
        this.linkResourceEnvRefs(resourceEnvRefs, envCtx);
        ResourceReferencesMetaData resourceRefs = metaData.getResourceReferences();
        this.log.debug((Object)"linkResourceRefs");
        this.linkResourceRefs(resourceRefs, envCtx);
        this.log.debug((Object)"linkMessageDestinationRefs");
        MessageDestinationReferencesMetaData msgRefs = metaData.getMessageDestinationReferences();
        this.linkMessageDestinationRefs(unit, msgRefs, envCtx);
        EJBReferencesMetaData ejbRefs = metaData.getEjbReferences();
        this.log.debug((Object)"linkEjbRefs");
        this.linkEjbRefs(unit, ejbRefs, envCtx);
        EJBLocalReferencesMetaData ejbLocalRefs = metaData.getEjbLocalReferences();
        this.log.debug((Object)"linkEjbLocalRefs");
        this.linkEjbLocalRefs(unit, ejbLocalRefs, envCtx);
        this.log.debug((Object)"linkServiceRefs");
        ServiceReferencesMetaData serviceRefs = metaData.getServiceReferences();
        this.linkServiceRefs(unit, serviceRefs, envCtx);
    }

    private void linkServiceRefs(DeploymentUnit unit, ServiceReferencesMetaData serviceRefs, Context envCtx) throws NamingException {
        if (unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            ClassLoader loader = unit.getClassLoader();
            VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(vfsUnit.getRoot());
            for (ServiceReferenceMetaData sref : serviceRefs) {
                String refName = sref.getServiceRefName();
                new ServiceReferenceHandler().bindServiceRef(envCtx, refName, (UnifiedVirtualFile)vfsRoot, loader, sref);
            }
        }
    }

    protected void addEnvEntries(EnvironmentEntriesMetaData envEntries, Context envCtx) throws ClassNotFoundException, NamingException {
        for (EnvironmentEntryMetaData entry : envEntries) {
            this.log.debug((Object)("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue()));
            AbstractWarDeployment.bindEnvEntry(envCtx, entry);
        }
    }

    protected void linkResourceEnvRefs(ResourceEnvironmentReferencesMetaData resourceEnvRefs, Context envCtx) throws NamingException {
        for (ResourceEnvironmentReferenceMetaData ref : resourceEnvRefs) {
            String resourceName = ref.getJndiName();
            String refName = ref.getResourceEnvRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    this.log.debug((Object)("Binding '" + refName + "' to URL: " + resourceName));
                    URL url = new URL(resourceName);
                    Util.bind((Context)envCtx, (String)refName, (Object)url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (resourceName != null) {
                this.log.debug((Object)("Linking '" + refName + "' to JNDI name: " + resourceName));
                Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(resourceName));
                continue;
            }
            throw new NamingException("resource-env-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-env-ref.");
        }
    }

    protected void linkResourceRefs(ResourceReferencesMetaData resourceRefs, Context envCtx) throws NamingException {
        for (ResourceReferenceMetaData ref : resourceRefs) {
            String jndiName = ref.getJndiName();
            String refName = ref.getResourceName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    String resURL = ref.getResUrl();
                    if (resURL != null) {
                        this.log.debug((Object)("Binding '" + refName + "' to URL: " + resURL));
                        URL url = new URL(resURL);
                        Util.bind((Context)envCtx, (String)refName, (Object)url);
                        continue;
                    }
                    this.log.debug((Object)("Linking '" + refName + "' to URL: " + resURL));
                    LinkRef urlLink = new LinkRef(jndiName);
                    Util.bind((Context)envCtx, (String)refName, (Object)urlLink);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (jndiName != null) {
                this.log.debug((Object)("Linking '" + refName + "' to JNDI name: " + jndiName));
                Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(jndiName));
                continue;
            }
            throw new NamingException("resource-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-ref.");
        }
    }

    protected void linkMessageDestinationRefs(DeploymentUnit unit, MessageDestinationReferencesMetaData msgRefs, Context envCtx) throws NamingException {
        for (MessageDestinationReferenceMetaData ref : msgRefs) {
            String refName = ref.getName();
            String jndiName = ref.getJndiName();
            String link = ref.getLink();
            if (link != null) {
                if (jndiName == null) {
                    MessageDestinationMetaData messageDestination = EjbUtil50.findMessageDestination(this.mainDeployer, unit, link);
                    if (messageDestination == null) {
                        throw new NamingException("message-destination-ref '" + refName + "' message-destination-link '" + link + "' not found and no jndi-name in jboss-web.xml");
                    }
                    String linkJNDIName = messageDestination.getJndiName();
                    if (linkJNDIName == null) {
                        this.log.warn((Object)("message-destination '" + link + "' has no jndi-name in jboss-web.xml"));
                    } else {
                        jndiName = linkJNDIName;
                    }
                } else {
                    this.log.warn((Object)("message-destination-ref '" + refName + "' ignoring message-destination-link '" + link + "' because it has a jndi-name in jboss-web.xml"));
                }
            } else if (jndiName == null) {
                throw new NamingException("message-destination-ref '" + refName + "' has no message-destination-link in web.xml and no jndi-name in jboss-web.xml");
            }
            Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbRefs(DeploymentUnit unit, EJBReferencesMetaData ejbRefs, Context envCtx) throws NamingException {
        for (EJBReferenceMetaData ejb : ejbRefs) {
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil50.findEjbLink(this.mainDeployer, unit, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link in web.xml and no jndi-name in jboss-web.xml");
            }
            this.log.debug((Object)("Linking ejb-ref: " + name + " to JNDI name: " + jndiName));
            Util.bind((Context)envCtx, (String)name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbLocalRefs(DeploymentUnit unit, EJBLocalReferencesMetaData ejbLocalRefs, Context envCtx) throws NamingException {
        for (EJBLocalReferenceMetaData ejb : ejbLocalRefs) {
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil50.findLocalEjbLink(this.mainDeployer, unit, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                String msg = null;
                msg = linkName == null ? "ejb-local-ref: '" + name + "', no ejb-link in web.xml and " + "no local-jndi-name in jboss-web.xml" : "ejb-local-ref: '" + name + "', with web.xml ejb-link: '" + linkName + "' failed to resolve to an ejb with a LocalHome";
                throw new NamingException(msg);
            }
            this.log.debug((Object)("Linking ejb-local-ref: " + name + " to JNDI name: " + jndiName));
            Util.bind((Context)envCtx, (String)name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkSecurityDomain(String securityDomain, Context envCtx) throws NamingException {
        if (securityDomain == null) {
            securityDomain = this.getDefaultSecurityDomain();
            this.log.debug((Object)("No security-domain given, using default: " + securityDomain));
        }
        if (!securityDomain.startsWith("java:/jaas")) {
            securityDomain = "java:/jaas/" + securityDomain;
        }
        this.log.debug((Object)("Linking security/securityMgr to JNDI name: " + securityDomain));
        Util.bind((Context)envCtx, (String)"security/securityMgr", (Object)new LinkRef(securityDomain));
        Util.bind((Context)envCtx, (String)"security/realmMapping", (Object)new LinkRef(securityDomain + "/realmMapping"));
        Util.bind((Context)envCtx, (String)"security/authorizationMgr", (Object)new LinkRef(securityDomain + "/authorizationMgr"));
        Util.bind((Context)envCtx, (String)"security/security-domain", (Object)new LinkRef(securityDomain));
        Util.bind((Context)envCtx, (String)"security/subject", (Object)new LinkRef(securityDomain + "/subject"));
    }

    public String[] getStandardCompileClasspath(ClassLoader loader) {
        String[] jspResources = new String[]{"javax/servlet/resources/web-app_2_3.dtd", "org/apache/jasper/resources/jsp12.dtd", "javax/ejb/EJBHome.class"};
        ArrayList<String> tmp = new ArrayList<String>();
        for (int j = 0; j < jspResources.length; ++j) {
            URL rsrcURL = loader.getResource(jspResources[j]);
            if (rsrcURL != null) {
                String url = rsrcURL.toExternalForm();
                if (rsrcURL.getProtocol().equals("jar")) {
                    url = url.substring(4);
                    int seperator = url.indexOf(33);
                    url = url.substring(0, seperator);
                }
                tmp.add(url);
                continue;
            }
            this.log.warn((Object)("Failed to fin jsp rsrc: " + jspResources[j]));
        }
        this.log.trace((Object)("JSP StandardCompileClasspath: " + tmp));
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    public String[] getCompileClasspath(ClassLoader loader) {
        HashSet tmp = new HashSet();
        for (ClassLoader cl = loader; cl != null; cl = cl.getParent()) {
            URL[] urls = AbstractWarDeployer.getClassLoaderURLs(cl);
            this.addURLs(tmp, urls);
        }
        try {
            URL[] globalUrls = (URL[])this.server.getAttribute(LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY, "URLs");
            this.addURLs(tmp, globalUrls);
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not get global URL[] from default loader repository!", (Throwable)e);
        }
        this.log.trace((Object)("JSP CompileClasspath: " + tmp));
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    private void addURLs(Set urlSet, URL[] urls) {
        for (int u = 0; u < urls.length; ++u) {
            URL url = urls[u];
            urlSet.add(url.toExternalForm());
        }
    }

    public static void bindEnvEntry(Context ctx, EnvironmentEntryMetaData entry) throws ClassNotFoundException, NamingException {
        ClassLoader loader = EnvironmentEntryMetaData.class.getClassLoader();
        Class<?> type = loader.loadClass(entry.getType());
        if (type == String.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)entry.getValue());
        } else if (type == Integer.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Integer(entry.getValue()));
        } else if (type == Long.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Long(entry.getValue()));
        } else if (type == Double.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Double(entry.getValue()));
        } else if (type == Float.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Float(entry.getValue()));
        } else if (type == Byte.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Byte(entry.getValue()));
        } else if (type == Character.class) {
            Character value = null;
            String input = entry.getValue();
            value = input == null || input.length() == 0 ? new Character('\u0000') : new Character(input.charAt(0));
            Util.bind((Context)ctx, (String)entry.getName(), (Object)value);
        } else if (type == Short.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Short(entry.getValue()));
        } else if (type == Boolean.class) {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)new Boolean(entry.getValue()));
        } else {
            Util.bind((Context)ctx, (String)entry.getName(), (Object)entry.getValue());
        }
    }
}

