/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Connector;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.SimpleLoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequestFactory;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPResponseParser;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterService
implements ModClusterServiceMBean,
ContainerEventHandler,
LoadBalanceFactorProvider {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPHandlerConfiguration mcmpConfig;
    private final MCMPHandler mcmpHandler;
    private final ResetRequestSource resetRequestSource;
    private final MCMPRequestFactory requestFactory;
    private final AdvertiseListenerFactory listenerFactory;
    private final LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory;
    private volatile Server server = null;
    private volatile LoadBalanceFactorProvider loadBalanceFactorProvider;
    private volatile AdvertiseListener advertiseListener;
    private volatile Map<String, Set<String>> excludedContextPaths;

    public ModClusterService(ModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider) {
        this(config, new SimpleLoadBalanceFactorProviderFactory(loadBalanceFactorProvider));
    }

    public ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory) {
        this(config, loadBalanceFactorProviderFactory, new DefaultMCMPRequestFactory());
    }

    private ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory) {
        this(config, loadBalanceFactorProviderFactory, requestFactory, new DefaultMCMPResponseParser(), new ResetRequestSourceImpl(config, config, requestFactory));
    }

    private ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource) {
        this(config, config, config, loadBalanceFactorProviderFactory, requestFactory, responseParser, resetRequestSource, new DefaultMCMPHandler(config, resetRequestSource, requestFactory, responseParser), new AdvertiseListenerFactoryImpl());
    }

    protected ModClusterService(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource, MCMPHandler mcmpHandler, AdvertiseListenerFactory listenerFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.mcmpConfig = mcmpConfig;
        this.mcmpHandler = mcmpHandler;
        this.resetRequestSource = resetRequestSource;
        this.requestFactory = requestFactory;
        this.loadBalanceFactorProviderFactory = loadBalanceFactorProviderFactory;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public synchronized void init(Server server) {
        this.log.info((Object)Strings.SERVER_INIT.getString(new Object[0]));
        this.server = server;
        List<InetSocketAddress> initialProxies = Utils.parseProxies(this.mcmpConfig.getProxyList());
        this.mcmpHandler.init(initialProxies);
        this.excludedContextPaths = Utils.parseContexts(this.mcmpConfig.getExcludedContexts());
        this.resetRequestSource.init(server, this.excludedContextPaths);
        this.loadBalanceFactorProvider = this.loadBalanceFactorProviderFactory.createLoadBalanceFactorProvider();
        Boolean advertise = this.mcmpConfig.getAdvertise();
        if (Boolean.TRUE.equals(advertise) || advertise == null && initialProxies.isEmpty()) {
            try {
                this.advertiseListener = this.listenerFactory.createListener(this.mcmpHandler, this.mcmpConfig);
                this.advertiseListener.start();
            }
            catch (IOException e) {
                this.log.error((Object)Strings.ERROR_ADVERTISE_START.getString(new Object[0]), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        this.log.debug((Object)Strings.SHUTDOWN.getString(new Object[0]));
        this.server = null;
        if (this.advertiseListener != null) {
            this.advertiseListener.destroy();
            this.advertiseListener = null;
        }
        this.mcmpHandler.shutdown();
    }

    @Override
    public void start(Server server) {
        this.checkInit();
        this.log.debug((Object)Strings.SERVER_START.getString(new Object[0]));
        for (Engine engine : server.getEngines()) {
            this.config(engine);
            for (Host host : engine.getHosts()) {
                for (Context context : host.getContexts()) {
                    this.add(context);
                }
            }
        }
    }

    @Override
    public void stop(Server server) {
        this.checkInit();
        this.log.debug((Object)Strings.SERVER_STOP.getString(new Object[0]));
        for (Engine engine : server.getEngines()) {
            for (Host host : engine.getHosts()) {
                for (Context context : host.getContexts()) {
                    this.remove(context);
                }
            }
            this.removeAll(engine);
        }
    }

    protected void config(Engine engine) {
        this.log.debug((Object)Strings.ENGINE_CONFIG.getString(engine));
        try {
            this.establishConnectorAddress(engine);
            this.establishJvmRoute(engine);
            MCMPRequest request = this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig);
            this.mcmpHandler.sendRequest(request);
        }
        catch (Exception e) {
            this.mcmpHandler.markProxiesInError();
            this.log.info((Object)Strings.ERROR_ADDRESS_JVMROUTE.getString(new Object[0]), (Throwable)e);
        }
    }

    protected void establishConnectorAddress(Engine engine) throws IOException {
        Connector connector = engine.getProxyConnector();
        InetAddress address = connector.getAddress();
        if (address == null || address.isAnyLocalAddress()) {
            InetAddress localAddress = this.mcmpHandler.getLocalAddress();
            InetAddress connectorAddress = localAddress != null ? localAddress : InetAddress.getLocalHost();
            connector.setAddress(connectorAddress);
            this.log.info((Object)Strings.DETECT_CONNECTOR_ADDRESS.getString(engine, connectorAddress.getHostAddress()));
        }
    }

    protected void establishJvmRoute(Engine engine) {
        if (engine.getJvmRoute() == null) {
            Connector connector = engine.getProxyConnector();
            String jvmRoute = connector.getAddress().getHostAddress() + ":" + connector.getPort() + ":" + engine.getName();
            engine.setJvmRoute(jvmRoute);
            this.log.info((Object)Strings.DETECT_JVMROUTE.getString(engine, jvmRoute));
        }
    }

    @Override
    public void add(Context context) {
        this.checkInit();
        if (!this.exclude(context) && context.isStarted()) {
            this.log.debug((Object)Strings.CONTEXT_ENABLE.getString(context, context.getHost()));
            MCMPRequest request = this.requestFactory.createEnableRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void start(Context context) {
        this.checkInit();
        if (!this.exclude(context)) {
            this.log.debug((Object)Strings.CONTEXT_START.getString(context, context.getHost()));
            MCMPRequest request = this.requestFactory.createEnableRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void stop(Context context) {
        this.checkInit();
        if (!this.exclude(context)) {
            this.log.debug((Object)Strings.CONTEXT_STOP.getString(context, context.getHost()));
            MCMPRequest request = this.requestFactory.createStopRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void remove(Context context) {
        Host host;
        this.checkInit();
        if (!this.exclude(context) && (host = context.getHost()).getEngine().getJvmRoute() != null) {
            this.log.debug((Object)Strings.CONTEXT_DISABLE.getString(context, host));
            MCMPRequest request = this.requestFactory.createRemoveRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    protected void removeAll(Engine engine) {
        if (engine.getJvmRoute() != null) {
            this.log.debug((Object)Strings.ENGINE_STOP.getString(engine));
            MCMPRequest request = this.requestFactory.createRemoveRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void status(Engine engine) {
        this.checkInit();
        this.log.debug((Object)Strings.ENGINE_STATUS.getString(engine));
        this.mcmpHandler.status();
        this.mcmpHandler.sendRequest(this.requestFactory.createStatusRequest(engine.getJvmRoute(), this.getLoadBalanceFactor()));
    }

    @Override
    public int getLoadBalanceFactor() {
        return this.loadBalanceFactorProvider.getLoadBalanceFactor();
    }

    protected void checkInit() {
        if (this.server == null) {
            throw new IllegalStateException(Strings.ERROR_UNINITIALIZED.getString(new Object[0]));
        }
    }

    private boolean exclude(Context context) {
        Set<String> excludedPaths = this.excludedContextPaths.get(context.getHost().getName());
        return excludedPaths != null ? excludedPaths.contains(context.getPath()) : false;
    }

    @Override
    public void addProxy(String host, int port) {
        this.mcmpHandler.addProxy(this.createSocketAddress(host, port));
    }

    @Override
    public void removeProxy(String host, int port) {
        this.mcmpHandler.removeProxy(this.createSocketAddress(host, port));
    }

    private InetSocketAddress createSocketAddress(String host, int port) {
        try {
            return new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.getProxyResults(this.requestFactory.createDumpRequest());
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.getProxyResults(this.requestFactory.createInfoRequest());
    }

    @Override
    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        MCMPRequest request = null;
        if (jvmRoute == null || jvmRoute.length() == 0) {
            request = this.requestFactory.createPingRequest();
        } else if (!jvmRoute.contains("://")) {
            request = this.requestFactory.createPingRequest(jvmRoute);
        } else {
            try {
                request = this.requestFactory.createPingRequest(new URI(jvmRoute));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.getProxyResults(request);
    }

    private Map<InetSocketAddress, String> getProxyResults(MCMPRequest request) {
        Map<MCMPServerState, String> responses = this.mcmpHandler.sendRequest(request);
        if (responses.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<InetSocketAddress, String> results = new HashMap<InetSocketAddress, String>();
        for (Map.Entry<MCMPServerState, String> response : responses.entrySet()) {
            MCMPServerState state = response.getKey();
            results.put(state.getSocketAddress(), response.getValue());
        }
        return results;
    }

    @Override
    public void reset() {
        this.mcmpHandler.reset();
    }

    @Override
    public void refresh() {
        this.mcmpHandler.markProxiesInError();
    }

    @Override
    public boolean disable() {
        if (this.server == null) {
            throw new IllegalStateException(Strings.ERROR_UNINITIALIZED.getString(new Object[0]));
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(engine));
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean enable() {
        if (this.server == null) {
            throw new IllegalStateException(Strings.ERROR_UNINITIALIZED.getString(new Object[0]));
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createEnableRequest(engine));
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean disableContext(String host, String path) {
        if (this.server == null) {
            throw new IllegalStateException(Strings.ERROR_UNINITIALIZED.getString(new Object[0]));
        }
        Context context = this.findContext(this.findHost(host), path);
        this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(context));
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean enableContext(String host, String path) {
        if (this.server == null) {
            throw new IllegalStateException(Strings.ERROR_UNINITIALIZED.getString(new Object[0]));
        }
        Context context = this.findContext(this.findHost(host), path);
        this.mcmpHandler.sendRequest(this.requestFactory.createEnableRequest(context));
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean stop(long timeout, TimeUnit unit) {
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(engine));
        }
        long start = System.currentTimeMillis();
        long end = start + unit.toMillis(timeout);
        for (Engine engine : this.server.getEngines()) {
            for (Host host : engine.getHosts()) {
                for (Context context : host.getContexts()) {
                    if (this.drainSessions(context, start, end)) continue;
                    return false;
                }
            }
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createStopRequest(engine));
        }
        return true;
    }

    @Override
    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        Context context = this.findContext(this.findHost(host), path);
        this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(context));
        long start = System.currentTimeMillis();
        boolean success = this.drainSessions(context, start, start + unit.toMillis(timeout));
        if (success) {
            this.mcmpHandler.sendRequest(this.requestFactory.createStopRequest(context));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drainSessions(final Context context, long start, long end) {
        int remainingSessions = context.getActiveSessionCount();
        if (remainingSessions == 0) {
            return true;
        }
        HttpSessionListener listener = new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionDestroyed(HttpSessionEvent event) {
                Context context2 = context;
                synchronized (context2) {
                    context.notify();
                }
            }
        };
        try {
            Context context2 = context;
            synchronized (context2) {
                context.addSessionListener(listener);
                boolean noTimeout = start >= end;
                long current = System.currentTimeMillis();
                long timeout = end - current;
                remainingSessions = context.getActiveSessionCount();
                while (remainingSessions > 0 && (noTimeout || timeout > 0L)) {
                    this.log.debug((Object)Strings.DRAIN_SESSIONS_WAIT.getString(context, remainingSessions));
                    context.wait(noTimeout ? 0L : timeout);
                    current = System.currentTimeMillis();
                    timeout = end - current;
                    remainingSessions = context.getActiveSessionCount();
                }
            }
            boolean success = remainingSessions == 0;
            long seconds = TimeUnit.MILLISECONDS.toSeconds((success ? System.currentTimeMillis() : end) - start);
            if (success) {
                this.log.info((Object)Strings.DRAIN_SESSIONS.getString(context, seconds));
            } else {
                this.log.warn((Object)Strings.DRAIN_SESSIONS_TIMEOUT.getString(context, seconds));
            }
            boolean bl = success;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            context.removeSessionListener(listener);
        }
    }

    private Host findHost(String name) {
        for (Engine engine : this.server.getEngines()) {
            Host host = engine.findHost(name);
            if (host == null) continue;
            return host;
        }
        throw new IllegalArgumentException();
    }

    private Context findContext(Host host, String path) {
        Context context = host.findContext(path);
        if (context == null) {
            throw new IllegalArgumentException();
        }
        return context;
    }
}

