/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptionTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptionTypeRegistry.class);
    private static Map<InterceptionType, Class<? extends Annotation>> interceptionAnnotationClasses;
    public static Class<? extends Annotation> TIMEOUT_ANNOTATION_CLASS;

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return interceptionAnnotationClasses.keySet();
    }

    public static boolean supportsTimeoutMethods() {
        return TIMEOUT_ANNOTATION_CLASS != null;
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return interceptionAnnotationClasses.get((Object)interceptionType);
    }

    static {
        TIMEOUT_ANNOTATION_CLASS = null;
        interceptionAnnotationClasses = new HashMap<InterceptionType, Class<? extends Annotation>>();
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, ReflectionUtils.classForName(interceptionType.getAnnotationClassName()));
            }
            catch (Exception e) {
                LOG.warn("Class '" + interceptionType.getAnnotationClassName() + "' not found, interception based on it is not enabled");
            }
        }
        try {
            TIMEOUT_ANNOTATION_CLASS = ReflectionUtils.classForName("javax.ejb.Timeout");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

