/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Set;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.validator.GraphValidator;
import org.richfaces.validator.NullValueValidator;
import org.richfaces.validator.ObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesBeanValidator
implements NullValueValidator,
Serializable,
GraphValidator {
    private static final long serialVersionUID = -264568176252121853L;
    public static final String BEAN_VALIDATOR_TYPE = "org.richfaces.BeanValidator";
    private ValueExpression summaryExpression = null;
    private String summary = null;
    private ValueExpression profilesExpression = null;
    private Object profiles = null;

    public String getSummary() {
        String summaryString = null;
        summaryString = null != this.summaryExpression ? (String)this.summaryExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.summary;
        return summaryString;
    }

    public void setSummary(ValueExpression summary) {
        this.summaryExpression = summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void validate(FacesContext context, UIComponent component, Object convertedValue) throws ValidatorException {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            try {
                String[] messages;
                ValueExpression valueExpression = component.getValueExpression("value");
                if (null != valueExpression && null != (messages = ObjectValidator.getInstance(context).validate(context, valueExpression, convertedValue, this.getProfiles()))) {
                    input.setValid(false);
                    Object label = FacesBeanValidator.getLabel(context, component);
                    Locale locale = context.getViewRoot().getLocale();
                    for (String msg : messages) {
                        msg = FacesBeanValidator.formatMessage(msg, locale, label, convertedValue);
                        String summaryString = this.getSummary() != null ? this.getSummary() : msg;
                        summaryString = FacesBeanValidator.formatMessage(summaryString, locale, label, convertedValue);
                        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryString, msg));
                    }
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    static String formatMessage(String msg, Locale locale, Object ... messageParams) {
        if (msg.contains("{")) {
            MessageFormat messageFormat = new MessageFormat(msg, locale);
            msg = messageFormat.format(messageParams);
        }
        return msg;
    }

    static Object getLabel(FacesContext context, UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (null == label || 0 == label.toString().length()) {
            label = component.getClientId(context);
        }
        return label;
    }

    public String[] validateGraph(FacesContext context, UIComponent component, Object value, Object profiles) throws ValidatorException {
        ObjectValidator beanValidator = ObjectValidator.getInstance(context);
        String[] messages = beanValidator.validateGraph(context, value, AjaxRendererUtils.asSet((Object)profiles));
        return messages;
    }

    public Set<String> getProfiles() {
        Object profiles = null != this.profilesExpression ? this.profilesExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.profiles;
        return AjaxRendererUtils.asSet((Object)profiles);
    }

    public void setProfiles(Object profiles) {
        this.profiles = profiles;
    }

    public void setProfiles(ValueExpression profilesExpression) {
        this.profilesExpression = profilesExpression;
    }
}

