/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.Set;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public abstract class AbstractDeploymentClassLoaderPolicyModule
extends ClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    private static ControllerState CLASSLOADER_STATE = ControllerState.newState((String)DeploymentStages.CLASSLOADER.getName());
    private DeploymentUnit unit;

    private static ClassLoadingMetaData determineClassLoadingMetaData(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        return (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
    }

    private static String determineContextName(DeploymentUnit unit, boolean addAlias) {
        Set aliases;
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        ControllerContext context = (ControllerContext)unit.getTopLevel().getAttachment(ControllerContext.class);
        if (context == null) {
            throw new IllegalStateException("Deployment has no controller context");
        }
        String contextName = unit.getName();
        if (!contextName.equals(context.getName()) && ((aliases = context.getAliases()) == null || aliases != null && !aliases.contains(contextName))) {
            Controller controller = context.getController();
            if (addAlias) {
                try {
                    controller.addAlias((Object)contextName, context.getName());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error adding deployment alias " + contextName + " to " + context, t);
                }
            } else {
                controller.removeAlias((Object)contextName);
            }
        }
        return contextName;
    }

    public AbstractDeploymentClassLoaderPolicyModule(DeploymentUnit unit) {
        super(AbstractDeploymentClassLoaderPolicyModule.determineClassLoadingMetaData(unit), AbstractDeploymentClassLoaderPolicyModule.determineContextName(unit, true));
        this.unit = unit;
        ControllerContext context = (ControllerContext)unit.getTopLevel().getAttachment(ControllerContext.class);
        this.setControllerContext(context);
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public ControllerState getClassLoaderState() {
        return CLASSLOADER_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            super.release();
        }
        finally {
            AbstractDeploymentClassLoaderPolicyModule.determineContextName(this.unit, false);
        }
    }
}

