/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.deployer.Deployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedDeployers {
    Map<String, List<Entry>> outputMap = new HashMap<String, List<Entry>>();
    Map<String, List<Entry>> inputMap = new HashMap<String, List<Entry>>();
    ArrayList<Entry> entries = new ArrayList();
    ArrayList<Deployer> deployers = new ArrayList();

    public void addOutputs(Entry deployer) {
        if (deployer.getOutputs() == null) {
            return;
        }
        for (String output : deployer.getOutputs()) {
            List<Entry> list = this.outputMap.get(output);
            if (list == null) {
                list = new ArrayList<Entry>();
                this.outputMap.put(output, list);
            }
            list.add(deployer);
        }
    }

    public void addInputs(Entry deployer) {
        if (deployer.getInputs() == null) {
            return;
        }
        for (String input : deployer.getInputs()) {
            List<Entry> list = this.inputMap.get(input);
            if (list == null) {
                list = new ArrayList<Entry>();
                this.inputMap.put(input, list);
            }
            list.add(deployer);
        }
    }

    public void sort(Deployer d) {
        Entry n = new Entry(d);
        this.addOutputs(n);
        this.addInputs(n);
        if (this.entries.size() == 0) {
            this.insertAt(n);
            this.deployers.clear();
            for (Entry entry : this.entries) {
                this.deployers.add(entry.deployer);
            }
            return;
        }
        this.insertAfterInputs(n);
        IdentityHashMap visited = new IdentityHashMap();
        this.traverseOutputs(n, visited);
        this.relativeOrdering();
        this.deployers = new ArrayList();
        for (Entry entry : this.entries) {
            this.deployers.add(entry.deployer);
        }
    }

    public void removeDeployer(Deployer d) {
        List<Entry> list;
        Entry removed = null;
        int esize = this.entries.size();
        for (int i = 0; i < esize; ++i) {
            if (this.entries.get((int)0).deployer != d) continue;
            removed = this.entries.get(0);
            this.removeAt(i);
            break;
        }
        if (d.getInputs() != null) {
            for (String input : d.getInputs()) {
                list = this.inputMap.get(input);
                if (list == null) continue;
                list.remove(removed);
            }
        }
        if (d.getOutputs() != null) {
            for (String output : d.getOutputs()) {
                list = this.outputMap.get(output);
                if (list == null) continue;
                list.remove(removed);
            }
        }
        this.deployers = new ArrayList();
        for (Entry entry : this.entries) {
            this.deployers.add(entry.deployer);
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    private void traverseOutputs(Entry n, IdentityHashMap visited) {
        if (n.getOutputs() == null) {
            return;
        }
        if (visited.containsKey(n)) {
            throw new IllegalStateException("Deployer " + n + " is involved in a cyclic dependency.");
        }
        visited.put(n, n);
        for (String output : n.getOutputs()) {
            List<Entry> inputs = this.inputMap.get(output);
            if (inputs == null) continue;
            for (Entry deployer : inputs) {
                if (deployer.getIndex() >= n.getIndex() || n.getInputs().contains(output) && deployer.getOutputs().contains(output)) continue;
                this.removeAt(deployer.getIndex());
                deployer.setIndex(0);
                this.insertAfterInputs(deployer);
                this.traverseOutputs(deployer, visited);
            }
        }
    }

    private void insertAfterInputs(Entry n) {
        Set<String> nInputs = n.getInputs();
        Set<String> nOutputs = n.getOutputs();
        if (nInputs == null) {
            return;
        }
        for (String input : nInputs) {
            List<Entry> outputs = this.outputMap.get(input);
            if (outputs == null) continue;
            for (Entry deployer : outputs) {
                if (deployer == n || deployer.getIndex() < n.getIndex() || nOutputs.contains(input) && deployer.getInputs().contains(input)) continue;
                n.setIndex(deployer.getIndex() + 1);
            }
        }
        this.insertAt(n);
    }

    void insertAt(Entry n) {
        this.entries.add(n.getIndex(), n);
        int esize = this.entries.size();
        for (int i = n.getIndex() + 1; i < esize; ++i) {
            this.entries.get(i).setIndex(i);
        }
    }

    void removeAt(int index) {
        this.entries.remove(index);
        int esize = this.entries.size();
        for (int i = index; i < esize; ++i) {
            this.entries.get(i).setIndex(i);
        }
    }

    public void relativeOrdering() {
        int esize = this.entries.size();
        for (int i = 0; i < esize - 1; ++i) {
            Entry d1 = this.entries.get(i);
            Entry d2 = this.entries.get(i + 1);
            if (d1.getRelativeOrder() == d2.getRelativeOrder()) {
                String name2;
                String name1 = d1.toString();
                if (name1.compareTo(name2 = d2.toString()) < 0 || !this.isIOEqual(d1, d2)) continue;
                this.swap(i, d1, d2);
                continue;
            }
            boolean isEqual = this.isIOEqual(d1, d2);
            if (!isEqual || d2.getRelativeOrder() >= d1.getRelativeOrder()) continue;
            this.swap(i, d1, d2);
        }
    }

    private void swap(int i, Entry d1, Entry d2) {
        this.entries.set(i + 1, d1);
        d1.setIndex(i + 1);
        this.entries.set(i, d2);
        d2.setIndex(i);
    }

    private boolean isIOEqual(Entry d1, Entry d2) {
        boolean isEqual = true;
        Set<String> d1Outputs = d1.getOutputs();
        if (d1Outputs == null) {
            return true;
        }
        for (String output : d1Outputs) {
            List<Entry> inputs = this.inputMap.get(output);
            if (inputs == null || !inputs.contains(d2) || d1.getInputs().contains(output) && d2.getOutputs().contains(output)) continue;
            isEqual = false;
            break;
        }
        return isEqual;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        public Deployer deployer;
        public int index;
        private String nameCache;

        private Entry(Deployer deployer) {
            this.deployer = deployer;
        }

        public Set<String> getInputs() {
            if (this.deployer.getInputs() == null) {
                return Collections.emptySet();
            }
            return this.deployer.getInputs();
        }

        public Set<String> getOutputs() {
            if (this.deployer.getOutputs() == null) {
                return Collections.emptySet();
            }
            return this.deployer.getOutputs();
        }

        public int getRelativeOrder() {
            return this.deployer.getRelativeOrder();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String toString() {
            if (this.nameCache == null) {
                this.nameCache = this.deployer.toString();
            }
            return this.nameCache;
        }
    }
}

