/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.as.server.JBossASBasedServerProvider;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.system.server.jmx.JMXKernelMBean;
import org.jboss.system.server.jmx.LazyMBeanServer;
import org.jboss.util.JBossObject;
import org.jboss.util.file.FileSuffixFilter;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXKernel<K extends JBossASBasedServerProvider<K, T>, T extends JBossASBasedServerConfig<T>>
extends JBossObject
implements JMXKernelMBean<K, T>,
NotificationEmitter {
    private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger(JMXKernel.class);
    private MBeanServer mbeanServer;
    private K serverImpl;
    private ServiceController controller;
    private T serverConfig;
    private ServerConfigImplMBean<T> serverConfigMBean;
    private ServerInfoMBean serverInfo;
    private Kernel kernel;
    private NotificationEmitter notificationEmitter;
    private ObjectName bootstrapUCLName;
    private boolean started;
    private boolean oldClassLoader;

    public JMXKernel() {
        super(log);
    }

    public K getServerImpl() {
        return this.serverImpl;
    }

    public void setServerImpl(K serverImpl) {
        this.serverImpl = serverImpl;
        this.notificationEmitter = (NotificationEmitter)serverImpl;
    }

    public ServiceControllerMBean getServiceController() {
        return this.controller;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public ServerInfoMBean getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfoMBean serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public boolean isOldClassLoader() {
        return this.oldClassLoader;
    }

    public void setOldClassLoader(boolean oldClassLoader) {
        this.oldClassLoader = oldClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        ClassLoader cl;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        String builder = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        System.setProperty("javax.management.builder.initial", builder);
        this.serverConfig = (JBossASBasedServerConfig)this.serverImpl.getConfiguration();
        this.serverConfigMBean = new ServerConfigImpl<T>(this.serverConfig);
        if (this.serverConfig.isUsePlatformMBeanServer().booleanValue()) {
            cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass("java.lang.management.ManagementFactory");
            Class<?>[] sig = null;
            Method method = clazz.getMethod("getPlatformMBeanServer", sig);
            Object[] args = null;
            this.mbeanServer = (MBeanServer)method.invoke(null, args);
            MBeanServerLocator.setJBoss((MBeanServer)this.mbeanServer);
            this.mbeanServer = LazyMBeanServer.resetToJBossServer(this.mbeanServer);
        } else {
            this.mbeanServer = MBeanServerFactory.createMBeanServer("jboss");
        }
        log.debug((Object)("Created MBeanServer: " + this.mbeanServer));
        this.mbeanServer.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.mbeanServer.registerMBean(this.serverConfigMBean, ServerConfigImplMBean.OBJECT_NAME);
        cl = this.oldClassLoader ? this.initBootLibrariesOld() : this.initBootLibraries();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.mbeanServer.registerMBean(this.serverInfo, new ObjectName("jboss.system:type=ServerInfo"));
            this.controller = new ServiceController();
            this.controller.setKernel(this.kernel);
            this.controller.setMBeanServer(this.mbeanServer);
            this.mbeanServer.registerMBean(this.controller, new ObjectName("jboss.system:service=ServiceController"));
            log.info((Object)"Legacy JMX core initialized");
            this.started = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }

    public void stop() throws IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"stop caller:", new Throwable("Here"));
        }
        if (!this.started) {
            throw new IllegalStateException("Server not started");
        }
        log.debug((Object)"Shutting down all services");
        this.shutdownServices();
        this.removeMBeans();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationEmitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationEmitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationEmitter.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationEmitter.getNotificationInfo();
    }

    public void init(Properties props) throws Exception {
        this.serverImpl.initialize();
    }

    public T getConfig() {
        return this.serverConfig;
    }

    public Map<String, Object> getMetaData() {
        return Collections.emptyMap();
    }

    public String getBuildDate() {
        return this.serverImpl.getBuildDate();
    }

    public String getBuildID() {
        return this.serverImpl.getBuildID();
    }

    public String getBuildJVM() {
        return this.serverImpl.getBuildJVM();
    }

    public String getBuildNumber() {
        return this.serverImpl.getBuildNumber();
    }

    public String getBuildOS() {
        return this.serverImpl.getBuildOS();
    }

    public Date getStartDate() {
        return this.serverImpl.getStartDate();
    }

    public String getVersion() {
        return this.serverImpl.getVersion();
    }

    public String getVersionName() {
        return this.serverImpl.getVersionName();
    }

    public String getVersionNumber() {
        return this.serverImpl.getVersionNumber();
    }

    public boolean isInShutdown() {
        return this.serverImpl.getState().equals((Object)LifecycleState.STOPPING);
    }

    public boolean isStarted() {
        return this.serverImpl.getState().equals((Object)LifecycleState.STARTED);
    }

    @Override
    public void runFinalization() {
    }

    @Override
    public void runGarbageCollector() {
    }

    @Override
    public void traceInstructions(Boolean flag) {
    }

    @Override
    public void traceMethodCalls(Boolean flag) {
    }

    public void shutdown() {
        new Thread(){

            public void run() {
                log.info((Object)"Server exit called, exiting the JVM now!");
                Runtime.getRuntime().exit(1);
            }
        }.start();
    }

    protected void shutdownServices() {
        try {
            this.controller.shutdown();
        }
        catch (Exception e) {
            Throwable t = JMXExceptionDecoder.decode((Throwable)e);
            log.error((Object)"Failed to shutdown services", t);
        }
    }

    protected void removeMBeans() {
        Throwable t;
        try {
            this.mbeanServer.unregisterMBean(ServerConfigImplMBean.OBJECT_NAME);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            log.error((Object)"Failed to unregister mbeans", t);
        }
        try {
            this.mbeanServer.unregisterMBean(ServerImplMBean.OBJECT_NAME);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            log.error((Object)"Failed to unregister mbeans", t);
        }
        try {
            MBeanServer registeredServer = this.mbeanServer;
            if (this.serverConfig.isUsePlatformMBeanServer().booleanValue()) {
                registeredServer = LazyMBeanServer.getRegisteredMBeanServer(this.mbeanServer);
            }
            MBeanServerFactory.releaseMBeanServer(registeredServer);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            log.error((Object)"Failed to release mbean mbeanServer", t);
        }
    }

    private List<URL> getBootURLs() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        URL patchURL = null;
        if (patchURL != null) {
            if (patchURL.getProtocol().equals("file")) {
                File dir = new File(patchURL.getFile());
                if (dir.exists()) {
                    list.add(dir.toURI().toURL());
                    File[] jars = dir.listFiles((FileFilter)new FileSuffixFilter(new String[]{".jar", ".zip"}, true));
                    for (int j = 0; jars != null && j < jars.length; ++j) {
                        list.add(jars[j].getCanonicalFile().toURI().toURL());
                    }
                }
            } else {
                list.add(patchURL);
            }
        }
        list.add(this.serverConfig.getServerConfLocation());
        log.debug((Object)("Boot url list: " + list));
        return list;
    }

    private ClassLoader initBootLibrariesOld() throws Exception {
        List<URL> list = this.getBootURLs();
        RepositoryClassLoader loader = null;
        for (URL url : list) {
            log.debug((Object)("Creating loader for URL: " + url));
            Object[] args = new Object[]{url, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "boolean"};
            loader = (RepositoryClassLoader)this.mbeanServer.invoke(DEFAULT_LOADER_NAME, "newClassLoader", args, sig);
        }
        this.bootstrapUCLName = loader.getObjectName();
        this.mbeanServer.registerMBean(loader, this.bootstrapUCLName);
        return loader;
    }

    private ClassLoader initBootLibraries() throws Exception {
        ClassLoaderSystem system = ClassLoaderSystem.getInstance();
        this.mbeanServer.registerMBean(system, new ObjectName("jboss.classloader:service=ClassLoaderSystem"));
        List<URL> list = this.getBootURLs();
        VirtualFile[] files = new VirtualFile[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            URL url = list.get(i);
            files[i] = VFS.getRoot((URL)url);
        }
        VFSClassLoaderPolicy policy = new VFSClassLoaderPolicy(files);
        policy.setExportAll(ExportAll.NON_EMPTY);
        policy.setImportAll(true);
        ClassLoader classLoader = system.registerClassLoaderPolicy((ClassLoaderPolicy)policy);
        if (classLoader instanceof RealClassLoader) {
            this.bootstrapUCLName = ((RealClassLoader)classLoader).getObjectName();
        }
        return classLoader;
    }

    public Map<String, KernelDeployment> getDeployments() {
        return this.serverImpl.getDeployments();
    }

    public Kernel getKernel() {
        return this.serverImpl.getKernel();
    }

    public void addBootstrap(Bootstrap<K, T> arg0) throws IllegalArgumentException {
        this.serverImpl.addBootstrap(arg0);
    }

    public ConfigurationInitializer<T> getConfigInitializer() {
        return this.serverImpl.getConfigInitializer();
    }

    public T getConfiguration() {
        return (T)((JBossASBasedServerConfig)this.serverImpl.getConfiguration());
    }

    public ServerInitializer<K, T> getServerInitializer() {
        return this.serverImpl.getServerInitializer();
    }

    public LifecycleState getState() {
        return this.serverImpl.getState();
    }

    public ConfigurationValidator<T> getValidator() {
        return this.serverImpl.getValidator();
    }

    public void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        this.serverImpl.initialize();
    }

    public void registerEventHandler(LifecycleEventHandler arg0, EnumSet<LifecycleState> arg1) throws IllegalArgumentException {
        this.serverImpl.registerEventHandler(arg0, arg1);
    }

    public void registerEventHandler(LifecycleEventHandler arg0, LifecycleState ... arg1) throws IllegalArgumentException {
        this.serverImpl.registerEventHandler(arg0, arg1);
    }

    public void registerEventHandler(LifecycleState arg0, LifecycleEventHandler arg1) throws IllegalArgumentException {
        this.serverImpl.registerEventHandler(arg0, arg1);
    }

    public void registerEventHandlers(LifecycleState arg0, LifecycleEventHandler ... arg1) throws IllegalArgumentException {
        this.serverImpl.registerEventHandlers(arg0, arg1);
    }

    public void removeBootstrap(Bootstrap<K, T> arg0) throws IllegalArgumentException {
        this.serverImpl.removeBootstrap(arg0);
    }

    public void setConfigInitializer(ConfigurationInitializer<T> arg0) throws IllegalStateException {
        this.serverImpl.setConfigInitializer(arg0);
    }

    public void setConfiguration(T arg0) {
        this.serverImpl.setConfiguration(arg0);
    }

    public void setServerInitializer(ServerInitializer<K, T> arg0) throws IllegalStateException {
        this.serverImpl.setServerInitializer(arg0);
    }

    public void setValidator(ConfigurationValidator<T> arg0) throws IllegalStateException {
        this.serverImpl.setValidator(arg0);
    }

    public boolean unregisterEventHandler(LifecycleEventHandler arg0, LifecycleState arg1) throws IllegalArgumentException {
        return this.serverImpl.unregisterEventHandler(arg0, arg1);
    }
}

