/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.client.upload;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.DeploymentTarget;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.profileservice.management.client.upload.SerializableDeploymentStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentProgressImpl
implements DeploymentProgress,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient CopyOnWriteArrayList<ProgressListener> listeners = new CopyOnWriteArrayList();
    private transient DeploymentStatus currentStatus;
    private transient boolean isCancelled;
    private List<DeploymentTarget> targets;
    private DeploymentID deployment;
    private DeploymentStatus.CommandType command;

    public DeploymentProgressImpl(List<DeploymentTarget> targets, DeploymentID deployment, DeploymentStatus.CommandType command) {
        this.targets = targets;
        this.deployment = deployment;
        this.command = command;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    public void run() {
        switch (this.command) {
            case DISTRIBUTE: {
                this.distribute();
                break;
            }
            case PREPARE: {
                this.prepare();
                break;
            }
            case START: {
                this.start();
                break;
            }
            case STOP: {
                this.stop();
                break;
            }
            case REMOVE: {
                this.remove();
                break;
            }
            case REDEPLOY: {
                this.redeploy();
                break;
            }
            default: {
                throw new IllegalStateException(this.command + " is not currently handled");
            }
        }
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.currentStatus;
    }

    public DeploymentID getDeploymentID() {
        return this.deployment;
    }

    public List<DeploymentTarget> getDeploymentTargets() {
        return this.targets;
    }

    protected void notify(ProgressEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (ProgressListener listener : this.listeners) {
            try {
                listener.progressEvent(event);
            }
            catch (Throwable ignore) {}
        }
    }

    protected void distribute() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.DEPLOYING);
        status.setMessage("Running distribute to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Distribute has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.UPLOADING);
                status.setTarget(target);
                status.setRunning(true);
                status.setMessage("Begining distribute to target: " + target);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                target.distribute(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.DEPLOYING);
                status.setTarget(target);
                status.setMessage("Completed distribute to target: " + target);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
        if (!this.currentStatus.isFailed()) {
            status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
            status.setMessage("Completed distribute to all targets");
            status.setCompleted(true);
            this.currentStatus = status;
            event = new ProgressEvent(this.deployment, this.currentStatus);
            this.notify(event);
        }
    }

    protected void start() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.RUNNING);
        status.setMessage("Running start to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Start has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                target.start(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
                status.setTarget(target);
                status.setMessage("Completed start for target: " + target);
                status.setCompleted(true);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
    }

    protected void stop() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.RUNNING);
        status.setMessage("Running stop to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Stop has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                target.stop(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
                status.setTarget(target);
                status.setMessage("Completed stop for target: " + target);
                status.setCompleted(true);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
    }

    protected void remove() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.RUNNING);
        status.setMessage("Running undeploy to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Undeploy has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                target.remove(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
                status.setTarget(target);
                status.setMessage("Completed undeploy for target: " + target);
                status.setCompleted(true);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
    }

    protected void redeploy() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.RUNNING);
        status.setMessage("Running redeploy to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Redeploy has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                target.redeploy(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
                status.setTarget(target);
                status.setMessage("Completed redeploy for target: " + target);
                status.setCompleted(true);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
    }

    protected void prepare() {
        SerializableDeploymentStatus status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.RUNNING);
        status.setMessage("Running prepare to: " + this.targets);
        status.setRunning(true);
        this.currentStatus = status;
        ProgressEvent event = new ProgressEvent(this.deployment, this.currentStatus);
        this.notify(event);
        for (DeploymentTarget target : this.targets) {
            if (this.isCancelled) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.CANCELLED);
                status.setMessage("Prepare has been cancelled");
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
                break;
            }
            try {
                target.prepare(this.deployment);
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.COMPLETED);
                status.setTarget(target);
                status.setMessage("Completed prepare for target: " + target);
                status.setCompleted(true);
                this.currentStatus = status;
                event = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(event);
            }
            catch (Exception e) {
                status = new SerializableDeploymentStatus(this.command, DeploymentStatus.StateType.FAILED);
                status.setTarget(target);
                status.setFailure(e);
                status.setFailed(true);
                this.currentStatus = status;
                ProgressEvent error = new ProgressEvent(this.deployment, this.currentStatus);
                this.notify(error);
                break;
            }
        }
    }
}

