/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.exception.MessagingTransactionRolledBackException;
import org.jboss.jms.exception.MessagingXAException;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.tx.ClientTransaction;
import org.jboss.jms.tx.LocalTx;
import org.jboss.jms.tx.TransactionRequest;
import org.jboss.logging.Logger;

public class ResourceManager {
    private boolean trace = log.isTraceEnabled();
    private ConcurrentHashMap transactions = new ConcurrentHashMap();
    private ConcurrentHashMap convertedIds = new ConcurrentHashMap();
    private int serverID;
    private static final Logger log = Logger.getLogger(ResourceManager.class);

    ResourceManager(int serverID) {
        this.serverID = serverID;
    }

    public int getServerID() {
        return this.serverID;
    }

    public void merge(ResourceManager other) {
        this.transactions.putAll((Map)other.transactions);
    }

    public ClientTransaction removeTx(Object xid) {
        return this.removeTxInternal(xid);
    }

    public LocalTx createLocalTx() {
        ClientTransaction tx = new ClientTransaction();
        LocalTx xid = this.getNextTxId();
        this.transactions.put((Object)xid, (Object)tx);
        return xid;
    }

    public void addMessage(Object xid, String sessionId, JBossMessage m) {
        if (this.trace) {
            log.trace((Object)("addding message " + m + " for xid " + xid));
        }
        ClientTransaction tx = this.getTxInternal(xid);
        tx.addMessage(sessionId, m);
    }

    public void handleFailover(int newServerID, String oldSessionID, String newSessionID) {
        for (ClientTransaction tx : this.transactions.values()) {
            tx.handleFailover(newServerID, oldSessionID, newSessionID);
        }
    }

    public List getDeliveriesForSession(String sessionID) {
        ArrayList ackInfos = new ArrayList();
        for (ClientTransaction tx : this.transactions.values()) {
            List acks = tx.getDeliveriesForSession(sessionID);
            ackInfos.addAll(acks);
        }
        return ackInfos;
    }

    public void addAck(Object xid, String sessionId, DeliveryInfo ackInfo) throws JMSException {
        ClientTransaction tx;
        if (this.trace) {
            log.trace((Object)("adding " + ackInfo + " to transaction " + xid));
        }
        if ((tx = this.getTxInternal(xid)) == null) {
            throw new JMSException("There is no transaction with id " + xid);
        }
        tx.addAck(sessionId, ackInfo);
    }

    public void commitLocal(LocalTx xid, ConnectionDelegate connection) throws JMSException {
        ClientTransaction tx;
        if (this.trace) {
            log.trace((Object)("committing " + xid));
        }
        if ((tx = this.getTxInternal(xid)) == null) {
            throw new IllegalStateException("Cannot find transaction " + xid);
        }
        TransactionRequest request = new TransactionRequest(0, null, tx);
        try {
            connection.sendTransaction(request, false);
            if (this.removeTxInternal(xid) == null) {
                throw new IllegalStateException("Cannot find xid to remove " + xid);
            }
        }
        catch (JMSSecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            this.rollbackLocal(xid);
            MessagingTransactionRolledBackException e = new MessagingTransactionRolledBackException(t.getMessage());
            e.initCause(t);
            throw e;
        }
    }

    public void rollbackLocal(Object xid) throws JMSException {
        ClientTransaction ts;
        if (this.trace) {
            log.trace((Object)("rolling back local xid " + xid));
        }
        if ((ts = this.removeTxInternal(xid)) == null) {
            throw new IllegalStateException("Cannot find transaction with xid:" + xid);
        }
        ts.clearMessages();
        this.redeliverMessages(ts);
    }

    public ClientTransaction getTx(Object xid) {
        return this.getTxInternal(xid);
    }

    public int size() {
        return this.transactions.size();
    }

    public boolean checkForAcksInSession(String sessionId) {
        for (Map.Entry entry : this.transactions.entrySet()) {
            List dels;
            ClientTransaction tx = (ClientTransaction)entry.getValue();
            if (tx.getState() != 2 || (dels = tx.getDeliveriesForSession(sessionId)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    Xid startTx(Xid xid) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("starting " + xid));
        }
        if ((state = this.getTxInternal(xid)) != null) {
            throw new MessagingXAException(-8, "Transaction already exists with xid " + xid);
        }
        this.transactions.put((Object)xid, (Object)new ClientTransaction());
        return xid;
    }

    void endTx(Xid xid, boolean success) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("ending " + xid + ", success=" + success));
        }
        if ((state = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        state.setState((byte)1);
    }

    int prepare(Xid xid, ConnectionDelegate connection) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("preparing " + xid));
        }
        if ((state = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        TransactionRequest request = new TransactionRequest(2, xid, state);
        this.sendTransactionXA(request, connection);
        state.setState((byte)2);
        if (this.trace) {
            log.trace((Object)("State is now: " + state.getState()));
        }
        return 0;
    }

    void commit(Xid xid, boolean onePhase, ConnectionDelegate connection) throws XAException {
        if (this.trace) {
            log.trace((Object)("commiting xid " + xid + ", onePhase=" + onePhase));
        }
        ClientTransaction tx = this.removeTxInternal(xid);
        if (this.trace) {
            log.trace((Object)("got tx: " + tx + " state " + tx.getState()));
        }
        if (onePhase) {
            if (tx == null) {
                throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
            }
            TransactionRequest request = new TransactionRequest(0, null, tx);
            request.state = tx;
            this.sendTransactionXA(request, connection);
        } else {
            if (tx != null && tx.getState() != 2) {
                throw new MessagingXAException(-6, "commit called for transaction, but it is not prepared");
            }
            TransactionRequest request = new TransactionRequest(3, xid, null);
            request.xid = xid;
            this.sendTransactionXA(request, connection);
        }
        if (tx != null) {
            tx.setState((byte)3);
        }
    }

    void rollback(Xid xid, ConnectionDelegate connection) throws XAException {
        ClientTransaction tx;
        if (this.trace) {
            log.trace((Object)("rolling back xid " + xid));
        }
        if ((tx = this.removeTxInternal(xid)) == null) {
            throw new java.lang.IllegalStateException("Cannot find xid to remove " + xid);
        }
        TransactionRequest request = null;
        if (tx != null) {
            tx.clearMessages();
        }
        if (tx == null || tx.getState() == 2) {
            request = new TransactionRequest(4, xid, tx);
            if (this.trace) {
                log.trace((Object)("Sending rollback to server, tx:" + tx));
            }
            this.sendTransactionXA(request, connection);
        } else if (tx == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        if (this.trace) {
            log.trace((Object)("Redelivering messages, tx:" + tx));
        }
        try {
            if (tx != null) {
                this.redeliverMessages(tx);
                tx.setState((byte)4);
            }
        }
        catch (JMSException e) {
            log.error((Object)"Failed to redeliver", (Throwable)e);
        }
    }

    Xid joinTx(Xid xid) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("joining  " + xid));
        }
        if ((state = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        return xid;
    }

    Xid resumeTx(Xid xid) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("resuming " + xid));
        }
        if ((state = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        return xid;
    }

    Xid suspendTx(Xid xid) throws XAException {
        ClientTransaction state;
        if (this.trace) {
            log.trace((Object)("suspending " + xid));
        }
        if ((state = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + xid);
        }
        return xid;
    }

    Xid convertTx(LocalTx localTx, Xid xid) throws XAException {
        ClientTransaction newTx;
        if (this.trace) {
            log.trace((Object)("converting " + localTx + " to " + xid));
        }
        if ((newTx = this.getTxInternal(xid)) != null) {
            throw new MessagingXAException(-8, "Transaction already exists:" + xid);
        }
        ClientTransaction local = this.removeTxInternal(localTx);
        if (local == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + localTx);
        }
        this.transactions.put((Object)xid, (Object)local);
        return xid;
    }

    Xid convertOnJoinTx(LocalTx localTx, Xid xid) throws XAException {
        ClientTransaction newTx;
        if (this.trace) {
            log.trace((Object)("converting " + localTx + " to " + xid));
        }
        if ((newTx = this.getTxInternal(xid)) == null) {
            throw new MessagingXAException(-8, "Transaction doesnt exist:" + xid);
        }
        ClientTransaction local = this.removeTxInternal(localTx);
        if (local == null) {
            throw new MessagingXAException(-4, "Cannot find transaction with xid:" + localTx);
        }
        newTx.mergeIn(local);
        return xid;
    }

    Xid[] recover(int flags, ConnectionDelegate conn) throws XAException {
        if (this.trace) {
            log.trace((Object)("calling recover with flags: " + flags));
        }
        if (flags == 0x1000000) {
            try {
                Xid[] txs = conn.getPreparedTransactions();
                if (this.trace) {
                    log.trace((Object)("Got " + txs.length + " transactions from server"));
                }
                for (int i = 0; i < txs.length; ++i) {
                    if (this.transactions.containsKey((Object)txs[i])) continue;
                    ClientTransaction tx = new ClientTransaction();
                    tx.setState((byte)2);
                    this.transactions.put((Object)txs[i], (Object)tx);
                }
                return txs;
            }
            catch (JMSException e) {
                throw new MessagingXAException(-7, "Failed to get prepared transactions");
            }
        }
        return new Xid[0];
    }

    Map getTransactions() {
        return this.transactions;
    }

    private ClientTransaction getTxInternal(Object xid) {
        if (this.trace) {
            log.trace((Object)("getting transaction for " + xid));
        }
        return (ClientTransaction)this.transactions.get(xid);
    }

    private ClientTransaction removeTxInternal(Object xid) {
        return (ClientTransaction)this.transactions.remove(xid);
    }

    private void redeliverMessages(ClientTransaction ts) throws JMSException {
        List sessionStates = ts.getSessionStates();
        Collections.reverse(sessionStates);
        for (ClientTransaction.SessionTxState state : sessionStates) {
            List acks = state.getAcks();
            if (acks.isEmpty()) continue;
            DeliveryInfo info = (DeliveryInfo)acks.get(0);
            MessageProxy mp = info.getMessageProxy();
            SessionDelegate del = mp.getSessionDelegate();
            del.redeliver(acks);
        }
    }

    private synchronized LocalTx getNextTxId() {
        return new LocalTx();
    }

    private void sendTransactionXA(TransactionRequest request, ConnectionDelegate connection) throws XAException {
        try {
            connection.sendTransaction(request, false);
        }
        catch (JMSSecurityException security) {
            MessagingXAException xaEx = new MessagingXAException(100, "A security exception happend!", security);
            log.error((Object)xaEx, (Throwable)xaEx);
            throw xaEx;
        }
        catch (Throwable t) {
            if (request.getRequestType() == 2) {
                String oldBehaviour = System.getProperty("retain.oldxabehaviour");
                if (oldBehaviour != null) {
                    throw new MessagingXAException(4, "A Throwable was caught in sending the transaction", t);
                }
                throw new MessagingXAException(101, "A Throwable was caught in sending the transaction", t);
            }
            throw new MessagingXAException(4, "A Throwable was caught in sending the transaction", t);
        }
    }
}

