/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.BaseClassPool;

public class NonDelegatingClassPool
extends BaseClassPool {
    public NonDelegatingClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean parentFirst) {
        super(cl, src, repository, AOPClassPool.SEARCH_LOCAL_ONLY_STRATEGY);
        this.childFirstLookup = !parentFirst;
    }

    public CtClass createCtClass(String classname, boolean useCache) {
        boolean trace = this.logger.isTraceEnabled();
        CtClass clazz = null;
        if (!this.childFirstLookup) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " attempting to create " + classname + " in parent pool (parentFirst)"));
            }
            clazz = this.createParentCtClass(classname, useCache, trace);
        }
        if (clazz == null && this.isLocalResource(this.getResourceName(classname), trace)) {
            clazz = super.createCtClass(classname, useCache);
        }
        if (this.childFirstLookup && clazz == null) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " attempting to create " + classname + " in parent pool (parentLast)"));
            }
            clazz = this.createParentCtClass(classname, useCache, trace);
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " created " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
        }
        return clazz;
    }
}

