/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.entity.AbstractEntityLoader;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.Type;

public class EntityLoader
extends AbstractEntityLoader {
    private final boolean batchLoader;

    public EntityLoader(OuterJoinLoadable persister, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, 1, lockMode, factory, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable persister, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, 1, lockOptions, factory, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, persister.getIdentifierColumnNames(), persister.getIdentifierType(), batchSize, lockMode, factory, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(persister, persister.getIdentifierColumnNames(), persister.getIdentifierType(), batchSize, lockOptions, factory, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(persister, uniqueKeyType, factory, loadQueryInfluencers);
        EntityJoinWalker walker = new EntityJoinWalker(persister, uniqueKey, batchSize, lockMode, factory, loadQueryInfluencers);
        this.initFromWalker(walker);
        this.postInstantiate();
        this.batchLoader = batchSize > 1;
        log.debug("Static select for entity " + this.entityName + ": " + this.getSQLString());
    }

    public EntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(persister, uniqueKeyType, factory, loadQueryInfluencers);
        EntityJoinWalker walker = new EntityJoinWalker(persister, uniqueKey, batchSize, lockOptions, factory, loadQueryInfluencers);
        this.initFromWalker(walker);
        this.postInstantiate();
        this.batchLoader = batchSize > 1;
        log.debug("Static select for entity " + this.entityName + ": " + this.getSQLString());
    }

    public Object loadByUniqueKey(SessionImplementor session, Object key) throws HibernateException {
        return this.load(session, key, null, null);
    }

    protected boolean isSingleRowLoader() {
        return !this.batchLoader;
    }
}

