/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.classpool.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolRepository
implements ScopedClassPoolRepository {
    private static final ClassPoolRepository instance = new ClassPoolRepository();
    protected final ScopedClassPoolRepository delegate;
    private volatile List<ClassPoolRepositoryCallback> callbacks;
    private final ConcurrentMap<ClassLoader, Boolean> currentClassLoaders = new ConcurrentHashMap<ClassLoader, Boolean>();

    public static ClassPoolRepository getInstance() {
        return instance;
    }

    protected ClassPoolRepository() {
        this.delegate = ScopedClassPoolRepositoryImpl.getInstance();
    }

    public void setClassPoolFactory(ScopedClassPoolFactory factory) {
        this.delegate.setClassPoolFactory(factory);
    }

    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.delegate.getClassPoolFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPoolRepositoryCallback(ClassPoolRepositoryCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback");
        }
        if (this.callbacks == null) {
            ClassPoolRepository classPoolRepository = this;
            synchronized (classPoolRepository) {
                if (this.callbacks == null) {
                    this.callbacks = new CopyOnWriteArrayList<ClassPoolRepositoryCallback>();
                }
            }
        }
        this.callbacks.add(callback);
    }

    public List<ClassPoolRepositoryCallback> getClassPoolRepositoryCallbacks() {
        List<ClassPoolRepositoryCallback> cbs = this.callbacks;
        if (cbs == null || cbs.size() == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.callbacks);
    }

    public boolean removeClassPoolRepositoryCallback(ClassPoolRepositoryCallback callback) {
        if (callback == null) {
            return false;
        }
        if (this.callbacks == null) {
            return false;
        }
        return this.callbacks.remove(callback);
    }

    public boolean isPrune() {
        return this.delegate.isPrune();
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public ScopedClassPool createScopedClassPool(ClassLoader classLoader, ClassPool parent) {
        return this.delegate.createScopedClassPool(classLoader, parent);
    }

    public ClassPool findClassPool(ClassLoader classLoader) {
        return this.delegate.findClassPool(classLoader);
    }

    public Map<ClassLoader, ClassPool> getRegisteredCLs() {
        return this.delegate.getRegisteredCLs();
    }

    public void clearUnregisteredClassLoaders() {
        this.delegate.clearUnregisteredClassLoaders();
    }

    public ClassPool registerClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = SecurityActions.getContextClassLoader();
        }
        if (this.currentClassLoaders.putIfAbsent(classLoader, Boolean.TRUE) != null) {
            return null;
        }
        ScopedClassPool classPool = (ScopedClassPool)this.delegate.registerClassLoader(classLoader);
        this.currentClassLoaders.remove(classLoader);
        if (this.callbacks != null && this.callbacks.size() > 0) {
            for (ClassPoolRepositoryCallback callback : this.callbacks) {
                callback.classLoaderRegistered(classLoader);
            }
        }
        return classPool;
    }

    public void unregisterClassLoader(ClassLoader classLoader) {
        this.delegate.unregisterClassLoader(classLoader);
        if (this.callbacks != null && this.callbacks.size() > 0) {
            for (ClassPoolRepositoryCallback callback : this.callbacks) {
                callback.classLoaderUnregistered(classLoader);
            }
        }
    }
}

