/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.util;

import org.jboss.logging.Logger;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.binding.FeatureAware;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBHelper<T>
implements FeatureAware {
    private Logger log = Logger.getLogger(JBossXBHelper.class);
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private Class<T> output;
    private boolean useSchemaValidation = true;
    private boolean useValidation = true;

    public JBossXBHelper(Class<T> output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output.");
        }
        this.output = output;
    }

    @Override
    public void setFeature(String featureName, boolean flag) throws Exception {
        factory.setFeature(featureName, flag);
    }

    public boolean isUseSchemaValidation() {
        return this.useSchemaValidation;
    }

    public void setUseSchemaValidation(boolean useSchemaValidation) {
        this.useSchemaValidation = useSchemaValidation;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public void setUseValidation(boolean useValidation) {
        this.useValidation = useValidation;
    }

    public static void addClassBinding(String namespace, Class<?> metadata) {
        SingletonSchemaResolverFactory factory = SingletonSchemaResolverFactory.getInstance();
        MutableSchemaResolver resolver = factory.getSchemaBindingResolver();
        resolver.mapURIToClass(namespace, metadata);
    }

    public static void removeClassBinding(String namespace) {
        SingletonSchemaResolverFactory factory = SingletonSchemaResolverFactory.getInstance();
        MutableSchemaResolver resolver = factory.getSchemaBindingResolver();
        resolver.removeURIToClassMapping(namespace);
    }

    public void addTypeBinding(String namespace, Class<?> metadata) {
        this.getResolver().mapURIToClass(namespace, metadata);
    }

    public void removeTypeBinding(String namespace) {
        this.getResolver().removeURIToClassMapping(namespace);
    }

    protected MutableSchemaResolver getResolver() {
        SingletonSchemaResolverFactory factory = SingletonSchemaResolverFactory.getInstance();
        return factory.getSchemaBindingResolver();
    }

    public static String findNamespace(Class<?> metadata) {
        Package pckg;
        JBossXmlSchema jBossXmlSchema = metadata.getAnnotation(JBossXmlSchema.class);
        if (jBossXmlSchema == null && (pckg = metadata.getPackage()) != null) {
            jBossXmlSchema = pckg.getAnnotation(JBossXmlSchema.class);
        }
        return jBossXmlSchema != null ? jBossXmlSchema.namespace() : null;
    }

    public T parse(InputSource source) throws Exception {
        return this.parse(this.output, source);
    }

    public <U> U parse(Class<U> expectedType, InputSource source) throws Exception {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        if (source == null) {
            throw new IllegalArgumentException("Null source");
        }
        this.log.debug((Object)("Parsing file: " + source + " for type: " + expectedType));
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        Object parsed = unmarshaller.unmarshal(source, (SchemaBindingResolver)this.getResolver());
        if (parsed == null) {
            throw new Exception("The xml " + source + " is not well formed!");
        }
        this.log.debug((Object)("Parsed file: " + source + " to: " + parsed));
        return expectedType.cast(parsed);
    }

    public T parse(InputSource source, T root, ObjectModelFactory omf) throws Exception {
        return this.parse(this.output, source, root, omf);
    }

    public <U> U parse(Class<U> expectedType, InputSource source, U root, ObjectModelFactory omf) throws Exception {
        if (source == null) {
            throw new IllegalArgumentException("Null source");
        }
        this.log.debug((Object)("Parsing source: " + source + " for deploymentType: " + expectedType));
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        Object parsed = unmarshaller.unmarshal(source, omf, root);
        if (parsed == null) {
            throw new Exception("The xml " + source + " is not well formed!");
        }
        this.log.debug((Object)("Parsed file: " + source + " to: " + parsed));
        return expectedType.cast(parsed);
    }
}

