/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.jboss.on.common.jbossas.JBossASPaths;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ApplicationServerContentFacetDelegate;
import org.rhq.plugins.jbossas5.ApplicationServerOperationsDelegate;
import org.rhq.plugins.jbossas5.ApplicationServerSupportedOperations;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.LocalProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.RemoteProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.deploy.LocalDeployer;
import org.rhq.plugins.jbossas5.deploy.RemoteDeployer;
import org.rhq.plugins.jbossas5.helper.InPluginControlActionFacade;
import org.rhq.plugins.jbossas5.helper.JBossAS5ConnectionTypeDescriptor;
import org.rhq.plugins.jbossas5.helper.JmxConnectionHelper;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServerComponent
implements ResourceComponent,
ProfileServiceComponent,
CreateChildResourceFacet,
MeasurementFacet,
ConfigurationFacet,
ProgressListener,
ContentFacet,
OperationFacet {
    private static final String MANAGED_PROPERTY_GROUP = "managedPropertyGroup";
    private static final Pattern METRIC_NAME_PATTERN = Pattern.compile("(.*)\\|(.*)\\|(.*)\\|(.*)");
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext resourceContext;
    private ProfileServiceConnection connection;
    private JmxConnectionHelper jmxConnectionHelper;
    private ApplicationServerContentFacetDelegate contentFacetDelegate;
    private ApplicationServerOperationsDelegate operationDelegate;
    private LogFileEventResourceComponentHelper logFileEventDelegate;
    private AvailabilityCollectorRunnable availCollector;

    public AvailabilityType getAvailability() {
        if (this.availCollector != null) {
            return this.availCollector.getLastKnownAvailability();
        }
        return this.getAvailabilityNow();
    }

    private AvailabilityType getAvailabilityNow() {
        AvailabilityType availability;
        this.connectToProfileService();
        if (this.connection != null) {
            try {
                ManagementView managementView = this.connection.getManagementView();
                managementView.load();
                ManagedComponent serverConfig = (ManagedComponent)managementView.getComponentsForType(new ComponentType("MCBean", "ServerConfig")).iterator().next();
                String reportedServerHomeDirPath = (String)((Object)((SimpleValue)serverConfig.getProperty("serverHomeDir").getValue()).getValue());
                String configuredServerHomeDirPath = this.resourceContext.getPluginConfiguration().getSimpleValue("serverHomeDir", null);
                File reportedServerHomeDir = new File(reportedServerHomeDirPath);
                File configuredServerHomeDir = new File(configuredServerHomeDirPath);
                availability = reportedServerHomeDir.getCanonicalPath().equals(configuredServerHomeDir.getCanonicalPath()) ? AvailabilityType.UP : AvailabilityType.DOWN;
            }
            catch (Exception e) {
                availability = AvailabilityType.DOWN;
            }
        } else {
            availability = AvailabilityType.DOWN;
        }
        return availability;
    }

    public void start(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
        this.connectToProfileService();
        this.initializeEmsConnection();
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.resourceContext);
        this.logFileEventDelegate.startLogFileEventPollers();
        JBPMWorkflowManager workflowManager = this.createJbpmWorkflowManager(resourceContext);
        File configPath = this.getConfigurationPath();
        this.contentFacetDelegate = new ApplicationServerContentFacetDelegate(workflowManager, configPath, resourceContext.getContentContext());
        Configuration pc = resourceContext.getPluginConfiguration();
        String availCheckPeriodProp = pc.getSimpleValue("availabilityCheckPeriod", null);
        if (availCheckPeriodProp != null) {
            try {
                long availCheckMillis = (long)Integer.parseInt(availCheckPeriodProp) * 1000L;
                this.availCollector = resourceContext.createAvailabilityCollectorRunnable(new AvailabilityFacet(){

                    public AvailabilityType getAvailability() {
                        return ApplicationServerComponent.this.getAvailabilityNow();
                    }
                }, availCheckMillis);
                this.availCollector.start();
            }
            catch (NumberFormatException nfe) {
                this.log.error((Object)("avail check period config prop was not a valid number. Cause: " + nfe));
                this.availCollector = null;
            }
        }
    }

    public void stop() {
        if (this.availCollector != null) {
            this.availCollector.stop();
            this.availCollector = null;
        }
        this.logFileEventDelegate.stopLogFileEventPollers();
        this.disconnectFromProfileService();
        this.jmxConnectionHelper.closeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        ManagementView managementView = this.getConnection().getManagementView();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                Matcher matcher = METRIC_NAME_PATTERN.matcher(metricName);
                if (!matcher.matches()) {
                    this.log.error((Object)("Metric name '" + metricName + "' does not match pattern '" + METRIC_NAME_PATTERN + "'."));
                    continue;
                }
                String componentCategory = matcher.group(1);
                String componentSubType = matcher.group(2);
                String componentName = matcher.group(3);
                String propertyName = matcher.group(4);
                ComponentType componentType = new ComponentType(componentCategory, componentSubType);
                ManagedComponent component = componentName.equals("*") ? ManagedComponentUtils.getSingletonManagedComponent(managementView, componentType) : ManagedComponentUtils.getManagedComponent(managementView, componentType, componentName);
                Serializable value = ManagedComponentUtils.getSimplePropertyValue(component, propertyName);
                if (value == null) {
                    this.log.debug((Object)("Null value returned for metric '" + metricName + "'."));
                    continue;
                }
                if (request.getDataType() == DataType.MEASUREMENT) {
                    Number number = (Number)value;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(number.doubleValue())));
                    continue;
                }
                if (request.getDataType() != DataType.TRAIT) continue;
                report.addData(new MeasurementDataTrait(request, value.toString()));
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Failed to obtain metric '" + metricName + "'."), (Throwable)e);
            }
        }
    }

    public Configuration loadResourceConfiguration() {
        return null;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        ResourceType resourceType = createResourceReport.getResourceType();
        if (resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT) {
            this.createContentBasedResource(createResourceReport, resourceType);
        } else {
            this.createConfigurationBasedResource(createResourceReport, resourceType);
        }
        return createResourceReport;
    }

    public void progressEvent(ProgressEvent eventInfo) {
        this.log.debug((Object)eventInfo);
    }

    @Override
    @Nullable
    public ProfileServiceConnection getConnection() {
        this.connectToProfileService();
        return this.connection;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return this.contentFacetDelegate.deployPackages(packages, contentServices);
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return this.contentFacetDelegate.discoverDeployedPackages(type);
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.generateInstallationSteps(packageDetails);
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return this.contentFacetDelegate.removePackages(packages);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.retrievePackageBits(packageDetails);
    }

    private void connectToProfileService() {
        AbstractProfileServiceConnectionProvider connectionProvider;
        if (this.connection != null) {
            return;
        }
        if (this.runningEmbedded()) {
            connectionProvider = new LocalProfileServiceConnectionProvider();
        } else {
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String namingURL = pluginConfig.getSimpleValue("namingURL", null);
            ApplicationServerComponent.validateNamingURL(namingURL);
            String principal = pluginConfig.getSimpleValue("principal", null);
            String credentials = pluginConfig.getSimpleValue("credentials", null);
            connectionProvider = new RemoteProfileServiceConnectionProvider(namingURL, principal, credentials);
        }
        try {
            this.connection = connectionProvider.connect();
        }
        catch (RuntimeException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof SecurityException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Failed to connect to Profile Service.", (Throwable)e);
                } else {
                    this.log.warn((Object)("Failed to connect to Profile Service - cause: " + rootCause));
                }
                throw new InvalidPluginConfigurationException("Values of 'principal' and/or 'credentials' connection properties are invalid.", rootCause);
            }
            this.log.debug((Object)"Failed to connect to Profile Service.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFromProfileService() {
        if (this.connection != null) {
            try {
                this.connection.getConnectionProvider().disconnect();
            }
            catch (RuntimeException e) {
                this.log.debug((Object)"Failed to disconnect from Profile Service.", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void handleMiscManagedProperties(Collection<PropertyDefinition> managedPropertyGroup, Map<String, ManagedProperty> managedProperties, Configuration pluginConfiguration) {
        for (PropertyDefinition propertyDefinition : managedPropertyGroup) {
            String propertyKey = propertyDefinition.getName();
            Property property = pluginConfiguration.get(propertyKey);
            ManagedProperty managedProperty = managedProperties.get(propertyKey);
            if (managedProperty == null || property == null) continue;
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(managedProperty.getMetaType());
            propertyAdapter.populateMetaValueFromProperty(property, managedProperty.getValue(), propertyDefinition);
        }
    }

    private static String getComponentName(Configuration pluginConfig, Configuration resourceConfig) {
        PropertySimple componentNameProp = pluginConfig.getSimple("componentNameProperty");
        if (componentNameProp == null || componentNameProp.getStringValue() == null) {
            throw new IllegalStateException("Property [componentNameProperty] is not defined in the default plugin configuration.");
        }
        String componentNamePropName = componentNameProp.getStringValue();
        PropertySimple propToUseAsComponentName = resourceConfig.getSimple(componentNamePropName);
        if (propToUseAsComponentName == null) {
            throw new IllegalStateException("Property [" + componentNamePropName + "] is not defined in user-specified initial Resource configuration.");
        }
        return propToUseAsComponentName.getStringValue();
    }

    private void createConfigurationBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        Configuration defaultPluginConfig = ApplicationServerComponent.getDefaultPluginConfiguration(resourceType);
        Configuration resourceConfig = createResourceReport.getResourceConfiguration();
        String componentName = ApplicationServerComponent.getComponentName(defaultPluginConfig, resourceConfig);
        ComponentType componentType = ConversionUtils.getComponentType(resourceType);
        ManagementView managementView = this.getConnection().getManagementView();
        if (ManagedComponentUtils.isManagedComponent(managementView, componentName, componentType)) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("A " + resourceType.getName() + " named '" + componentName + "' already exists.");
            return;
        }
        createResourceReport.setResourceName(componentName);
        createResourceReport.setResourceKey(componentName);
        PropertySimple templateNameProperty = defaultPluginConfig.getSimple("templateName");
        String templateName = templateNameProperty.getStringValue();
        try {
            DeploymentTemplateInfo template = managementView.getTemplate(templateName);
            Map managedProperties = template.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(defaultPluginConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("BEFORE CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, resourceType, customProps);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("AFTER CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConfigurationDefinition pluginConfigDef = resourceType.getPluginConfigurationDefinition();
            List managedPropertyGroup = pluginConfigDef.getPropertiesInGroup(MANAGED_PROPERTY_GROUP);
            this.handleMiscManagedProperties(managedPropertyGroup, managedProperties, defaultPluginConfig);
            this.log.debug((Object)("Applying template [" + templateName + "] to create ManagedComponent of type [" + componentType + "]..."));
            try {
                managementView.applyTemplate(componentName, template);
                managementView.process();
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to apply template [" + templateName + "] to create ManagedComponent of type " + componentType + "."), (Throwable)e);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException((Throwable)e);
            }
        }
        catch (NoSuchDeploymentException e) {
            this.log.error((Object)("Unable to find template [" + templateName + "]."), (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to process create request", (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
    }

    private void createContentBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        this.getDeployer().deploy(createResourceReport, resourceType);
    }

    private Deployer getDeployer() {
        ProfileServiceConnection profileServiceConnection = this.getConnection();
        if (this.runningEmbedded()) {
            return new LocalDeployer(profileServiceConnection);
        }
        return new RemoteDeployer(profileServiceConnection, this.resourceContext);
    }

    private static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate pluginConfigDefaultTemplate = resourceType.getPluginConfigurationDefinition().getDefaultTemplate();
        return pluginConfigDefaultTemplate != null ? pluginConfigDefaultTemplate.createConfiguration() : new Configuration();
    }

    @NotNull
    private JBossASPaths getJBossASPaths() {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        String homeDir = pluginConfiguration.getSimpleValue("homeDir", null);
        String serverHomeDir = pluginConfiguration.getSimpleValue("serverHomeDir", null);
        return new JBossASPaths(homeDir, serverHomeDir);
    }

    private boolean runningEmbedded() {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        String namingUrl = pluginConfiguration.getSimpleValue("namingURL", null);
        return namingUrl == null;
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
            String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
            configDir = new File(homeDir, path);
        }
        return configDir;
    }

    private static void validateNamingURL(String namingURL) {
        URI namingURI;
        try {
            namingURI = new URI(namingURL);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not valid: " + e.getLocalizedMessage());
        }
        if (!namingURI.isAbsolute()) {
            throw new RuntimeException("Naming URL '" + namingURL + "' is not absolute.");
        }
        if (!namingURI.getScheme().equals("jnp")) {
            throw new RuntimeException("Naming URL '" + namingURL + "' has an invalid protocol - the only valid protocol is 'jnp'.");
        }
    }

    public EmsConnection getEmsConnection() {
        return this.jmxConnectionHelper.getEmsConnection();
    }

    @NotNull
    private static String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.operationDelegate == null) {
            this.operationDelegate = new ApplicationServerOperationsDelegate(this, this.resourceContext.getSystemInformation());
        }
        ApplicationServerSupportedOperations operation = Enum.valueOf(ApplicationServerSupportedOperations.class, name.toUpperCase());
        return this.operationDelegate.invoke(operation, parameters);
    }

    private void initializeEmsConnection() {
        String connectorDescriptorType;
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        Configuration jmxConfig = new Configuration();
        String jbossHomeDir = pluginConfiguration.getSimpleValue("homeDir", null);
        boolean runningEmbedded = this.runningEmbedded();
        if (runningEmbedded) {
            connectorDescriptorType = InternalVMTypeDescriptor.class.getName();
        } else {
            String connectorAddress = pluginConfiguration.getSimpleValue("namingURL", null);
            String connectorPrincipal = pluginConfiguration.getSimpleValue("principal", null);
            String connectorCredentials = pluginConfiguration.getSimpleValue("credentials", null);
            connectorDescriptorType = JBossAS5ConnectionTypeDescriptor.class.getName();
            jmxConfig.put((Property)new PropertySimple("connectorAddress", (Object)connectorAddress));
            jmxConfig.put((Property)new PropertySimple("connectorCredentials", (Object)connectorCredentials));
            jmxConfig.put((Property)new PropertySimple("connectorPrincipal", (Object)connectorPrincipal));
        }
        jmxConfig.put((Property)new PropertySimple("connectorDescriptorType", (Object)connectorDescriptorType));
        jmxConfig.put((Property)new PropertySimple("jbossHomeDir", (Object)jbossHomeDir));
        this.jmxConnectionHelper = new JmxConnectionHelper(!runningEmbedded, this.resourceContext.getTemporaryDirectory());
        EmsConnection conn = this.jmxConnectionHelper.getEmsConnection(jmxConfig);
        if (conn != null) {
            this.log.info((Object)("Successfully obtained a JMX connection to " + jmxConfig.getSimpleValue("connectorAddress", "-n/a-")));
        }
    }

    private JBPMWorkflowManager createJbpmWorkflowManager(ResourceContext resourceContext) {
        ContentContext contentContext = resourceContext.getContentContext();
        ControlActionFacade controlActionFacade = this.initControlActionFacade();
        JBPMWorkflowManager workflowManager = new JBPMWorkflowManager(contentContext, controlActionFacade, this.getJBossASPaths());
        return workflowManager;
    }

    private ControlActionFacade initControlActionFacade() {
        return new InPluginControlActionFacade(this);
    }

    private File getConfigurationPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String serverHomeDir = ApplicationServerComponent.getRequiredPropertyValue(pluginConfig, "serverHomeDir");
        File configPath = this.resolvePathRelativeToHomeDir(serverHomeDir);
        if (!configPath.isDirectory()) {
            throw new InvalidPluginConfigurationException("Configuration path '" + configPath + "' does not exist.");
        }
        return configPath;
    }
}

