/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.protobuf;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.io.InputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;

@ChannelPipelineCoverage(value="all")
public class ProtobufDecoder
extends OneToOneDecoder {
    private final Message prototype;
    private final ExtensionRegistry extensionRegistry;

    public ProtobufDecoder(Message prototype) {
        this(prototype, null);
    }

    public ProtobufDecoder(Message prototype, ExtensionRegistry extensionRegistry) {
        if (prototype == null) {
            throw new NullPointerException("prototype");
        }
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        if (this.extensionRegistry == null) {
            return this.prototype.newBuilderForType().mergeFrom((InputStream)new ChannelBufferInputStream((ChannelBuffer)msg)).build();
        }
        return this.prototype.newBuilderForType().mergeFrom((InputStream)new ChannelBufferInputStream((ChannelBuffer)msg), this.extensionRegistry).build();
    }
}

