/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.timeout;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.DefaultIdleStateEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

@ChannelPipelineCoverage(value="one")
public class IdleStateHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    final Timer timer;
    final long readerIdleTimeMillis;
    volatile Timeout readerIdleTimeout;
    volatile long lastReadTime;
    final long writerIdleTimeMillis;
    volatile Timeout writerIdleTimeout;
    volatile long lastWriteTime;
    final long allIdleTimeMillis;
    volatile Timeout allIdleTimeout;

    public IdleStateHandler(Timer timer, int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this(timer, readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandler(Timer timer, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.readerIdleTimeMillis = unit.toMillis(readerIdleTime);
        this.writerIdleTimeMillis = unit.toMillis(writerIdleTime);
        this.allIdleTimeMillis = unit.toMillis(allIdleTime);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.initialize(ctx);
        ctx.sendUpstream(e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.destroy();
        ctx.sendUpstream(e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.lastReadTime = System.currentTimeMillis();
        ctx.sendUpstream(e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (e.getWrittenAmount() > 0) {
            this.lastWriteTime = System.currentTimeMillis();
        }
        ctx.sendUpstream(e);
    }

    private void initialize(ChannelHandlerContext ctx) {
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        if (this.readerIdleTimeMillis > 0L) {
            this.readerIdleTimeout = this.timer.newTimeout(new ReaderIdleTimeoutTask(ctx), this.readerIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
        if (this.writerIdleTimeMillis > 0L) {
            this.writerIdleTimeout = this.timer.newTimeout(new WriterIdleTimeoutTask(ctx), this.writerIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
        if (this.allIdleTimeMillis > 0L) {
            this.allIdleTimeout = this.timer.newTimeout(new AllIdleTimeoutTask(ctx), this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void destroy() {
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel();
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel();
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel();
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
        ctx.sendUpstream(new DefaultIdleStateEvent(ctx.getChannel(), state, lastActivityTimeMillis));
    }

    private final class AllIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastIoTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.allIdleTimeMillis - (currentTime - (lastIoTime = Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime)));
            if (nextDelay <= 0L) {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
                try {
                    IdleStateHandler.this.channelIdle(this.ctx, IdleState.ALL_IDLE, lastIoTime);
                }
                catch (Throwable t) {
                    Channels.fireExceptionCaught(this.ctx, t);
                }
            } else {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class WriterIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastWriteTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.writerIdleTimeMillis - (currentTime - (lastWriteTime = IdleStateHandler.this.lastWriteTime));
            if (nextDelay <= 0L) {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.writerIdleTimeMillis, TimeUnit.MILLISECONDS);
                try {
                    IdleStateHandler.this.channelIdle(this.ctx, IdleState.WRITER_IDLE, lastWriteTime);
                }
                catch (Throwable t) {
                    Channels.fireExceptionCaught(this.ctx, t);
                }
            } else {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ReaderIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        ReaderIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastReadTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.readerIdleTimeMillis - (currentTime - (lastReadTime = IdleStateHandler.this.lastReadTime));
            if (nextDelay <= 0L) {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.readerIdleTimeMillis, TimeUnit.MILLISECONDS);
                try {
                    IdleStateHandler.this.channelIdle(this.ctx, IdleState.READER_IDLE, lastReadTime);
                }
                catch (Throwable t) {
                    Channels.fireExceptionCaught(this.ctx, t);
                }
            } else {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

