/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.rmi.ClientMBeanServerConnection;
import org.jboss.mx.remoting.rmi.ClientNotifier;
import org.jboss.mx.remoting.rmi.ConnectionNotifier;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
import org.jboss.util.Base64;

public class RMIConnector
implements JMXConnector,
Serializable {
    private static final long serialVersionUID = 817323035842634473L;
    private JMXServiceURL jmxServiceURL = null;
    private RMIServer rmiServer = null;
    private Map environment = Collections.EMPTY_MAP;
    private transient boolean isConnected = false;
    private transient boolean isClosed = false;
    private transient RMIConnection rmiConnection = null;
    private transient ClassLoader defaultClassLoader = null;
    private transient ConnectionNotifier connectionNotifier = null;
    private transient ClientNotifier clientNotifier = null;
    protected static transient Logger log = Logger.getLogger((String)RMIConnector.class.getName());

    public RMIConnector(JMXServiceURL url, Map environment) {
        if (url == null) {
            throw new IllegalArgumentException("JMXServiceURL can not be null.");
        }
        this.jmxServiceURL = url;
        if (environment != null) {
            this.environment = Collections.unmodifiableMap(environment);
        }
        this.init();
    }

    public RMIConnector(RMIServer rmiServer, Map environment) {
        if (rmiServer == null) {
            throw new IllegalArgumentException("RMIServer can not be null.");
        }
        this.rmiServer = rmiServer;
        if (environment != null) {
            this.environment = Collections.unmodifiableMap(environment);
        }
        this.init();
    }

    private void init() {
        if (this.connectionNotifier == null) {
            this.connectionNotifier = new ConnectionNotifier(this);
        }
    }

    public void connect() throws IOException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        RMIConnector rMIConnector = this;
        synchronized (rMIConnector) {
            if (this.isClosed) {
                throw new IOException("Can not connect RMIConnector because has already been closed.");
            }
            if (this.isConnected) {
                return;
            }
            HashMap connectEnv = new HashMap(this.environment);
            if (env != null) {
                connectEnv.putAll(env);
            }
            this.setDefaultClassLoader(connectEnv);
            if (this.rmiServer == null) {
                Hashtable lookupEnv = new Hashtable(connectEnv);
                String path = this.jmxServiceURL.getURLPath();
                if (path.startsWith("/jndi/") || path.startsWith(";jndi/")) {
                    String lookupPath = path.substring("/jndi/".length());
                    Object stub = null;
                    InitialContext ctx = null;
                    try {
                        ctx = new InitialContext(lookupEnv);
                        stub = ctx.lookup(lookupPath);
                    }
                    catch (NamingException e) {
                        log.error((Object)("Error looking up rmi server from jndi with url path of " + path), (Throwable)e);
                        throw new IOException("Error looking up rmi server stub within jndi.  " + e.getMessage());
                    }
                    finally {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException e) {
                                log.warn((Object)("Error closing jndi context.  " + e.getMessage()));
                            }
                        }
                    }
                    this.rmiServer = (RMIServer)stub;
                } else if (path.startsWith("/stub/") || path.startsWith(";stub/")) {
                    String encodedPath = path.substring("/stub/".length());
                    byte[] decodedPath = Base64.decode((String)encodedPath);
                    ByteArrayInputStream bin = new ByteArrayInputStream(decodedPath);
                    ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bin, this.defaultClassLoader);
                    try {
                        Object obj = ois.readObject();
                        this.rmiServer = (RMIServer)PortableRemoteObject.narrow((Object)obj, RMIServer.class);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Could not find class " + e.getMessage() + " when loading stub."), (Throwable)e);
                        throw new MalformedURLException("Could not find class " + e.getMessage() + " when loading stub.");
                    }
                    catch (ClassCastException cce) {
                        log.error((Object)"Could not convert stub to RMIServer type.", (Throwable)cce);
                        throw new MalformedURLException("Could not convert stub to RMIServer type.");
                    }
                    finally {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                } else {
                    throw new MalformedURLException("JMXServiceURL does not contain recognizable lookup path.");
                }
            }
            Object credentials = connectEnv.get("jmx.remote.credentials");
            this.rmiConnection = this.rmiServer.newClient(credentials);
            this.isConnected = true;
            this.clientNotifier = new ClientNotifier(this.rmiConnection);
            this.connectionNotifier.fireConnectedNotification();
        }
    }

    private void setDefaultClassLoader(Map lookupEnv) {
        this.defaultClassLoader = Thread.currentThread().getContextClassLoader();
        Object loaderInstance = lookupEnv.get("jmx.remote.default.class.loader");
        if (loaderInstance != null && loaderInstance instanceof ClassLoader) {
            this.defaultClassLoader = (ClassLoader)loaderInstance;
        }
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        if (!this.isConnected || this.isClosed) {
            throw new IOException("Connector is not connected.");
        }
        ClientMBeanServerConnection clientConnection = new ClientMBeanServerConnection(this.rmiConnection, this.clientNotifier, this.defaultClassLoader, delegationSubject);
        return clientConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RMIConnector rMIConnector = this;
        synchronized (rMIConnector) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.isConnected = false;
            this.clientNotifier.close();
            if (this.rmiConnection != null) {
                this.rmiConnection.close();
            }
            this.rmiConnection = null;
            this.rmiServer = null;
            this.connectionNotifier.fireClosedNotification();
        }
    }

    public String getConnectionId() throws IOException {
        if (this.rmiConnection != null) {
            return this.rmiConnection.getConnectionId();
        }
        return null;
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.connectionNotifier.addNotificationListener(listener, filter, handback);
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.connectionNotifier.removeNotificationListener(listener);
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.connectionNotifier.removeNotificationListener(listener, filter, handback);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName() + " for ");
        buffer.append("JMXServiceURL: " + this.jmxServiceURL.toString());
        return buffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

