/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.ClientListener;
import org.jboss.mx.remoting.MBeanServerRegistry;
import org.jboss.mx.remoting.NotificationEntry;
import org.jboss.mx.remoting.NotificationQueue;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.NameBasedInvocation;

public class MBeanServerClientInvokerProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger((String)MBeanServerClientInvokerProxy.class.getName());
    private final String serverId;
    private final String localJmxId;
    private final transient InvokerLocator locator;
    private final transient Client client;
    private final transient Map paramMap = new HashMap();
    private NotificationPoller poller = new NotificationPoller();
    private Timer pollTimer = new Timer(true);
    private static transient Map proxies = new HashMap();
    private transient Set listeners = new HashSet();

    private MBeanServerClientInvokerProxy(ClassLoader cl, InvokerLocator invoker, String localJmxId, String id) throws Exception {
        this.localJmxId = localJmxId;
        this.serverId = id;
        if (this.serverId == null) {
            throw new IllegalArgumentException("MBeanServer ID not found - make sure the NetworkRegistry MBean is running");
        }
        this.client = new Client(cl, invoker, "jmx", null);
        this.locator = new InvokerLocator(invoker.getLocatorURI());
        proxies.put(id, this);
        this.setupPollingTimer();
    }

    public static synchronized MBeanServerClientInvokerProxy remove(String id) {
        return (MBeanServerClientInvokerProxy)proxies.remove(id);
    }

    public static synchronized MBeanServerClientInvokerProxy get(String id) {
        return (MBeanServerClientInvokerProxy)proxies.get(id);
    }

    protected void setupPollingTimer() {
        String ds;
        Map map = this.locator.getParameters();
        long delay = 1000L;
        if (map != null && (ds = (String)map.get("pollinterval")) != null) {
            delay = Integer.parseInt(ds);
        }
        if (delay > 0L) {
            this.pollTimer.scheduleAtFixedRate((TimerTask)this.poller, 2000L, delay);
        }
    }

    public synchronized String getServerId() {
        return this.serverId;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public static synchronized MBeanServer create(InvokerLocator locator, String localJmxId, String jmxId) throws Exception {
        MBeanServer mbeanserver = MBeanServerRegistry.getMBeanServerFor(locator);
        if (mbeanserver != null) {
            return mbeanserver;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = MBeanServerClientInvokerProxy.class.getClassLoader();
        }
        MBeanServerClientInvokerProxy handler = new MBeanServerClientInvokerProxy(cl, locator, localJmxId, jmxId);
        mbeanserver = (MBeanServer)Proxy.newProxyInstance(MBeanServerClientInvokerProxy.class.getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
        MBeanServerRegistry.register(mbeanserver, handler);
        log.debug((Object)("created MBeanServer proxy to remote mbeanserver at: " + locator + " for JMX Id: " + jmxId + " from our JMX id: " + localJmxId));
        return mbeanserver;
    }

    public synchronized void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("destroy called on: " + this + " for locator: " + this.locator + ", and serverid: " + this.serverId));
        }
        this.client.disconnect();
        MBeanServerRegistry.unregister(this);
        this.cancelPoller();
        this.removeListeners();
        this.paramMap.clear();
        proxies.remove(this.serverId);
    }

    private synchronized void cancelPoller() {
        if (this.poller != null) {
            this.poller.cancel();
            this.poller = null;
        }
        if (this.pollTimer != null) {
            this.pollTimer.cancel();
            this.pollTimer = null;
        }
    }

    private synchronized void removeListeners() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            ClientListener.remove(key);
            iter.remove();
        }
    }

    private void addNotificationListener(Method m, Object[] args, String[] sig, Map payload) throws Throwable {
        String methodName = m.getName();
        Object key = ClientListener.register(this.serverId, (ObjectName)args[0], args[1], (NotificationFilter)args[2], args[3]);
        this.listeners.add(key);
        Object[] a = new Object[]{args[0], null, args[2], key};
        this.client.setSessionId(this.serverId);
        this.client.invoke((Object)new NameBasedInvocation(methodName, a, sig), payload);
    }

    private void removeNotificationListener(Method m, Object[] args, String[] sig, Map payload) throws Throwable {
        String methodName = m.getName();
        Object id = ClientListener.makeId(this.serverId, (ObjectName)args[0], args[1]);
        this.listeners.remove(id);
        ClientListener cl = ClientListener.remove(id);
        Object[] a = new Object[]{args[0], null, id};
        if (cl != null) {
            this.client.setSessionId(this.serverId);
            this.client.invoke((Object)new NameBasedInvocation(methodName, a, new String[]{ObjectName.class.getName(), sig[1], Integer.class.getName()}), payload);
        }
    }

    private boolean proxyEquals(Object proxy) {
        return proxy.getClass() == this.getClass() && ((MBeanServerClientInvokerProxy)proxy).serverId.equals(this.serverId);
    }

    private Integer proxyHashcode() {
        return new Integer(this.client.hashCode() + this.serverId.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (methodName.equals("equals")) {
                return new Boolean(this.proxyEquals(args[0]));
            }
            if (methodName.equals("hashCode")) {
                return this.proxyHashcode();
            }
            if (methodName.equals("toString")) {
                return "MBeanServerClientInvokerProxy [serverid:" + this.serverId + ",locator:" + this.client.getInvoker().getLocator() + "]";
            }
        }
        String[] sig = this.getMethodSignature(method);
        HashMap payload = new HashMap(1);
        if (methodName.equals("addNotificationListener")) {
            this.addNotificationListener(method, args, sig, payload);
            return null;
        }
        if (methodName.equals("removeNotificationListener")) {
            this.removeNotificationListener(method, args, sig, payload);
            return null;
        }
        Object value = null;
        try {
            this.client.setSessionId(this.serverId);
            value = this.client.invoke((Object)new NameBasedInvocation(methodName, args, sig), payload);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("remote invocation failed for method: " + methodName + " to: " + this.serverId), throwable);
            }
            if (throwable instanceof ConnectionFailedException) {
                this.destroy();
            }
            this.rethrowMBeanException(throwable);
        }
        finally {
            NotificationQueue queue;
            if (payload != null && (queue = (NotificationQueue)payload.get("notifications")) != null && !queue.isEmpty()) {
                this.deliverNotifications(queue, false);
            }
        }
        return value;
    }

    private void rethrowMBeanException(Throwable throwable) throws MBeanException, ReflectionException {
        if (throwable instanceof MBeanException) {
            throw (MBeanException)throwable;
        }
        if (throwable instanceof ReflectionException) {
            throw (ReflectionException)throwable;
        }
        if (throwable instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException ut = (UndeclaredThrowableException)throwable;
            if (ut instanceof Exception) {
                throw new MBeanException((Exception)ut.getUndeclaredThrowable(), ut.getMessage());
            }
            throw new MBeanException(new Exception(ut.getUndeclaredThrowable().getMessage()));
        }
        if (throwable instanceof Exception) {
            throw new MBeanException((Exception)throwable, throwable.getMessage());
        }
        throw new MBeanException(new Exception(throwable.getMessage()));
    }

    public void deliverNotifications(NotificationQueue queue, boolean async) throws InterruptedException {
        if (async && this.poller != null) {
            this.cancelPoller();
        }
        if (queue == null) {
            return;
        }
        Iterator iter = queue.iterator();
        while (iter.hasNext()) {
            NotificationEntry entry = (NotificationEntry)iter.next();
            ClientListener listener = ClientListener.get(entry.getHandBack());
            if (listener != null) {
                if (listener.listener instanceof NotificationListener) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("sending notification for entry: " + entry + " to: " + listener.listener));
                    }
                    try {
                        ((NotificationListener)listener.listener).handleNotification(entry.getNotification(), listener.handback);
                    }
                    catch (Throwable ex) {
                        log.error((Object)("Error sending notification: " + entry.getNotification() + " to listener: " + listener));
                    }
                    continue;
                }
                log.error((Object)"called unimplemented addListener method", (Throwable)new Exception());
                continue;
            }
            log.warn((Object)("couldn't find client listener for handback: " + entry.getHandBack() + "\nentry:" + entry + "\nqueue: " + queue + "\ndump: " + ClientListener.dump()));
        }
    }

    public String[] getMethodSignature(Method method) {
        String[] sig;
        if (this.paramMap.containsKey(method)) {
            return (String[])this.paramMap.get(method);
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] stringArray = sig = paramTypes == null ? null : new String[paramTypes.length];
        if (paramTypes != null) {
            for (int c = 0; c < sig.length; ++c) {
                sig[c] = paramTypes[c].getName();
            }
        }
        this.paramMap.put(method, sig);
        return sig;
    }

    private final class NotificationPoller
    extends TimerTask {
        private NotificationPoller() {
        }

        public void run() {
            try {
                if (MBeanServerClientInvokerProxy.this.client.isConnected() && ClientListener.hasListeners()) {
                    HashMap payload = new HashMap(1);
                    MBeanServerClientInvokerProxy.this.client.setSessionId(MBeanServerClientInvokerProxy.this.serverId);
                    Boolean continuePolling = (Boolean)MBeanServerClientInvokerProxy.this.client.invoke((Object)new NameBasedInvocation("$GetNotifications$", new Object[0], new String[0]), payload);
                    NotificationQueue queue = (NotificationQueue)payload.get("notifications");
                    if (queue != null && !queue.isEmpty()) {
                        MBeanServerClientInvokerProxy.this.deliverNotifications(queue, false);
                    }
                    if (!continuePolling.booleanValue()) {
                        MBeanServerClientInvokerProxy.this.cancelPoller();
                    }
                }
            }
            catch (ConnectionFailedException cnf) {
                MBeanServerClientInvokerProxy.this.destroy();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

