/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.rmi;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.rmi.ClientListenerHolder;

public class ClientNotificationProxy
implements NotificationListener {
    private SynchronizedInt idCounter = new SynchronizedInt(0);
    private Map listenerHolders = new HashMap();
    private List clientListenerNotifications = new ArrayList();
    private long startSequence = 0L;
    private long currentSequence = 0L;
    public static final int DEFAULT_MAX_NOTIFICATION_BUFFER_SIZE = 1024;
    public static final String MAX_NOTIFICATION_BUFFER_SIZE_KEY = "jmx.remote.notification.buffer.size";
    private int maxNumberOfNotifications = 1024;
    private static final Logger log = Logger.getLogger(ClientNotificationProxy.class);

    public ClientNotificationProxy() {
        String maxVal = System.getProperty(MAX_NOTIFICATION_BUFFER_SIZE_KEY);
        if (maxVal != null && maxVal.length() > 0) {
            try {
                this.maxNumberOfNotifications = Integer.parseInt(maxVal);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Could not convert max notification buffer size property value " + maxVal + " to a number.  " + "Will use default value of " + 1024));
            }
        }
    }

    public Integer createListenerId(ObjectName name, NotificationFilter filter) {
        Integer id = new Integer(this.idCounter.increment());
        this.listenerHolders.put(id, new ClientListenerHolder(name, null, filter, id));
        return id;
    }

    public void handleNotification(Notification notification, Object o) {
        Integer id = (Integer)o;
        this.addClientNotification(id, notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientNotification(Integer id, Notification notification) {
        List list = this.clientListenerNotifications;
        synchronized (list) {
            if (this.clientListenerNotifications.size() == this.maxNumberOfNotifications) {
                this.clientListenerNotifications.remove(0);
                ++this.startSequence;
            }
            TargetedNotification targetedNotification = new TargetedNotification(notification, id);
            this.clientListenerNotifications.add(targetedNotification);
            ++this.currentSequence;
        }
    }

    public NotificationFilter removeListener(Integer id) {
        ClientListenerHolder holder = (ClientListenerHolder)this.listenerHolders.remove(id);
        return holder.getFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) {
        if (clientSequenceNumber < 0L) {
            // empty if block
        }
        Object result = null;
        boolean waitForTimeout = true;
        boolean timeoutReached = false;
        int startIndex = 0;
        boolean intr = false;
        try {
            List list;
            while (waitForTimeout) {
                list = this.clientListenerNotifications;
                synchronized (list) {
                    int endIndex;
                    waitForTimeout = false;
                    if (clientSequenceNumber > this.startSequence && (startIndex = (int)(clientSequenceNumber - this.startSequence)) > this.clientListenerNotifications.size()) {
                        if (timeout > 0L && !timeoutReached) {
                            try {
                                this.clientListenerNotifications.wait(timeout);
                                waitForTimeout = true;
                                timeoutReached = true;
                            }
                            catch (InterruptedException e) {
                                intr = true;
                                log.trace((Object)"Caught InterruptedException waiting for clientListenerNotifications.");
                            }
                        } else {
                            startIndex = this.clientListenerNotifications.size();
                        }
                    }
                    int n = endIndex = maxNotifications > this.clientListenerNotifications.size() - startIndex ? this.clientListenerNotifications.size() : maxNotifications;
                    if (endIndex == startIndex && timeout > 0L && !timeoutReached) {
                        try {
                            this.clientListenerNotifications.wait(timeout);
                            waitForTimeout = true;
                            timeoutReached = true;
                        }
                        catch (InterruptedException e) {
                            intr = true;
                            log.debug((Object)"Caught InterruptedException waiting for clientListenerNotifications.");
                        }
                    }
                    List fetchedNotifications = this.clientListenerNotifications.subList(startIndex, endIndex);
                    TargetedNotification[] targetedNotifications = fetchedNotifications.toArray(new TargetedNotification[fetchedNotifications.size()]);
                    result = new NotificationResult(clientSequenceNumber, this.currentSequence, targetedNotifications);
                }
            }
            list = result;
            return list;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ClientListenerHolder[] getListeners() {
        Collection holders = this.listenerHolders.values();
        ClientListenerHolder[] holderArray = holders.toArray(new ClientListenerHolder[holders.size()]);
        return holderArray;
    }
}

