/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.rmi;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReaderPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.management.remote.rmi.RMIConnection;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.rmi.ClientListenerHolder;

public class ClientNotifier
extends TimerTask {
    private Map clientListeners = null;
    private Timer fetchTimer = null;
    private RMIConnection connection = null;
    private long fetchTimeout = 1000L;
    private long clientSequenceNumber = -1L;
    private int maxNotifications = 10;
    private Executor notifierPool = null;
    private static final Logger log = Logger.getLogger(ClientNotifier.class);

    public ClientNotifier(RMIConnection rmiConnection) {
        this.connection = rmiConnection;
        this.clientListeners = new SyncMap(new HashMap(), (ReadWriteLock)new ReaderPreferenceReadWriteLock());
        this.fetchTimer = new Timer(true);
        this.fetchTimer.schedule((TimerTask)this, 1000L, 1000L);
    }

    public Executor getNotifierPool() {
        return this.notifierPool;
    }

    public void setNotifierPool(Executor notifierPool) {
        this.notifierPool = notifierPool;
    }

    public void run() {
        try {
            NotificationResult result = this.connection.fetchNotifications(this.clientSequenceNumber, this.maxNotifications, this.fetchTimeout);
            if (result != null) {
                this.clientSequenceNumber = result.getNextSequenceNumber();
                TargetedNotification[] targetedNotifications = result.getTargetedNotifications();
                if (targetedNotifications != null) {
                    this.deliverNotifications(targetedNotifications);
                }
            } else {
                log.error((Object)"Fetched notifications and result was null.");
            }
        }
        catch (IOException e) {
            log.error((Object)("Error fetching notifications for sequence number " + this.clientSequenceNumber), (Throwable)e);
        }
    }

    private void deliverNotifications(TargetedNotification[] targetedNotifications) {
        for (int x = 0; x < targetedNotifications.length; ++x) {
            NotificationFilter filter;
            TargetedNotification targetedNotification = targetedNotifications[x];
            Integer id = targetedNotification.getListenerID();
            ClientListenerHolder holder = (ClientListenerHolder)this.clientListeners.get(id);
            if (holder == null) continue;
            final Notification notification = targetedNotification.getNotification();
            boolean deliverNotification = true;
            if (holder.getFilterOnClient() && !(filter = holder.getFilter()).isNotificationEnabled(notification)) {
                deliverNotification = false;
            }
            if (!deliverNotification) continue;
            final NotificationListener listener = holder.getListener();
            final Object handback = holder.getHandback();
            Runnable notifyRun = new Runnable(){

                public void run() {
                    try {
                        listener.handleNotification(notification, handback);
                    }
                    catch (Throwable e) {
                        log.error((Object)("Error delivering notification to listener: " + listener), e);
                    }
                }
            };
            this.notifierPool.execute(notifyRun);
        }
    }

    public boolean exists(ClientListenerHolder holder) {
        return this.clientListeners.containsValue(holder);
    }

    public void addNotificationListener(Integer listenerID, ClientListenerHolder holder) {
        this.clientListeners.put(listenerID, holder);
    }

    public Integer[] getListeners(ObjectName name, NotificationListener listener) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        Set keys = this.clientListeners.keySet();
        for (Integer id : keys) {
            ClientListenerHolder holder = (ClientListenerHolder)this.clientListeners.get(id);
            if (!holder.getObjectName().equals(name) || !holder.getListener().equals(listener)) continue;
            idList.add(id);
        }
        Integer[] ids = new Integer[idList.size()];
        ids = idList.toArray(ids);
        return ids;
    }

    public void removeListeners(Integer[] ids) {
        for (int x = 0; x < ids.length; ++x) {
            this.clientListeners.remove(ids[x]);
        }
    }

    public Integer getListener(ClientListenerHolder clientListenerHolder) {
        for (Map.Entry value : this.clientListeners.entrySet()) {
            if (!value.getValue().equals(clientListenerHolder)) continue;
            return (Integer)value.getKey();
        }
        return null;
    }

    public void close() {
        this.fetchTimer.cancel();
    }
}

