/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.SecurityDecoder;
import org.jboss.ws.extensions.security.SecurityEncoder;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityAPI;
import org.jboss.ws.extensions.security.WsuIdTarget;
import org.jboss.ws.extensions.security.exception.InvalidSecurityHeaderException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.nonce.DefaultNonceFactory;
import org.jboss.ws.extensions.security.nonce.NonceFactory;
import org.jboss.ws.extensions.security.operation.AuthorizeOperation;
import org.jboss.ws.extensions.security.operation.EncodingOperation;
import org.jboss.ws.extensions.security.operation.EncryptionOperation;
import org.jboss.ws.extensions.security.operation.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.jboss.ws.extensions.security.operation.RequireSignatureOperation;
import org.jboss.ws.extensions.security.operation.RequireTimestampOperation;
import org.jboss.ws.extensions.security.operation.SendUsernameOperation;
import org.jboss.ws.extensions.security.operation.SignatureOperation;
import org.jboss.ws.extensions.security.operation.TimestampOperation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.wsse.Authenticate;
import org.jboss.ws.metadata.wsse.Authorize;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.Username;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecurityDispatcher
implements WSSecurityAPI {
    private static Logger log = Logger.getLogger(WSSecurityDispatcher.class);

    @Override
    public void decodeMessage(WSSecurityConfiguration configuration, SOAPMessage message, Config operationConfig) throws SOAPException {
        Element secHeaderElement;
        Config config = this.getActualConfig(configuration, operationConfig);
        SOAPHeader soapHeader = message.getSOAPHeader();
        QName secQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        Element element = secHeaderElement = soapHeader != null ? Util.findElement((Element)soapHeader, secQName) : null;
        if (secHeaderElement == null) {
            if (message.getSOAPBody().getFault() != null) {
                return;
            }
            if (this.hasRequirements(config)) {
                throw this.convertToFault(new InvalidSecurityHeaderException("This service requires <wsse:Security>, which is missing."));
            }
        }
        try {
            if (secHeaderElement != null) {
                this.decodeHeader(configuration, config, message, secHeaderElement);
            }
            this.authorize(config);
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling inbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw this.convertToFault(e);
        }
    }

    private void decodeHeader(WSSecurityConfiguration configuration, Config config, SOAPMessage message, Element secHeaderElement) throws WSSecurityException {
        SecurityStore securityStore = new SecurityStore(configuration.getKeyStoreURL(), configuration.getKeyStoreType(), configuration.getKeyStorePassword(), configuration.getKeyPasswords(), configuration.getTrustStoreURL(), configuration.getTrustStoreType(), configuration.getTrustStorePassword());
        NonceFactory factory = Util.loadFactory(NonceFactory.class, configuration.getNonceFactory(), DefaultNonceFactory.class);
        Authenticate authenticate = null;
        if (config != null) {
            authenticate = config.getAuthenticate();
        }
        SecurityDecoder decoder = new SecurityDecoder(securityStore, factory, configuration.getTimestampVerification(), authenticate);
        decoder.decode((Document)message.getSOAPPart(), secHeaderElement);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Decoded Message:\n" + DOMWriter.printNode((Node)message.getSOAPPart(), (boolean)true)));
        }
        List<RequireOperation> operations = this.buildRequireOperations(config);
        decoder.verify(operations);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Verification is successful");
        }
        decoder.complete();
    }

    private void authorize(Config config) throws WSSecurityException {
        Authorize authorize;
        if (config != null && (authorize = config.getAuthorize()) != null) {
            AuthorizeOperation authorizeOp = new AuthorizeOperation(authorize);
            authorizeOp.process();
        }
    }

    @Override
    public void encodeMessage(WSSecurityConfiguration configuration, SOAPMessage message, Config operationConfig, String user, String password) throws SOAPException {
        Encrypt encrypt;
        Sign sign;
        Username username;
        Config config = this.getActualConfig(configuration, operationConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WS-Security config: " + config));
        }
        if (config == null) {
            return;
        }
        ArrayList<EncodingOperation> operations = new ArrayList<EncodingOperation>();
        Timestamp timestamp = config.getTimestamp();
        if (timestamp != null) {
            operations.add(new TimestampOperation(timestamp.getTtl()));
        }
        if ((username = config.getUsername()) != null && user != null && password != null) {
            NonceFactory factory = Util.loadFactory(NonceFactory.class, configuration.getNonceFactory(), DefaultNonceFactory.class);
            operations.add(new SendUsernameOperation(user, password, username.isDigestPassword(), username.isUseNonce(), username.isUseCreated(), factory.getGenerator()));
        }
        if ((sign = config.getSign()) != null) {
            List<Target> targets = this.convertTargets(sign.getTargets());
            if (sign.isIncludeTimestamp()) {
                if (timestamp == null) {
                    operations.add(new TimestampOperation(null));
                }
                if (targets != null && targets.size() > 0) {
                    targets.add(new WsuIdTarget("timestamp"));
                }
            }
            operations.add(new SignatureOperation(targets, sign.getAlias(), sign.getTokenRefType()));
        }
        if ((encrypt = config.getEncrypt()) != null) {
            List<Target> targets = this.convertTargets(encrypt.getTargets());
            operations.add(new EncryptionOperation(targets, encrypt.getAlias(), encrypt.getAlgorithm(), encrypt.getWrap(), encrypt.getTokenRefType()));
        }
        if (operations.size() == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoding Message:\n" + DOMWriter.printNode((Node)message.getSOAPPart(), (boolean)true)));
        }
        try {
            SecurityStore securityStore = new SecurityStore(configuration.getKeyStoreURL(), configuration.getKeyStoreType(), configuration.getKeyStorePassword(), configuration.getKeyPasswords(), configuration.getTrustStoreURL(), configuration.getTrustStoreType(), configuration.getTrustStorePassword());
            SecurityEncoder encoder = new SecurityEncoder(operations, securityStore);
            encoder.encode((Document)message.getSOAPPart());
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling outbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw this.convertToFault(e);
        }
    }

    @Override
    public void cleanup() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
        securityAdaptor.setPrincipal(null);
        securityAdaptor.setCredential(null);
    }

    private List<Target> convertTargets(List<org.jboss.ws.metadata.wsse.Target> targets) {
        if (targets == null) {
            return null;
        }
        ArrayList<Target> newList = new ArrayList<Target>(targets.size());
        for (org.jboss.ws.metadata.wsse.Target target : targets) {
            if ("qname".equals(target.getType())) {
                QNameTarget qnameTarget = new QNameTarget(QName.valueOf(target.getValue()), target.isContentOnly());
                newList.add(qnameTarget);
                continue;
            }
            if (!"wsuid".equals(target.getType())) continue;
            newList.add(new WsuIdTarget(target.getValue()));
        }
        return newList;
    }

    private CommonSOAPFaultException convertToFault(WSSecurityException e) {
        return new CommonSOAPFaultException(e.getFaultCode(), e.getFaultString());
    }

    private List<RequireOperation> buildRequireOperations(Config operationConfig) {
        RequireEncryption requireEncryption;
        RequireSignature requireSignature;
        if (operationConfig == null) {
            return null;
        }
        Requires requires = operationConfig.getRequires();
        if (requires == null) {
            return null;
        }
        ArrayList<RequireOperation> operations = new ArrayList<RequireOperation>();
        RequireTimestamp requireTimestamp = requires.getRequireTimestamp();
        if (requireTimestamp != null) {
            operations.add(new RequireTimestampOperation(requireTimestamp.getMaxAge()));
        }
        if ((requireSignature = requires.getRequireSignature()) != null) {
            List<Target> targets = this.convertTargets(requireSignature.getTargets());
            operations.add(new RequireSignatureOperation(targets));
        }
        if ((requireEncryption = requires.getRequireEncryption()) != null) {
            List<Target> targets = this.convertTargets(requireEncryption.getTargets());
            operations.add(new RequireEncryptionOperation(targets));
        }
        return operations;
    }

    private Config getActualConfig(WSSecurityConfiguration configuration, Config operationConfig) {
        CommonMessageContext ctx;
        if (operationConfig == null && (ctx = MessageContextAssociation.peekMessageContext()) != null) {
            EndpointMetaData epMetaData = ctx.getEndpointMetaData();
            QName port = epMetaData.getPortName();
            OperationMetaData opMetaData = ctx.getOperationMetaData();
            if (opMetaData == null) {
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                try {
                    opMetaData = soapMessage.getOperationMetaData(epMetaData);
                }
                catch (SOAPException e) {
                    throw new WebServiceException("Error while looking for the operation meta data: " + (Object)((Object)e));
                }
            }
            if (opMetaData != null) {
                operationConfig = this.selectOperationConfig(configuration, port, opMetaData.getQName());
            }
        }
        return operationConfig != null ? operationConfig : configuration.getDefaultConfig();
    }

    private Config selectOperationConfig(WSSecurityConfiguration configuration, QName portName, QName opName) {
        Port port = configuration.getPorts().get(portName != null ? portName.getLocalPart() : null);
        if (port == null) {
            return configuration.getDefaultConfig();
        }
        Operation operation = port.getOperations().get(opName != null ? opName.toString() : null);
        if (operation == null) {
            Config portConfig = port.getDefaultConfig();
            return portConfig == null ? configuration.getDefaultConfig() : portConfig;
        }
        return operation.getConfig();
    }

    private boolean hasRequirements(Config config) {
        return config != null && config.getRequires() != null;
    }
}

