/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.util.HashMap;
import java.util.Map;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.UnMarshaller;

public final class RMMetadata {
    private Map<String, Map<String, Object>> contexts = new HashMap<String, Map<String, Object>>();

    public RMMetadata(String targetAddress, Marshaller marshaller, UnMarshaller unmarshaller, Map<String, Object> invocationContext, Map<String, Object> remotingInvocationContext) {
        if (targetAddress == null) {
            throw new IllegalArgumentException("Target address cannot be null");
        }
        invocationContext.put("targetAddress", targetAddress);
        this.setContext("invocationContext", invocationContext);
        if (marshaller == null || unmarshaller == null) {
            throw new IllegalArgumentException("Unable to create de/serialization context");
        }
        HashMap<String, Object> serializationContext = new HashMap<String, Object>();
        serializationContext.put("marshaller", marshaller);
        serializationContext.put("unmarshaller", unmarshaller);
        this.setContext("serializationContext", serializationContext);
        if (remotingInvocationContext == null) {
            throw new IllegalArgumentException("Remoting invocation context cannot be null");
        }
        this.setContext("remotingInvocationContext", remotingInvocationContext);
    }

    public RMMetadata(Map<String, Object> invocationContext, Map<String, Object> remotingInvocationContext) {
        if (remotingInvocationContext == null) {
            throw new IllegalArgumentException("Remoting invocation context cannot be null");
        }
        this.setContext("remotingInvocationContext", remotingInvocationContext);
        this.setContext("invocationContext", invocationContext);
    }

    void setContext(String key, Map<String, Object> ctx) {
        this.contexts.put(key, ctx);
    }

    Map<String, Object> getContext(String key) {
        return this.contexts.get(key);
    }
}

