/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.EndpointConfig;
import org.jboss.ws.core.jaxws.client.ServiceObjectFactoryJAXWS;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class JAXWSClientMetaDataBuilder
extends JAXWSMetaDataBuilder {
    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL, UnifiedVirtualFile vfsRoot) {
        return this.buildMetaData(serviceName, wsdlURL, vfsRoot, null);
    }

    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL, UnifiedVirtualFile vfsRoot, ClassLoader classLoader) {
        if (wsdlURL == null) {
            throw new IllegalArgumentException("Invalid wsdlURL: " + wsdlURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("START buildMetaData: [service=" + serviceName + "]"));
        }
        try {
            UnifiedMetaData wsMetaData = classLoader != null ? new UnifiedMetaData(vfsRoot, classLoader) : new UnifiedMetaData(vfsRoot);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlLocation(wsdlURL);
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions);
            for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getClientSidePolicyMetaDataBuilder();
                policyBuilder.processPolicyExtensions(epMetaData, wsdlDefinitions);
            }
            JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
            serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL) {
        return this.buildMetaData(serviceName, wsdlURL, (UnifiedVirtualFile)new ResourceLoaderAdapter());
    }

    private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions) throws IOException {
        QName serviceName = serviceMetaData.getServiceName();
        WSDLService wsdlService = null;
        if (serviceName == null) {
            if (wsdlDefinitions.getServices().length != 1) {
                throw new IllegalArgumentException("Expected a single service element");
            }
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setServiceName(wsdlService.getName());
        } else {
            wsdlService = wsdlDefinitions.getService(serviceName);
        }
        if (wsdlService == null) {
            ArrayList<QName> serviceNames = new ArrayList<QName>();
            for (WSDLService wsdls : wsdlDefinitions.getServices()) {
                serviceNames.add(wsdls.getName());
            }
            throw new IllegalArgumentException("Cannot obtain wsdl service: " + serviceName + " we have " + serviceNames);
        }
        for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
            QName bindingName = wsdlEndpoint.getBinding();
            WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
            String bindingType = wsdlBinding.getType();
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) continue;
            QName portName = wsdlEndpoint.getName();
            QName interfaceQName = wsdlEndpoint.getInterface().getName();
            ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXWS);
            epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
            serviceMetaData.addEndpoint(epMetaData);
            this.initEndpointBinding(wsdlBinding, (EndpointMetaData)epMetaData);
            this.initEndpointEncodingStyle(epMetaData);
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint);
            this.bufferServiceRefContributions(epMetaData);
        }
    }

    private void bufferServiceRefContributions(EndpointMetaData epMetaData) {
        UnifiedServiceRefMetaData serviceRefMetaData = ServiceObjectFactoryJAXWS.getServiceRefAssociation();
        if (serviceRefMetaData != null) {
            for (UnifiedPortComponentRefMetaData portComp : serviceRefMetaData.getPortComponentRefs()) {
                epMetaData.getServiceRefContrib().add(portComp);
            }
        }
    }

    private void processServiceRefContributions(EndpointMetaData epMetaData) {
        for (UnifiedPortComponentRefMetaData portComp : epMetaData.getServiceRefContrib()) {
            if (!epMetaData.matches(portComp)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing service-ref contribution on portType: " + epMetaData.getPortTypeName()));
            }
            if (portComp.getEnableMTOM().booleanValue()) {
                String bindingId = epMetaData.getBindingId();
                if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                } else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                }
            }
            for (UnifiedStubPropertyMetaData stubProp : portComp.getStubProperties()) {
                epMetaData.getProperties().put(stubProp.getPropName(), stubProp.getPropValue());
            }
            for (UnifiedCallPropertyMetaData callProp : portComp.getCallProperties()) {
                epMetaData.getProperties().put(callProp.getPropName(), callProp.getPropValue());
            }
        }
    }

    protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint) {
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getInterface().getWsdlDefinitions();
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        for (WSDLInterfaceOperation wsdlOperation : wsdlInterface.getOperations()) {
            WSDLBinding wsdlBinding;
            WSDLBindingOperation wsdlBindingOperation;
            String opName = wsdlOperation.getName().toString();
            QName opQName = wsdlOperation.getName();
            String javaName = opName.substring(0, 1).toLowerCase() + opName.substring(1);
            OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
            epMetaData.addOperation(opMetaData);
            String style = wsdlOperation.getStyle();
            epMetaData.setStyle("http://www.w3.org/2004/03/wsdl/style/iri".equals(style) ? Style.DOCUMENT : Style.RPC);
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
                opMetaData.setOneWay(true);
            }
            if ((wsdlBindingOperation = (wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getName())).getOperationByRef(opQName)) == null) continue;
            opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
        }
    }

    public void rebuildEndpointMetaData(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"START: rebuildMetaData");
        }
        this.resetMetaDataBuilder(epMetaData.getClassLoader());
        epMetaData.setParameterStyle(null);
        if (wsClass.isAnnotationPresent(BindingType.class)) {
            this.processBindingType(epMetaData, wsClass);
        }
        if (wsClass.isAnnotationPresent(SOAPBinding.class)) {
            this.processSOAPBinding(epMetaData, wsClass);
        }
        this.processEndpointConfig(epMetaData, wsClass);
        epMetaData.initEndpointConfig();
        this.processHandlerChain(epMetaData, wsClass);
        this.processWebMethods(epMetaData, wsClass);
        this.processXmlSeeAlso(wsClass);
        this.createJAXBContext(epMetaData);
        this.populateXmlTypes(epMetaData);
        epMetaData.setServiceEndpointInterfaceName(wsClass.getName());
        this.processServiceRefContributions(epMetaData);
        epMetaData.eagerInitialize();
        if (epMetaData.getConfig().getRMMetaData() != null) {
            RMHelper.setupRMOperations(epMetaData);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("END: rebuildMetaData\n" + epMetaData.getServiceMetaData()));
        }
    }

    private void processEndpointConfig(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (wsClass.isAnnotationPresent(EndpointConfig.class)) {
            EndpointConfig anConfig = wsClass.getAnnotation(EndpointConfig.class);
            epMetaData.setConfigName(anConfig.configName(), anConfig.configFile());
        }
    }
}

