/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.wsf.spi.invocation.ExtensibleWebServiceContext;
import org.w3c.dom.Element;

public abstract class NativeWebServiceContext
extends ExtensibleWebServiceContext {
    public NativeWebServiceContext(MessageContext messageContext) {
        super(messageContext);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        EndpointMetaData epMetaData = ((CommonMessageContext)this.getMessageContext()).getEndpointMetaData();
        if (epMetaData == null) {
            throw new WebServiceException("Cannot get EndpointMetaData!");
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(epMetaData.getBindingId())) {
            throw new UnsupportedOperationException("Cannot get epr when using the XML/HTTP binding");
        }
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        String address = epMetaData.getEndpointAddress();
        builder.address(address);
        builder.wsdlDocumentLocation(address + "?wsdl");
        if (referenceParameters != null && W3CEndpointReference.class.getName().equals(clazz.getName())) {
            for (Element el : referenceParameters) {
                builder.referenceParameter(el);
            }
        }
        return EndpointReferenceUtil.transform(clazz, (EndpointReference)builder.build());
    }
}

