/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.jcip.annotations.GuardedBy;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.MulticastSocketFactory;
import org.jboss.modcluster.advertise.impl.AdvertisedServer;
import org.jboss.modcluster.config.AdvertiseConfiguration;
import org.jboss.modcluster.mcmp.MCMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertiseListenerImpl
implements AdvertiseListener {
    public static final int DEFAULT_PORT = 23364;
    public static final String DEFAULT_GROUP = "224.0.1.105";
    public static final String DEFAULT_ENCODING = "8859_1";
    public static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    static final Logger log = Logger.getLogger(AdvertiseListenerImpl.class);
    volatile boolean listening = false;
    final int advertisePort;
    final InetAddress groupAddress;
    private final InetAddress socketInterface;
    private final ThreadFactory threadFactory;
    private final MulticastSocketFactory socketFactory;
    private final String securityKey;
    MessageDigest md = null;
    final Map<String, AdvertisedServer> servers = new HashMap<String, AdvertisedServer>();
    final MCMPHandler handler;
    @GuardedBy(value="this")
    private MulticastSocket socket;
    @GuardedBy(value="this")
    private AdvertiseListenerWorker worker;
    @GuardedBy(value="this")
    private Thread thread;

    private static void digestString(MessageDigest md, String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[i] = c < '\u007f' ? (int)c : 63;
        }
        md.update(b);
    }

    public AdvertiseListenerImpl(MCMPHandler commHandler, AdvertiseConfiguration config, MulticastSocketFactory socketFactory) throws IOException {
        this.handler = commHandler;
        this.socketFactory = socketFactory;
        this.threadFactory = config.getAdvertiseThreadFactory();
        String groupAddress = config.getAdvertiseGroupAddress();
        this.groupAddress = InetAddress.getByName(groupAddress != null ? groupAddress : DEFAULT_GROUP);
        int port = config.getAdvertisePort();
        this.advertisePort = port > 0 ? port : 23364;
        this.securityKey = config.getAdvertiseSecurityKey();
        String advertiseInterface = config.getAdvertiseInterface();
        this.socketInterface = advertiseInterface != null ? InetAddress.getByName(advertiseInterface) : null;
    }

    public Collection<AdvertisedServer> getServers() {
        return this.servers.values();
    }

    public AdvertisedServer getServer(String name) {
        return this.servers.get(name);
    }

    public void removeServer(AdvertisedServer server) {
        this.servers.values().remove(server);
    }

    private synchronized void init() throws IOException {
        if (this.socket == null) {
            MulticastSocket socket = this.socketFactory.createMulticastSocket(this.groupAddress, this.advertisePort);
            socket.setTimeToLive(0);
            if (this.socketInterface != null) {
                socket.setInterface(this.socketInterface);
            }
            socket.joinGroup(this.groupAddress);
            this.socket = socket;
        }
    }

    @Override
    public synchronized void start() throws IOException {
        this.init();
        if (this.worker == null) {
            this.worker = new AdvertiseListenerWorker(this.socket);
            this.thread = this.threadFactory.newThread(this.worker);
            this.thread.start();
            this.listening = true;
            log.info((Object)Strings.ADVERTISE_START.getString(this.groupAddress.getHostAddress(), String.valueOf(this.advertisePort)));
        }
    }

    @Override
    public synchronized void pause() {
        if (this.worker != null) {
            this.worker.suspendWorker();
            this.interruptDatagramReader();
        }
    }

    @Override
    public synchronized void resume() {
        if (this.worker != null) {
            this.worker.resumeWorker();
        }
    }

    public synchronized void interruptDatagramReader() {
        if (this.socket == null) {
            return;
        }
        DatagramPacket packet = this.worker.createInterruptPacket(this.groupAddress, this.advertisePort);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to interrupt socket reception", (Throwable)e);
        }
    }

    @Override
    public synchronized void stop() {
        this.resume();
        if (this.thread != null) {
            this.thread.interrupt();
            this.interruptDatagramReader();
            this.thread = null;
            this.worker = null;
            this.listening = false;
        }
    }

    @Override
    public synchronized void destroy() {
        this.stop();
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.groupAddress);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.socket.close();
            this.socket = null;
        }
    }

    boolean verifyDigest(String digest, String server, String date, String sequence) {
        if (this.md == null) {
            return true;
        }
        if (this.securityKey == null) {
            return true;
        }
        this.md.reset();
        AdvertiseListenerImpl.digestString(this.md, this.securityKey);
        byte[] ssalt = this.md.digest();
        this.md.update(ssalt);
        AdvertiseListenerImpl.digestString(this.md, date);
        AdvertiseListenerImpl.digestString(this.md, sequence);
        AdvertiseListenerImpl.digestString(this.md, server);
        byte[] our = this.md.digest();
        if (our.length != digest.length() / 2) {
            return false;
        }
        int val = 0;
        for (int i = 0; i < digest.length(); ++i) {
            char ch = digest.charAt(i);
            if (i % 2 == 0) {
                val = ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48;
                continue;
            }
            if (our[i / 2] == (byte)(val = val * 16 + (ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48))) continue;
            return false;
        }
        return true;
    }

    public boolean isListening() {
        return this.listening;
    }

    class AdvertiseListenerWorker
    implements Runnable {
        private final MulticastSocket socket;
        @GuardedBy(value="this")
        private boolean paused = false;
        @GuardedBy(value="this")
        private byte[] secure = this.generateSecure();

        AdvertiseListenerWorker(MulticastSocket socket) {
            this.socket = socket;
        }

        public synchronized void suspendWorker() {
            this.paused = true;
        }

        public synchronized void resumeWorker() {
            if (this.paused) {
                this.paused = false;
                this.secure = this.generateSecure();
                this.notify();
            }
        }

        public synchronized DatagramPacket createInterruptPacket(InetAddress address, int port) {
            return new DatagramPacket(this.secure, this.secure.length, address, port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(AdvertiseListenerImpl.RFC_822_FMT, Locale.US);
            byte[] buffer = new byte[512];
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String message;
                    AdvertiseListenerWorker advertiseListenerWorker = this;
                    synchronized (advertiseListenerWorker) {
                        if (this.paused) {
                            this.wait();
                        }
                    }
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    if (this.matchesSecure(packet) || !(message = new String(packet.getData(), 0, packet.getLength(), AdvertiseListenerImpl.DEFAULT_ENCODING)).startsWith("HTTP/1.")) continue;
                    String[] headers = message.split("\r\n");
                    String date_str = null;
                    Date date = null;
                    int status = 0;
                    String status_desc = null;
                    String digest = null;
                    String server_name = null;
                    String sequence = null;
                    AdvertisedServer server = null;
                    boolean added = false;
                    for (int i = 0; i < headers.length; ++i) {
                        if (i == 0) {
                            String[] sline = headers[i].split(" ", 3);
                            if (sline == null || sline.length != 3 || (status = Integer.parseInt(sline[1])) < 100) break;
                            status_desc = sline[2];
                            continue;
                        }
                        String[] hdrv = headers[i].split(": ", 2);
                        if (hdrv == null || hdrv.length != 2) break;
                        if (hdrv[0].equals("Date")) {
                            date_str = hdrv[1];
                            try {
                                date = dateFormat.parse(date_str);
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            continue;
                        }
                        if (hdrv[0].equals("Digest")) {
                            digest = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Sequence")) {
                            sequence = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Server")) {
                            server_name = hdrv[1];
                            server = AdvertiseListenerImpl.this.servers.get(server_name);
                            if (server != null) continue;
                            server = new AdvertisedServer(server_name);
                            added = true;
                            continue;
                        }
                        if (server == null) continue;
                        server.setParameter(hdrv[0], hdrv[1]);
                    }
                    if (server != null && status > 0) {
                        if (!AdvertiseListenerImpl.this.verifyDigest(digest, server_name, date_str, sequence)) continue;
                        server.setDate(date);
                        boolean rc = server.setStatus(status, status_desc);
                        if (added) {
                            AdvertiseListenerImpl.this.servers.put(server_name, server);
                            String proxy = server.getParameter(AdvertisedServer.MANAGER_ADDRESS);
                            if (proxy != null) {
                                AdvertiseListenerImpl.this.handler.addProxy(Utils.parseSocketAddress(proxy));
                            }
                        } else if (rc) {
                            // empty if block
                        }
                    }
                    AdvertiseListenerImpl.this.listening = true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    AdvertiseListenerImpl.this.listening = false;
                    Thread.yield();
                }
            }
        }

        private byte[] generateSecure() {
            SecureRandom random = new SecureRandom();
            byte[] secure = new byte[16];
            random.nextBytes(secure);
            secure[0] = 0;
            return secure;
        }

        synchronized boolean matchesSecure(DatagramPacket packet) {
            if (packet.getLength() != this.secure.length) {
                return false;
            }
            byte[] data = packet.getData();
            for (int i = 0; i < this.secure.length; ++i) {
                if (data[i] == this.secure[i]) continue;
                return false;
            }
            return true;
        }
    }
}

