/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.javaidl.interceptors.context;

import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jts.common.InterceptorInfo;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.TransactionalObject;
import org.omg.CosTransactions.TransactionalObjectHelper;
import org.omg.CosTransactions.Unavailable;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

class ContextClientRequestInterceptorImpl
extends LocalObject
implements ClientRequestInterceptor {
    private int _localSlot;
    private Codec _codec;
    private ThreadLocal _inUse = new ThreadLocal();

    public void destroy() {
    }

    public ContextClientRequestInterceptorImpl(int localSlot, Codec codec) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 16640L, "ContextClientRequestInterceptorImpl ( " + localSlot + " )");
        }
        this._localSlot = localSlot;
        this._codec = codec;
    }

    public String name() {
        return "OTS_Context";
    }

    public void send_request(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextClientRequestInterceptorImpl::send_request ( " + request_info + " )");
        }
        if (this.systemCall(request_info)) {
            return;
        }
        boolean otsAlwaysPropagate = InterceptorInfo.getAlwaysPropagate();
        try {
            if (!otsAlwaysPropagate) {
                TransactionalObject ptr = TransactionalObjectHelper.narrow(request_info.target());
                if (ptr == null) {
                    throw new BAD_PARAM();
                }
            } else {
                if (this._inUse.get() != null) {
                    return;
                }
                this._inUse.set(this._inUse);
            }
            try {
                Any localData = request_info.get_slot(this._localSlot);
                String threadId = null;
                boolean problem = false;
                String stringRef = null;
                if (localData.type().kind().value() != 0) {
                    threadId = localData.extract_string();
                    if (threadId == null) {
                        throw new UNKNOWN(jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.invalidparam"));
                    }
                } else {
                    threadId = ThreadUtil.getThreadId();
                }
                if (threadId != null) {
                    ControlWrapper theControl = OTSImpleManager.current().contextManager().current(threadId);
                    if (theControl != null) {
                        try {
                            Coordinator theCoordinator = theControl.get_coordinator();
                            if (theCoordinator != null) {
                                stringRef = ORBManager.getORB().orb().object_to_string((Object)theCoordinator);
                            } else {
                                problem = true;
                            }
                        }
                        catch (Unavailable e) {
                            problem = true;
                        }
                        theControl = null;
                    } else {
                        problem = true;
                    }
                } else {
                    problem = true;
                }
                if (problem) {
                    if (InterceptorInfo.getNeedTranContext()) {
                        throw new TRANSACTION_REQUIRED();
                    }
                    stringRef = null;
                }
                if (stringRef != null) {
                    Any data = ORBManager.getORB().orb().create_any();
                    data.insert_string(stringRef);
                    byte[] octets = this._codec.encode_value(data);
                    ServiceContext service_context = new ServiceContext(-559038737, octets);
                    request_info.add_request_service_context(service_context, true);
                }
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception ex) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.error", ex);
                }
                throw new UNKNOWN(ex.toString());
            }
            finally {
                if (otsAlwaysPropagate) {
                    this._inUse.set(null);
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
    }

    public void send_poll(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextClientRequestInterceptorImpl::send_poll ( " + request_info + " )");
        }
    }

    public void receive_reply(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextClientRequestInterceptorImpl::receive_reply ( " + request_info + " )");
        }
    }

    public void receive_exception(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextClientRequestInterceptorImpl::receive_exception ( " + request_info + " )");
        }
    }

    public void receive_other(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextClientRequestInterceptorImpl::receive_other ( " + request_info + " )");
        }
    }

    private final boolean systemCall(ClientRequestInfo request_info) {
        return request_info.operation().equals("_is_a");
    }
}

