/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logging.AbstractLoggerPluginInstance;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;
import org.jboss.logging.jdk.JBossLevel;

public class JDK14LoggerPluginInstance
extends AbstractLoggerPluginInstance
implements LoggerPluginInstance {
    private final Logger log;
    private final String name;
    private static final Map<Logger.Level, Level> LEVEL_MAP;

    public JDK14LoggerPluginInstance(String name, String resourceBundleName, LoggerPlugin loggerPlugin) {
        super(name, resourceBundleName, loggerPlugin);
        this.name = name;
        this.log = resourceBundleName == null ? Logger.getLogger(name) : Logger.getLogger(name, resourceBundleName);
    }

    public boolean isEnabled(Logger.Level level) {
        return this.log.isLoggable(LEVEL_MAP.get(level));
    }

    public void log(Logger.Level level, String loggerFqcn, Object message, Object[] params, Throwable t) {
        LogRecord record = new LogRecord(LEVEL_MAP.get(level), String.valueOf(message));
        record.setParameters(params);
        record.setLoggerName(this.name);
        record.setThrown(t);
        record.setSourceMethodName(null);
        this.log.log(record);
    }

    protected void log(Logger.Level level, String loggerFqcn, String message, Throwable t) {
        LogRecord record = new LogRecord(LEVEL_MAP.get(level), message);
        record.setLoggerName(this.name);
        record.setThrown(t);
        record.setSourceMethodName(null);
        this.log.log(record);
    }

    static {
        EnumMap<Logger.Level, Level> map = new EnumMap<Logger.Level, Level>(Logger.Level.class);
        map.put(Logger.Level.TRACE, JBossLevel.TRACE);
        map.put(Logger.Level.DEBUG, JBossLevel.DEBUG);
        map.put(Logger.Level.INFO, JBossLevel.INFO);
        map.put(Logger.Level.WARN, JBossLevel.WARN);
        map.put(Logger.Level.ERROR, JBossLevel.ERROR);
        map.put(Logger.Level.FATAL, JBossLevel.FATAL);
        LEVEL_MAP = map;
    }
}

