/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.beans.PropertyEditorManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.IntArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityActions {
    private static void doInitEditors() {
        String[] currentPath = PropertyEditorManager.getEditorSearchPath();
        int length = currentPath != null ? currentPath.length : 0;
        String[] newPath = new String[length + 2];
        System.arraycopy(currentPath, 0, newPath, 2, length);
        newPath[0] = "org.jboss.util.propertyeditor";
        newPath[1] = "org.jboss.mx.util.propertyeditor";
        PropertyEditorManager.setEditorSearchPath(newPath);
        Class<String[]> strArrayType = String[].class;
        PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
        Class<Class[]> clsArrayType = Class[].class;
        PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
        Class<int[]> intArrayType = int[].class;
        PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
    }

    static void initEditors() {
        if (System.getSecurityManager() == null) {
            InitPropertyEditorsAction.NON_PRIVILEGED.initEditors();
        } else {
            InitPropertyEditorsAction.PRIVILEGED.initEditors();
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static interface InitPropertyEditorsAction {
        public static final InitPropertyEditorsAction PRIVILEGED = new InitPropertyEditorsAction(){

            public void initEditors() {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            SecurityActions.doInitEditors();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
        };
        public static final InitPropertyEditorsAction NON_PRIVILEGED = new InitPropertyEditorsAction(){

            public void initEditors() {
                SecurityActions.doInitEditors();
            }
        };

        public void initEditors();
    }
}

