/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.bootstrap;

import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineException;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ConnectionlessBootstrap
extends Bootstrap {
    public ConnectionlessBootstrap() {
    }

    public ConnectionlessBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public Channel bind() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bind(localAddress);
    }

    public Channel bind(SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        LinkedBlockingQueue<ChannelFuture> futureQueue = new LinkedBlockingQueue<ChannelFuture>();
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        pipeline.addFirst("binder", new ConnectionlessBinder(localAddress, futureQueue));
        Channel channel = this.getFactory().newChannel(pipeline);
        ChannelFuture future = null;
        do {
            try {
                future = (ChannelFuture)futureQueue.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (future == null);
        pipeline.remove("binder");
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            future.getChannel().close().awaitUninterruptibly();
            throw new ChannelException("Failed to bind to: " + localAddress, future.getCause());
        }
        return channel;
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remotedAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        LinkedBlockingQueue<ChannelFuture> futureQueue = new LinkedBlockingQueue<ChannelFuture>();
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        pipeline.addFirst("connector", new ClientBootstrap.Connector(this, remoteAddress, localAddress, futureQueue));
        this.getFactory().newChannel(pipeline);
        ChannelFuture future = null;
        do {
            try {
                future = (ChannelFuture)futureQueue.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (future == null);
        pipeline.remove("connector");
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ChannelPipelineCoverage(value="one")
    private final class ConnectionlessBinder
    extends SimpleChannelUpstreamHandler {
        private final SocketAddress localAddress;
        private final BlockingQueue<ChannelFuture> futureQueue;

        ConnectionlessBinder(SocketAddress localAddress, BlockingQueue<ChannelFuture> futureQueue) {
            this.localAddress = localAddress;
            this.futureQueue = futureQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) {
            try {
                evt.getChannel().getConfig().setPipelineFactory(ConnectionlessBootstrap.this.getPipelineFactory());
                evt.getChannel().getConfig().setOptions(ConnectionlessBootstrap.this.getOptions());
                Object var4_3 = null;
                ctx.sendUpstream(evt);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ctx.sendUpstream(evt);
                throw throwable;
            }
            boolean finished = this.futureQueue.offer(evt.getChannel().bind(this.localAddress));
            assert (finished);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            boolean finished = this.futureQueue.offer(Channels.failedFuture(e.getChannel(), e.getCause()));
            assert (finished);
            ctx.sendUpstream(e);
        }
    }
}

