/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDatagramWorker.class);
    private final int id;
    private final int bossId;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = new LinkedTransferQueue<Runnable>();
    private final Queue<Runnable> writeTaskQueue = new LinkedTransferQueue<Runnable>();

    NioDatagramWorker(int bossId, int id, Executor executor) {
        this.bossId = bossId;
        this.id = id;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(NioDatagramChannel channel, ChannelFuture future) {
        Selector selector;
        ChannelRegistionTask channelRegTask = new ChannelRegistionTask(channel, future);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                boolean success = false;
                try {
                    this.executor.execute(new ThreadRenamingRunnable(this, "New I/O server worker #" + this.bossId + "'-'" + this.id));
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            selector.close();
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to close a selector.", t);
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(channelRegTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        Selector selector = this.selector;
        boolean shutdown = false;
        while (true) {
            this.wakenUp.set(false);
            if (NioProviderMetadata.CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                int selectedKeyCount = selector.select(500L);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                if (selectedKeyCount > 0) {
                    NioDatagramWorker.processSelectedKeys(selector.selectedKeys());
                }
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
        }
    }

    private void processWriteTaskQueue() {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
        }
    }

    private static void processSelectedKeys(Set<SelectionKey> selectedKeys) {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if ((readyOps & 1) != 0 && !NioDatagramWorker.read(k) || (readyOps & 4) == 0) continue;
                NioDatagramWorker.write(k);
            }
            catch (CancelledKeyException e) {
                NioDatagramWorker.close(k);
            }
        }
    }

    private static void write(SelectionKey k) {
        NioDatagramWorker.write((NioDatagramChannel)k.attachment(), false);
    }

    private static boolean read(SelectionKey key) {
        NioDatagramChannel channel = (NioDatagramChannel)key.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        DatagramChannel nioChannel = (DatagramChannel)key.channel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(predictor.nextReceiveBufferSize()).order(bufferFactory.getDefaultOrder());
        boolean failure = true;
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = nioChannel.receive(byteBuffer);
            failure = false;
        }
        catch (AsynchronousCloseException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (remoteAddress != null) {
            byteBuffer.flip();
            int readBytes = byteBuffer.remaining();
            if (readBytes > 0) {
                predictor.previousReceiveBufferSize(readBytes);
                ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(byteBuffer);
                Channels.fireMessageReceived(channel, (Object)channelBuffer, remoteAddress);
            }
        }
        if (failure) {
            NioDatagramWorker.close(key);
            return false;
        }
        return true;
    }

    private static void close(SelectionKey k) {
        NioDatagramChannel ch = (NioDatagramChannel)k.attachment();
        NioDatagramWorker.close(ch, Channels.succeededFuture(ch));
    }

    static void write(NioDatagramChannel channel, boolean mightNeedWakeup) {
        if (!channel.isOpen()) {
            NioDatagramWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (mightNeedWakeup && NioDatagramWorker.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.inWriteNowLoop) {
            NioDatagramWorker.scheduleWriteIfNecessary(channel);
        } else {
            NioDatagramWorker.writeNow(channel, channel.getConfig().getWriteSpinCount());
        }
    }

    private static boolean scheduleWriteIfNecessary(NioDatagramChannel channel) {
        NioDatagramWorker worker = channel.worker;
        Thread workerThread = worker.thread;
        if (workerThread == null || Thread.currentThread() != workerThread) {
            Selector workerSelector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = worker.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((workerSelector = worker.selector) != null && worker.wakenUp.compareAndSet(false, true)) {
                workerSelector.wakeup();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNow(NioDatagramChannel channel, int writeSpinCount) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        int writtenBytes = 0;
        Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            MessageEvent evt = channel.currentWriteEvent;
            while (true) {
                ChannelBuffer buf;
                if (evt == null) {
                    evt = writeBuffer.poll();
                    if (evt == null) {
                        channel.currentWriteEvent = null;
                        removeOpWrite = true;
                        break;
                    }
                    evt = NioWorker.consolidateComposite(evt);
                    buf = (ChannelBuffer)evt.getMessage();
                } else {
                    buf = (ChannelBuffer)evt.getMessage();
                }
                try {
                    int localWrittenBytes = 0;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = evt.getRemoteAddress() == null ? buf.getBytes(buf.readerIndex(), channel.getDatagramChannel(), buf.readableBytes()) : channel.getDatagramChannel().send(buf.toByteBuffer(), evt.getRemoteAddress());
                        if (localWrittenBytes == 0) continue;
                        writtenBytes += localWrittenBytes;
                        break;
                    }
                    if (localWrittenBytes > 0) {
                        evt.getFuture().setSuccess();
                        evt = null;
                        continue;
                    }
                    channel.currentWriteEvent = evt;
                    addOpWrite = true;
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    evt.getFuture().setFailure(t);
                    evt = null;
                    Channels.fireExceptionCaught(channel, t);
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    NioDatagramWorker.close(channel, Channels.succeededFuture(channel));
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
        }
        Channels.fireWriteComplete(channel, writtenBytes);
        if (open) {
            if (addOpWrite) {
                NioDatagramWorker.setOpWrite(channel);
            } else if (removeOpWrite) {
                NioDatagramWorker.clearOpWrite(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOpWrite(NioDatagramChannel channel) {
        int interestOps;
        NioDatagramWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.getDatagramChannel().keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            NioDatagramWorker.close(key);
            return;
        }
        boolean changed = false;
        Object object = channel.interestOpsLock;
        synchronized (object) {
            interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) == 0) {
                key.interestOps(interestOps |= 4);
                changed = true;
            }
        }
        if (changed) {
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOpWrite(NioDatagramChannel channel) {
        int interestOps;
        NioDatagramWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.getDatagramChannel().keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            NioDatagramWorker.close(key);
            return;
        }
        boolean changed = false;
        Object object = channel.interestOpsLock;
        synchronized (object) {
            interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps &= 0xFFFFFFFB);
                changed = true;
            }
        }
        if (changed) {
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    static void disconnect(NioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        try {
            channel.getDatagramChannel().disconnect();
            future.setSuccess();
            if (connected) {
                Channels.fireChannelDisconnected(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    static void close(NioDatagramChannel channel, ChannelFuture future) {
        NioDatagramWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.getDatagramChannel().keyFor(selector);
        if (key != null) {
            key.cancel();
        }
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.getDatagramChannel().close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                NioDatagramWorker.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpWriteBuffer(NioDatagramChannel channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            Queue<MessageEvent> writeBuffer;
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                channel.currentWriteEvent = null;
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                evt.getFuture().setFailure(cause);
                fireExceptionCaught = true;
            }
            if (!(writeBuffer = channel.writeBufferQueue).isEmpty()) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(NioDatagramChannel channel, ChannelFuture future, int interestOps) {
        boolean changed = false;
        try {
            Object object = channel.interestOpsLock;
            synchronized (object) {
                NioDatagramWorker worker = channel.worker;
                Selector selector = worker.selector;
                SelectionKey key = channel.getDatagramChannel().keyFor(selector);
                if (key == null || selector == null) {
                    channel.setRawInterestOpsNow(interestOps);
                    return;
                }
                interestOps &= 0xFFFFFFFB;
                interestOps |= channel.getRawInterestOps() & 4;
                switch (NioProviderMetadata.CONSTRAINT_LEVEL) {
                    case 0: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        key.interestOps(interestOps);
                        if (Thread.currentThread() != worker.thread && worker.wakenUp.compareAndSet(false, true)) {
                            selector.wakeup();
                        }
                        changed = true;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        if (Thread.currentThread() == worker.thread) {
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        worker.selectorGuard.readLock().lock();
                        try {
                            if (worker.wakenUp.compareAndSet(false, true)) {
                                selector.wakeup();
                            }
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        finally {
                            worker.selectorGuard.readLock().unlock();
                        }
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            future.setSuccess();
            if (changed) {
                channel.setRawInterestOpsNow(interestOps);
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class ChannelRegistionTask
    implements Runnable {
        private final NioDatagramChannel channel;
        private final ChannelFuture future;

        ChannelRegistionTask(NioDatagramChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InetSocketAddress localAddress = this.channel.getLocalAddress();
            if (localAddress == null) {
                if (this.future != null) {
                    this.future.setFailure(new ClosedChannelException());
                }
                NioDatagramWorker.close(this.channel, Channels.succeededFuture(this.channel));
                return;
            }
            try {
                Object object = this.channel.interestOpsLock;
                synchronized (object) {
                    this.channel.getDatagramChannel().register(NioDatagramWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                }
                if (this.future != null) {
                    this.future.setSuccess();
                }
            }
            catch (ClosedChannelException e) {
                if (this.future != null) {
                    this.future.setFailure(e);
                }
                NioDatagramWorker.close(this.channel, Channels.succeededFuture(this.channel));
                throw new ChannelException("Failed to register a socket to the selector.", e);
            }
        }
    }
}

