/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.deployers.vfs.spi.structure.modified.AbstractStructureCache;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeStructureCache<T>
extends AbstractStructureCache<T> {
    private final Node<T> root = this.createRoot();

    protected Node<T> createRoot() {
        return new Node(null, this.getDefaultValue(), null);
    }

    protected T getDefaultValue() {
        return null;
    }

    @Override
    public void initializeCache(VirtualFile root) {
        this.initializeNode(root);
    }

    @Override
    public T putCacheValue(VirtualFile file, T value) {
        Node<T> node = this.initializeNode(file);
        T previous = node.getValue();
        node.setValue(value);
        return previous;
    }

    @Override
    public T getCacheValue(VirtualFile file) {
        Node<T> node = this.getNode(file);
        return node != null ? (T)node.getValue() : null;
    }

    @Override
    public List<VirtualFile> getLeaves(VirtualFile file, VirtualFileFilter filter) {
        Node<T> node = this.getNode(file);
        if (node != null) {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            Collection<Node<T>> children = node.getChildren();
            if (children != null && !children.isEmpty()) {
                for (Node<T> child : children) {
                    VirtualFile vf = child.getFile();
                    if (filter != null && !filter.accepts(vf)) continue;
                    result.add(vf);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public void invalidateCache(VirtualFile file) {
        this.removeCache(file);
    }

    @Override
    public void removeCache(VirtualFile file) {
        Node<T> node = this.getNode(file);
        if (node != null) {
            Node<T> parent = node.getParent();
            if (parent != null) {
                parent.removeChild(node);
            } else {
                this.flush();
            }
        }
    }

    @Override
    public void removeCache(VirtualFile root, String path) {
        List tokens;
        Node<T> child;
        Node<T> node = this.getNode(root);
        if (node != null && (child = this.findNode(0, tokens = PathTokenizer.getTokens((String)path), node)) != null) {
            Node<T> parent = child.getParent();
            if (parent != null) {
                parent.removeChild(node);
            } else {
                this.flush();
            }
        }
    }

    protected Node<T> findNode(int index, List<String> tokens, Node<T> node) {
        if (index == tokens.size()) {
            return node;
        }
        Collection<Node<T>> nodes = node.getChildren();
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        String token = tokens.get(index);
        for (Node<T> child : nodes) {
            VirtualFile file = child.getFile();
            if (!token.equals(file.getName())) continue;
            return this.findNode(index + 1, tokens, child);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Node<T> node = this.root;
        synchronized (node) {
            this.root.clear();
        }
    }

    protected List<VirtualFile> tokens(VirtualFile file) {
        try {
            ArrayList<VirtualFile> tokens = new ArrayList<VirtualFile>();
            while (file != null) {
                tokens.add(0, file);
                file = file.getParent();
            }
            return tokens;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> getNode(VirtualFile file) {
        List<VirtualFile> tokens = this.tokens(file);
        Node<T> node = this.root;
        synchronized (node) {
            VirtualFile token;
            Node<T> node2 = this.root;
            Iterator<VirtualFile> i$ = tokens.iterator();
            while (i$.hasNext() && (node2 = node2.getChild(token = i$.next())) != null) {
            }
            return node2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> initializeNode(VirtualFile file) {
        List<VirtualFile> tokens = this.tokens(file);
        Node<T> node = this.root;
        synchronized (node) {
            Node<Object> node2 = this.root;
            boolean newNode = false;
            for (VirtualFile token : tokens) {
                if (newNode) {
                    node2 = new Node(token, this.getDefaultValue(), node2);
                    continue;
                }
                Node<Object> child = node2.getChild(token);
                if (child == null) {
                    child = new Node(token, this.getDefaultValue(), node2);
                    newNode = true;
                }
                node2 = child;
            }
            return node2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<U> {
        private ReadWriteLock lock = new ReentrantReadWriteLock();
        private VirtualFile file;
        private Node<U> parent;
        private U value;
        private Map<VirtualFile, Node<U>> children;

        private Node(VirtualFile file, U value, Node<U> parent) {
            this.file = file;
            this.value = value;
            this.parent = parent;
            if (parent != null) {
                super.addChild(this);
            }
        }

        public VirtualFile getFile() {
            return this.file;
        }

        public U getValue() {
            return this.value;
        }

        public void setValue(U value) {
            this.value = value;
        }

        public Node<U> getParent() {
            return this.parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addChild(Node<U> node) {
            this.lock.writeLock().lock();
            try {
                if (this.children == null) {
                    this.children = new HashMap<VirtualFile, Node<U>>();
                }
                this.children.put(node.getFile(), node);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChild(Node<U> node) {
            this.lock.writeLock().lock();
            try {
                if (this.children == null) {
                    return;
                }
                this.children.remove(node.getFile());
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock.writeLock().lock();
            try {
                this.value = null;
                this.children = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Node<U> getChild(VirtualFile file) {
            this.lock.readLock().lock();
            try {
                Node<U> node = this.children != null ? this.children.get(file) : null;
                return node;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Node<U>> getChildren() {
            this.lock.readLock().lock();
            try {
                Set<Node<U>> set = this.children != null ? this.children.values() : Collections.emptySet();
                return set;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public String toString() {
            return String.valueOf(this.file);
        }
    }
}

