/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.endpoint.Endpoint;
import org.jboss.ejb3.endpoint.deployers.EndpointResolver;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.ejb.JBossSessionBeanDescriptorAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSessionObjectReference
implements SessionObjectReference {
    private static final String MC_BIND_NAME_ENDPOINT_RESOLVER = "EJB3EndpointResolver";
    private static final long serialVersionUID = 8227728506645839338L;
    private final Object reference;
    private final Serializable id;
    private final DeploymentUnit deploymentUnit;
    private final String ejbClassName;
    private final String jndiName;
    private final boolean stateful;
    boolean removed = false;

    public JBossSessionObjectReference(EjbDescriptor<?> descriptor, Context context) throws NamingException {
        if (!(descriptor instanceof JBossSessionBeanDescriptorAdaptor)) {
            throw new IllegalArgumentException("Can only operate on JBoss EJB3");
        }
        this.jndiName = ((JBossSessionBeanDescriptorAdaptor)descriptor).getLocalJndiName();
        this.reference = context.lookup(this.jndiName);
        SessionProxyInvocationHandler handler = (SessionProxyInvocationHandler)Proxy.getInvocationHandler(this.reference);
        this.id = (Serializable)handler.getTarget();
        this.deploymentUnit = ((JBossSessionBeanDescriptorAdaptor)descriptor).getDeploymentUnit();
        this.ejbClassName = descriptor.getBeanClass().getSimpleName();
        this.stateful = descriptor.isStateful();
    }

    public <S> S getBusinessObject(Class<S> businessInterfaceType) {
        return (S)this.reference;
    }

    public void remove() {
        if (!this.stateful) {
            throw new UnsupportedOperationException("Can only remove stateful beans " + this);
        }
        this.getEndpoint().getSessionFactory().destroySession(this.id);
        this.removed = true;
    }

    private Endpoint getEndpoint() {
        Ejb3Registrar registrar = Ejb3RegistrarLocator.locateRegistrar();
        EndpointResolver resolver = (EndpointResolver)registrar.lookup((Object)MC_BIND_NAME_ENDPOINT_RESOLVER, EndpointResolver.class);
        String endpointMcBindName = resolver.resolve(this.deploymentUnit, this.ejbClassName);
        return (Endpoint)registrar.lookup((Object)endpointMcBindName, Endpoint.class);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String toString() {
        return "Session bean reference: " + this.jndiName + " with id: " + this.id;
    }
}

