/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpSessionListener;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.catalina.CatalinaHost;

public class CatalinaContext
implements Context {
    private final org.apache.catalina.Context context;
    private final Host host;

    public CatalinaContext(org.apache.catalina.Context context, Host host) {
        this.context = context;
        this.host = host;
    }

    public CatalinaContext(org.apache.catalina.Context context) {
        this(context, new CatalinaHost((org.apache.catalina.Host)context.getParent()));
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        return this.context.getPath();
    }

    public boolean isStarted() {
        try {
            return this.context.isStarted();
        }
        catch (NoSuchMethodError e) {
            return true;
        }
    }

    public int getActiveSessionCount() {
        return this.context.getManager().getActiveSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            Object[] listeners = this.context.getApplicationLifecycleListeners();
            ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length + 1);
            listenerList.add(listener);
            listenerList.addAll(Arrays.asList(listeners));
            this.context.setApplicationLifecycleListeners(listenerList.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            ArrayList<Object> listenerList = new ArrayList<Object>(Arrays.asList(this.context.getApplicationLifecycleListeners()));
            listenerList.remove(listener);
            this.context.setApplicationLifecycleListeners(listenerList.toArray());
        }
    }

    public String toString() {
        return this.context.getPath();
    }
}

