/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.catalina.CatalinaContext;
import org.jboss.modcluster.catalina.CatalinaEngine;
import org.jboss.modcluster.catalina.CatalinaServer;

public class CatalinaEventHandlerAdapter
implements LifecycleListener,
ContainerListener {
    private volatile boolean init = false;
    private ContainerEventHandler eventHandler;

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                this.eventHandler.add(new CatalinaContext((Context)child));
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
                Host host = (Host)child;
                if (host != null) {
                    host.addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                this.eventHandler.remove(new CatalinaContext((Context)child));
            } else if (container instanceof Engine) {
                Host host = (Host)child;
                if (host != null) {
                    host.removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (type.equals("start")) {
            if (source instanceof Context) {
                this.eventHandler.start(new CatalinaContext((Context)source));
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server) {
                Server server = (Server)source;
                CatalinaServer catalinaServer = new CatalinaServer(server);
                this.eventHandler.init(catalinaServer);
                this.addListeners(server);
                this.eventHandler.start(catalinaServer);
                this.init = true;
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof Context) {
                this.eventHandler.stop(new CatalinaContext((Context)source));
            } else if (source instanceof Server) {
                this.init = false;
                Server server = (Server)source;
                this.removeListeners(server);
                this.eventHandler.stop(new CatalinaServer(server));
                this.eventHandler.shutdown();
            }
        } else if (type.equals("periodic") && this.init && source instanceof Engine) {
            this.eventHandler.status(new CatalinaEngine((Engine)source));
        }
    }

    private void addListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            ((Lifecycle)engine).addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).addLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    private void removeListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            ((Lifecycle)engine).removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).removeLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }
}

