/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.apache.catalina.Globals;
import org.jboss.modcluster.Connector;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPRequestType;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMCMPRequestFactory
implements MCMPRequestFactory {
    private final MCMPRequest infoRequest = new DefaultMCMPRequest(MCMPRequestType.INFO, false, null, Collections.<String, String>emptyMap());
    private final MCMPRequest dumpRequest = new DefaultMCMPRequest(MCMPRequestType.DUMP, true, null, Collections.<String, String>emptyMap());

    @Override
    public MCMPRequest createConfigRequest(Engine engine, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig) {
        int maxAttempts;
        int workerTimeout;
        String balancer;
        int nodeTimeout;
        int ttl;
        int smax;
        int ping;
        int flushWait;
        Connector connector = engine.getProxyConnector();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        if (connector.isReverse()) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", connector.getAddress().getHostAddress());
        parameters.put("Port", String.valueOf(connector.getPort()));
        parameters.put("Type", connector.getType().toString());
        String domain = nodeConfig.getDomain();
        if (domain != null) {
            parameters.put("Domain", domain);
        }
        if (nodeConfig.getFlushPackets()) {
            parameters.put("flushpackets", "On");
        }
        if ((flushWait = nodeConfig.getFlushWait()) != -1) {
            parameters.put("flushwait", String.valueOf(flushWait));
        }
        if ((ping = nodeConfig.getPing()) != -1) {
            parameters.put("ping", String.valueOf(ping));
        }
        if ((smax = nodeConfig.getSmax()) != -1) {
            parameters.put("smax", String.valueOf(smax));
        }
        if ((ttl = nodeConfig.getTtl()) != -1) {
            parameters.put("ttl", String.valueOf(ttl));
        }
        if ((nodeTimeout = nodeConfig.getNodeTimeout()) != -1) {
            parameters.put("Timeout", String.valueOf(nodeTimeout));
        }
        if ((balancer = nodeConfig.getBalancer()) != null) {
            parameters.put("Balancer", balancer);
        }
        if (!balancerConfig.getStickySession()) {
            parameters.put("StickySession", "No");
        }
        if (!Globals.SESSION_COOKIE_NAME.equals("JSESSIONID")) {
            parameters.put("StickySessionCookie", Globals.SESSION_COOKIE_NAME);
        }
        if (!Globals.SESSION_PARAMETER_NAME.equals("jsessionid")) {
            parameters.put("StickySessionPath", Globals.SESSION_PARAMETER_NAME);
        }
        if (balancerConfig.getStickySessionRemove()) {
            parameters.put("StickySessionRemove", "Yes");
        }
        if (!balancerConfig.getStickySessionForce()) {
            parameters.put("StickySessionForce", "No");
        }
        if ((workerTimeout = balancerConfig.getWorkerTimeout()) != -1) {
            parameters.put("WaitWorker", "" + workerTimeout);
        }
        if ((maxAttempts = balancerConfig.getMaxAttempts()) != -1) {
            parameters.put("Maxattempts", "" + maxAttempts);
        }
        return new DefaultMCMPRequest(MCMPRequestType.CONFIG, false, engine.getJvmRoute(), parameters);
    }

    @Override
    public MCMPRequest createDisableRequest(Context context) {
        return this.createRequest(MCMPRequestType.DISABLE_APP, context);
    }

    @Override
    public MCMPRequest createDisableRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.DISABLE_APP, engine);
    }

    @Override
    public MCMPRequest createEnableRequest(Context context) {
        return this.createRequest(MCMPRequestType.ENABLE_APP, context);
    }

    @Override
    public MCMPRequest createEnableRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.ENABLE_APP, engine);
    }

    @Override
    public MCMPRequest createRemoveRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.REMOVE_APP, engine);
    }

    @Override
    public MCMPRequest createRemoveRequest(Context context) {
        return this.createRequest(MCMPRequestType.REMOVE_APP, context);
    }

    @Override
    public MCMPRequest createStatusRequest(String jvmRoute, int lbf) {
        return new DefaultMCMPRequest(MCMPRequestType.STATUS, false, jvmRoute, Collections.singletonMap("Load", String.valueOf(lbf)));
    }

    @Override
    public MCMPRequest createStopRequest(Engine engine) {
        return this.createRequest(MCMPRequestType.STOP_APP, engine);
    }

    @Override
    public MCMPRequest createStopRequest(Context context) {
        return this.createRequest(MCMPRequestType.STOP_APP, context);
    }

    @Override
    public MCMPRequest createDumpRequest() {
        return this.dumpRequest;
    }

    @Override
    public MCMPRequest createInfoRequest() {
        return this.infoRequest;
    }

    @Override
    public MCMPRequest createPingRequest() {
        return this.createPingRequest((String)null);
    }

    @Override
    public MCMPRequest createPingRequest(String jvmRoute) {
        return new DefaultMCMPRequest(MCMPRequestType.PING, false, jvmRoute, Collections.<String, String>emptyMap());
    }

    @Override
    public MCMPRequest createPingRequest(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        if (port < 0) {
            port = Connector.Type.valueOf(scheme.toUpperCase()).getDefaultPort();
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Scheme", scheme);
        parameters.put("Host", host);
        parameters.put("Port", String.valueOf(port));
        return new DefaultMCMPRequest(MCMPRequestType.PING, false, null, parameters);
    }

    private MCMPRequest createRequest(MCMPRequestType type, Context context) {
        Host host = context.getHost();
        return this.createContextRequest(type, host.getEngine().getJvmRoute(), host.getAliases(), context.getPath());
    }

    @Override
    public MCMPRequest createRemoveContextRequest(String jvmRoute, Set<String> aliases, String path) {
        return this.createContextRequest(MCMPRequestType.REMOVE_APP, jvmRoute, aliases, path);
    }

    private MCMPRequest createContextRequest(MCMPRequestType type, String jvmRoute, Set<String> aliases, String path) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("Context", path.length() == 0 ? "/" : path);
        parameters.put("Alias", DefaultMCMPRequestFactory.join(aliases, ','));
        return new DefaultMCMPRequest(type, false, jvmRoute, parameters);
    }

    private MCMPRequest createRequest(MCMPRequestType type, Engine engine) {
        return this.createEngineRequest(type, engine.getJvmRoute());
    }

    private MCMPRequest createEngineRequest(MCMPRequestType type, String jvmRoute) {
        return new DefaultMCMPRequest(type, true, jvmRoute, Collections.<String, String>emptyMap());
    }

    @Override
    public MCMPRequest createRemoveEngineRequest(String jvmRoute) {
        return this.createEngineRequest(MCMPRequestType.REMOVE_APP, jvmRoute);
    }

    private static String join(Iterable<String> collection, char delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> values = collection.iterator();
        if (values.hasNext()) {
            builder.append(values.next());
        }
        while (values.hasNext()) {
            builder.append(delimiter).append(values.next());
        }
        return builder.toString();
    }
}

