/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.scanner;

import java.net.URL;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.VFSResourceVisitor;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.mcann.repository.DefaultAnnotationRepository;
import org.jboss.mcann.repository.GenericAnnotationResourceVisitor;
import org.jboss.mcann.repository.MutableAnnotationRepository;
import org.jboss.mcann.repository.TypeInfoProvider;
import org.jboss.mcann.scanner.AbstractAnnotationScanner;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationScanner
extends AbstractAnnotationScanner<MutableAnnotationRepository> {
    private TypeInfoProvider typeInfoProvider;
    protected VirtualFile[] excludedRoots;
    protected ClassFilter included;
    protected ClassFilter excluded;
    protected ResourceFilter recurseFilter;

    @Override
    protected MutableAnnotationRepository createAnnotationRepository(ClassLoader classLoader) {
        return new DefaultAnnotationRepository(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rescan(MutableAnnotationRepository repo, URL[] urls, ClassLoader classLoader) throws Exception {
        this.typeInfoProvider = this.getConfiguration().createTypeInfoProvider();
        if (this.typeInfoProvider == null) {
            throw new IllegalArgumentException("Null type info provider");
        }
        ResourceVisitor visitor = this.createResourceVisitor(repo);
        ResourceFilter filter = this.getConfiguration().resourceFilter();
        if (filter == null) {
            filter = visitor.getFilter();
        }
        this.beforeVisit(classLoader);
        try {
            this.visit(classLoader, urls, visitor, filter);
        }
        finally {
            this.afterVisit(classLoader);
        }
    }

    protected void beforeVisit(ClassLoader classLoader) {
        this.typeInfoProvider.beforeVisit(classLoader);
    }

    protected void afterVisit(ClassLoader classLoader) {
        this.typeInfoProvider.afterVisit(classLoader);
    }

    protected void visit(ClassLoader classLoader, URL[] urls, ResourceVisitor visitor, ResourceFilter filter) throws Exception {
        VirtualFile[] roots = new VirtualFile[urls.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = VFS.getRoot((URL)urls[i]);
        }
        VFSResourceVisitor.visit((VirtualFile[])roots, (VirtualFile[])this.excludedRoots, (ClassFilter)this.included, (ClassFilter)this.excluded, (ClassLoader)classLoader, (ResourceVisitor)visitor, (ResourceFilter)filter, (ResourceFilter)this.recurseFilter, (URL[])urls);
    }

    protected ResourceVisitor createResourceVisitor(MutableAnnotationRepository repository) {
        return new GenericAnnotationResourceVisitor(repository, this.getConfiguration(), this.typeInfoProvider);
    }

    public void setExcludedRoots(VirtualFile[] excludedRoots) {
        this.excludedRoots = excludedRoots;
    }

    public void setIncluded(ClassFilter included) {
        this.included = included;
    }

    public void setExcluded(ClassFilter excluded) {
        this.excluded = excluded;
    }

    public void setRecurseFilter(ResourceFilter recurseFilter) {
        this.recurseFilter = recurseFilter;
    }
}

