/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.net.URL;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.helpers.DeploymentResourceClassLoader;
import org.jboss.deployers.vfs.plugins.structure.VFSDeploymentResourceLoaderImpl;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.repository.Configuration;
import org.jboss.mcann.scanner.DefaultAnnotationScanner;
import org.jboss.virtual.VirtualFile;

public abstract class AbstractVFSStructureDeployer
extends AbstractStructureDeployer {
    private ClassFilter included;
    private ClassFilter excluded;
    private ResourceFilter recurseFilter;
    private Configuration configuration;

    protected AnnotationRepository createAnnotationRepository(VirtualFile root) {
        VFSDeploymentResourceLoaderImpl loader = new VFSDeploymentResourceLoaderImpl(root);
        DeploymentResourceClassLoader classLoader = new DeploymentResourceClassLoader((DeploymentResourceLoader)loader);
        DefaultAnnotationScanner scanner = new DefaultAnnotationScanner();
        scanner.setIncluded(this.included);
        scanner.setExcluded(this.excluded);
        scanner.setRecurseFilter(this.recurseFilter);
        if (this.configuration != null) {
            scanner.setConfiguration(this.configuration);
        }
        try {
            return scanner.scan((ClassLoader)classLoader, new URL[]{root.toURL()});
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create annotation repository: " + e);
        }
    }

    public void setIncluded(ClassFilter included) {
        this.included = included;
    }

    public void setExcluded(ClassFilter excluded) {
        this.excluded = excluded;
    }

    public void setRecurseFilter(ResourceFilter recurseFilter) {
        this.recurseFilter = recurseFilter;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

