/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.security.Base64Encoder;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.client.ssl.SSLContextFactory;
import org.jboss.ws.core.client.transport.NettyHelper;
import org.jboss.ws.core.client.transport.NettyTransportHandler;
import org.jboss.ws.core.client.transport.NettyTransportOutputStream;
import org.jboss.ws.core.client.transport.WSResponseHandler;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.metadata.config.CommonConfig;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class NettyClient {
    public static final String RESPONSE_CODE = "org.jboss.ws.core.client.transport.NettyClient#ResponseCode";
    public static final String RESPONSE_CODE_MESSAGE = "org.jboss.ws.core.client.transport.NettyClient#ResponseCodeMessage";
    public static final String PROTOCOL = "org.jboss.ws.core.client.transport.NettyClient#Protocol";
    public static final String RESPONSE_HEADERS = "org.jboss.ws.core.client.transport.NettyClient#ResponseHeaders";
    private static Logger log = Logger.getLogger(NettyClient.class);
    private Marshaller marshaller;
    private UnMarshaller unmarshaller;
    private Long timeout;
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private Integer chunkSize = new Integer(1024);
    private static final Pattern headerCleanerPattern = Pattern.compile("[\r\n\f]");

    public NettyClient(Marshaller marshaller, UnMarshaller unmarshaller) {
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public Object invoke(Object reqMessage, String targetAddress, boolean oneway, Map<String, Object> additionalHeaders, Map<String, Object> callProps) throws IOException {
        try {
            return this.invokeInternal(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
        }
        catch (ClosedChannelException cce) {
            if (NettyTransportHandler.getHttpKeepAliveSet()) {
                log.info((Object)"Retrying with a new connection...");
                return this.invokeInternal(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
            }
            throw cce;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeInternal(Object reqMessage, String targetAddress, boolean oneway, Map<String, Object> additionalHeaders, Map<String, Object> callProps) throws IOException {
        Object object;
        Map<String, Object> resMetadata;
        HashMap<String, Object> resHeaders;
        NettyTransportHandler transport;
        block17: {
            URL target;
            try {
                target = new URL(targetAddress);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid address: " + targetAddress, e);
            }
            transport = NettyTransportHandler.getInstance(target, NettyHelper.getChannelPipelineFactory(NettyClient.getSSLHandler(target, callProps)));
            Channel channel = null;
            resHeaders = null;
            resMetadata = null;
            try {
                this.setActualTimeout(callProps);
                channel = transport.getChannel(this.timeout);
                WSResponseHandler responseHandler = new WSResponseHandler();
                NettyHelper.setResponseHandler(channel, responseHandler);
                DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, reqMessage != null ? HttpMethod.POST : HttpMethod.GET, targetAddress);
                request.addHeader("Host", target.getHost());
                request.addHeader("Connection", "keep-alive");
                this.setAdditionalHeaders((HttpMessage)request, additionalHeaders);
                this.setActualChunkedLength((HttpRequest)request, callProps);
                this.setAuthorization((HttpMessage)request, callProps);
                ChannelFuture writeFuture = null;
                writeFuture = this.writeRequest(channel, (HttpRequest)request, reqMessage);
                if (writeFuture != null) {
                    writeFuture.awaitUninterruptibly();
                }
                Future<WSResponseHandler.Result> futureResult = responseHandler.getFutureResult();
                WSResponseHandler.Result result = null;
                try {
                    result = this.timeout == null ? futureResult.get() : futureResult.get(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ee) {
                    Throwable throwable;
                    Throwable t = ee.getCause();
                    if (t != null) {
                        throwable = t;
                        throw throwable;
                    }
                    throwable = ee;
                    throw throwable;
                }
                resHeaders = result.getResponseHeaders();
                resMetadata = result.getMetadata();
                Object resMessage = oneway ? null : this.unmarshaller.read(result.getResponse(), resMetadata, resHeaders);
                callProps.clear();
                callProps.put(RESPONSE_HEADERS, resHeaders != null ? resHeaders : new HashMap<String, Object>());
                if (resMetadata != null) {
                    callProps.putAll(resMetadata);
                }
                object = resMessage;
                if (channel == null) break block17;
            }
            catch (ClosedChannelException cce) {
                try {
                    log.error((Object)"Channel closed by remote peer while sending message");
                    transport.end();
                    throw cce;
                    catch (ConnectException ce) {
                        transport.end();
                        throw ce;
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (TimeoutException te) {
                        throw new WSTimeoutException(te.getMessage(), this.timeout);
                    }
                    catch (WSTimeoutException toe) {
                        throw toe;
                    }
                    catch (Throwable t) {
                        IOException io = new IOException("Could not transmit message");
                        io.initCause(t);
                        transport.end();
                        throw io;
                    }
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        NettyHelper.clearResponseHandler(channel);
                    }
                    transport.finished(resMetadata, resHeaders);
                    throw throwable;
                }
            }
            NettyHelper.clearResponseHandler(channel);
        }
        transport.finished(resMetadata, resHeaders);
        return object;
    }

    private static SslHandler getSSLHandler(URL target, Map<String, Object> callProps) throws IOException {
        SslHandler handler = null;
        if ("https".equalsIgnoreCase(target.getProtocol())) {
            SSLContextFactory sslContextFactory = new SSLContextFactory(callProps);
            SSLEngine engine = sslContextFactory.getSSLContext().createSSLEngine();
            engine.setUseClientMode(true);
            handler = new SslHandler(engine);
        }
        return handler;
    }

    private ChannelFuture writeRequest(Channel channel, HttpRequest request, Object reqMessage) throws IOException {
        if (reqMessage == null) {
            return channel.write((Object)request);
        }
        int cs = this.chunkSize;
        if (cs > 0) {
            request.addHeader("Transfer-Encoding", "chunked");
            channel.write((Object)request);
            NettyTransportOutputStream os = new NettyTransportOutputStream(channel, cs);
            this.marshaller.write(reqMessage, os);
            os.flush();
            os.close();
            return os.getChannelFuture();
        }
        ChannelBuffer content = ChannelBuffers.dynamicBuffer();
        ChannelBufferOutputStream os = new ChannelBufferOutputStream(content);
        this.marshaller.write(reqMessage, (OutputStream)os);
        os.flush();
        request.setHeader("Content-Length", String.valueOf(content.readableBytes()));
        request.setContent(content);
        return channel.write((Object)request);
    }

    protected void setActualChunkedLength(HttpRequest message, Map<String, Object> callProps) {
        CommonMessageContext msgContext;
        if (HttpMethod.POST.equals((Object)message.getMethod()) && (msgContext = MessageContextAssociation.peekMessageContext()) != null) {
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            CommonConfig config = epMetaData.getConfig();
            String sizeValue = config.getProperty("http://org.jboss.ws/http#chunksize");
            if (sizeValue != null) {
                this.chunkSize = Integer.valueOf(sizeValue);
            }
            try {
                Object obj = callProps.get("http://org.jboss.ws/http#chunksize");
                if (obj != null) {
                    this.chunkSize = (Integer)obj;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Can't set chunk size from call properties, illegal value provided!");
            }
            if (epMetaData.isFeatureEnabled(FastInfosetFeature.class)) {
                this.chunkSize = 0;
            }
        }
    }

    protected void setActualTimeout(Map<String, Object> callProps) {
        if (callProps.containsKey("org.jboss.ws.timeout")) {
            this.timeout = new Long(callProps.get("org.jboss.ws.timeout").toString());
        }
    }

    protected void setAuthorization(HttpMessage message, Map<String, Object> callProps) throws IOException {
        String authType = (String)callProps.get("org.jboss.ws.authType");
        if (authType == null) {
            authType = "org.jboss.ws.authType.basic";
        }
        String username = (String)callProps.get("javax.xml.rpc.security.auth.username");
        String password = (String)callProps.get("javax.xml.rpc.security.auth.password");
        if (username == null || password == null) {
            username = (String)callProps.get("javax.xml.ws.security.auth.username");
            password = (String)callProps.get("javax.xml.ws.security.auth.password");
        }
        if (username != null && password != null && authType.equals("org.jboss.ws.authType.basic")) {
            message.addHeader("Authorization", NettyClient.getBasicAuthHeader(username, password));
        }
    }

    private static String getBasicAuthHeader(String username, String password) throws IOException {
        return "Basic " + Base64Encoder.encode((String)(username + ":" + password));
    }

    protected void setAdditionalHeaders(HttpMessage message, Map<String, Object> headers) {
        for (String key : headers.keySet()) {
            String header = (String)headers.get(key);
            message.addHeader(key, headerCleanerPattern.matcher(header).replaceAll(" "));
        }
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }
}

