/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomicArray<T, V> {
    private final AtomicReferenceFieldUpdater<T, V[]> updater;
    private final V[] emptyArray;
    private final Creator<V> creator;

    private AtomicArray(AtomicReferenceFieldUpdater<T, V[]> updater, Creator<V> creator) {
        this.updater = updater;
        this.creator = creator;
        this.emptyArray = creator.create(0);
    }

    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, Class<V> componentType) {
        return new AtomicArray<T, V>(updater, new ReflectCreator<V>(componentType));
    }

    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, Creator<V> creator) {
        return new AtomicArray<T, V>(updater, creator);
    }

    public void clear(T instance) {
        this.updater.set(instance, (V[][])this.emptyArray);
    }

    public void set(T instance, V[] value) {
        this.updater.set(instance, (V[][])value);
    }

    public V[] getAndSet(T instance, V[] value) {
        return this.updater.getAndSet(instance, (V[][])value);
    }

    private static <V> V[] copyOf(Creator<V> creator, V[] old, int newLen) {
        V[] target = creator.create(newLen);
        System.arraycopy(old, 0, target, 0, Math.min(old.length, newLen));
        return target;
    }

    public void add(T instance, V value) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            newVal = AtomicArray.copyOf(this.creator, oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    return false;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    return false;
                }
            }
            newVal = AtomicArray.copyOf(this.creator, oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int index = -1;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    index = i;
                    break;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                return false;
            }
            newVal = this.creator.create(oldLen - 1);
            System.arraycopy(oldVal, 0, newVal, 0, index);
            System.arraycopy(oldVal, index + 1, newVal, index, oldLen - index - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public int removeAll(T instance, V value, boolean identity) {
        int removeCount;
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return 0;
            }
            boolean[] removeSlots = new boolean[oldLen];
            removeCount = 0;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            }
            if (removeCount == 0) {
                return 0;
            }
            int newLen = oldLen - removeCount;
            if (newLen == 0) {
                newVal = this.emptyArray;
                continue;
            }
            newVal = this.creator.create(newLen);
            int j = 0;
            for (int i2 = 0; i2 < oldLen; ++i2) {
                if (removeSlots[i2]) continue;
                newVal[j++] = oldVal[i2];
            }
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return removeCount;
    }

    public void add(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = AtomicArray.insertionPoint(Arrays.binarySearch(oldVal, value, comparator));
            newVal = this.creator.create(oldLen + 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = this.creator.create(oldLen + 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = this.creator.create(oldLen - 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            System.arraycopy(oldVal, pos + 1, newVal, pos, oldLen - pos - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public void sort(T instance, Comparator<? super V> comparator) {
        Object[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, Object[][]> updater = this.updater;
        do {
            if ((oldVal = updater.get(instance)).length == 0) {
                return;
            }
            newVal = (Object[])oldVal.clone();
            Arrays.sort(newVal, comparator);
        } while (!updater.compareAndSet(instance, (Object[][])oldVal, (Object[][])newVal));
    }

    private static int insertionPoint(int searchResult) {
        return searchResult > 0 ? searchResult : -(searchResult + 1);
    }

    private static <V> V[] newInstance(Class<V> componentType, int length) {
        if (componentType == Object.class) {
            return new Object[length];
        }
        return (Object[])Array.newInstance(componentType, length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReflectCreator<V>
    implements Creator<V> {
        private final Class<V> type;

        public ReflectCreator(Class<V> type) {
            this.type = type;
        }

        @Override
        public V[] create(int len) {
            return AtomicArray.newInstance(this.type, len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Creator<V> {
        public V[] create(int var1);
    }
}

