/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.aop.BeanContainerBeanContextFactory;
import org.jboss.ejb3.aop.ExtendedManagedObjectAdvisor;
import org.jboss.ejb3.aop.annotation.CachingAnnotationRepository;
import org.jboss.ejb3.cluster.metadata.ClusteredMetaDataBridge;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.direct.AbstractDirectContainer;
import org.jboss.ejb3.interceptors.metadata.AdditiveBeanInterceptorMetaDataBridge;
import org.jboss.ejb3.interceptors.metadata.InterceptorComponentMetaDataLoaderFactory;
import org.jboss.ejb3.interceptors.metadata.InterceptorMetaDataBridge;
import org.jboss.ejb3.metadata.ComponentMetaDataLoaderFactory;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.ejb3.metadata.annotation.AnnotationRepositoryToMetaData;
import org.jboss.ejb3.security.bridge.RunAsMetaDataBridge;
import org.jboss.ejb3.security.bridge.SecurityDomainMetaDataBridge;
import org.jboss.ejb3.tx.metadata.ApplicationExceptionComponentMetaDataLoaderFactory;
import org.jboss.ejb3.tx.metadata.ApplicationExceptionMetaDataBridge;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainer
extends AbstractDirectContainer<Object, BeanContainer> {
    private EJBContainer container;

    public BeanContainer(EJBContainer container) {
        assert (container != null) : "container is null";
        this.container = container;
        this.setBeanContextFactoryClass(BeanContainerBeanContextFactory.class);
    }

    public List<Class<?>> getInterceptorClasses() {
        return this.getInterceptorRegistry().getInterceptorClasses();
    }

    protected Object createInterceptor(Class<?> interceptorClass) throws InstantiationException, IllegalAccessException {
        return this.container.createInterceptor(interceptorClass);
    }

    @Deprecated
    public Advisor _getAdvisor() {
        return super.getAdvisor();
    }

    @Deprecated
    public AnnotationRepository getAnnotationRepository() {
        return this.getAdvisor().getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)this.getAdvisor().resolveAnnotation(annotationClass));
    }

    public <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.getAdvisor().resolveAnnotation(annotationType));
        }
        return clazz.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.getAdvisor().resolveAnnotation(field, annotationType));
        }
        return field.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        if (clazz == this.getBeanClass()) {
            return (T)((Annotation)this.getAdvisor().resolveAnnotation(method, annotationType));
        }
        return method.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return (T)((Annotation)this.getAdvisor().resolveAnnotation(field, annotationType));
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        Annotation annotation = (Annotation)this.getAdvisor().resolveAnnotation(method, annotationType);
        if (annotation == null && method.isBridge()) {
            annotation = this.getBridgedAnnotation(annotationType, method);
        }
        return (T)annotation;
    }

    private <T extends Annotation> T getBridgedAnnotation(Class<T> annotationType, Method bridgeMethod) {
        assert (bridgeMethod.isBridge());
        Method[] methods = bridgeMethod.getDeclaringClass().getMethods();
        boolean found = false;
        Class<?>[] bridgeParams = bridgeMethod.getParameterTypes();
        for (int i = 0; i < methods.length && !found; ++i) {
            Class<?>[] params;
            if (methods[i].isBridge() || !methods[i].getName().equals(bridgeMethod.getName()) || (params = methods[i].getParameterTypes()).length != bridgeParams.length) continue;
            boolean matches = true;
            for (int j = 0; j < params.length && matches; ++j) {
                if (bridgeParams[j].isAssignableFrom(params[j])) continue;
                matches = false;
            }
            if (!matches) continue;
            return this.getAnnotation(annotationType, methods[i]);
        }
        return null;
    }

    public final EJBContainer getEJBContainer() {
        return this.container;
    }

    protected List<Method> getVirtualMethods() {
        return this.container.getVirtualMethods();
    }

    public void initialize(String name, Domain domain, Class<? extends Object> beanClass, JBossEnterpriseBeanMetaData beanMetaData, ClassLoader classLoader) {
        AnnotationRepositoryToMetaData annotations = new AnnotationRepositoryToMetaData(beanClass, beanMetaData, name, classLoader);
        ArrayList<InterceptorMetaDataBridge> interceptorBridges = new ArrayList<InterceptorMetaDataBridge>();
        interceptorBridges.add(new InterceptorMetaDataBridge());
        annotations.addComponentMetaDataLoaderFactory((ComponentMetaDataLoaderFactory)new InterceptorComponentMetaDataLoaderFactory(interceptorBridges));
        annotations.addMetaDataBridge((MetaDataBridge)new AdditiveBeanInterceptorMetaDataBridge(beanClass, classLoader, beanMetaData));
        ArrayList<ApplicationExceptionMetaDataBridge> appExceptionBridges = new ArrayList<ApplicationExceptionMetaDataBridge>();
        appExceptionBridges.add(new ApplicationExceptionMetaDataBridge());
        annotations.addComponentMetaDataLoaderFactory((ComponentMetaDataLoaderFactory)new ApplicationExceptionComponentMetaDataLoaderFactory(appExceptionBridges));
        annotations.addMetaDataBridge((MetaDataBridge)new RunAsMetaDataBridge());
        annotations.addMetaDataBridge((MetaDataBridge)new SecurityDomainMetaDataBridge());
        annotations.addMetaDataBridge((MetaDataBridge)new ClusteredMetaDataBridge());
        this.initializeAdvisor(name, domain, beanClass, new CachingAnnotationRepository(annotations, classLoader));
    }

    protected ManagedObjectAdvisor<Object, BeanContainer> createAdvisor(String name, Domain domain, Class<? extends Object> beanClass, AnnotationRepository annotations) {
        return new ExtendedManagedObjectAdvisor(this, name, (AspectManager)domain, annotations);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAdvisor().resolveAnnotation(annotationType) != null;
    }

    @Deprecated
    public void reinitializeAdvisor() {
        try {
            ((ExtendedManagedObjectAdvisor)this.getAdvisor()).reinitialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

