/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.ondemand;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicSubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.web.tomcat.service.ondemand.ContextDemandListener;
import org.jboss.web.tomcat.service.ondemand.OnDemandContextIntegrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDemandContextProfileManager {
    public static final String DEFAULT_SERVICE_NAME = "jboss.web";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ROOT_WAR_PROFILE_NAME = "ROOT.war";
    private ProfileService profileService;
    private ProfileFactory profileFactory;
    private OnDemandContextIntegrator contextIntegrator;
    private List<URI> uriList = new CopyOnWriteArrayList<URI>();
    protected final Logger log = Logger.getLogger(this.getClass());
    private boolean activated;
    private String profileDomain;
    private String profileServer;
    private String profileName;
    private ProfileKey profileKey;
    private String serviceName = "jboss.web";
    private String hostName = "localhost";
    private String contextName;
    private String contextPath;
    private boolean activateOnDemand = true;
    private final ContextDemandListener contextDemandListener = new Listener();

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            throw new IllegalArgumentException("list argument cannot be null");
        }
        this.uriList.clear();
        for (URI uri : list) {
            if (uri == null || !this.uriList.add(uri)) continue;
            this.log.debug((Object)("Added URI: " + uri));
        }
        this.log.debug((Object)("URI list: " + this.uriList));
    }

    public URI getSingleURI() {
        List<URI> list = this.getURIList();
        return list.size() == 1 ? list.get(0) : null;
    }

    public void setSingleURI(URI deploymentURI) throws IOException {
        if (deploymentURI == null) {
            throw new IllegalArgumentException("deploymentURI argument cannot be null");
        }
        List<URI> list = Arrays.asList(deploymentURI);
        this.setURIList(list);
    }

    public String getProfileDomain() {
        return this.profileDomain;
    }

    public void setProfileDomain(String profileDomain) {
        this.profileDomain = profileDomain;
    }

    public String getProfileServer() {
        return this.profileServer;
    }

    public void setProfileServer(String profileServer) {
        this.profileServer = profileServer;
    }

    public String getProfileName() {
        if (this.profileName == null && this.contextName != null) {
            this.profileName = "".equals(this.contextName) ? DEFAULT_ROOT_WAR_PROFILE_NAME : this.contextName + ".war";
        }
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName is null");
        }
        this.hostName = hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("contextName is null");
        }
        if ("ROOT".equals(contextName) || "/ROOT".equals(contextName)) {
            contextName = "";
        }
        this.contextName = contextName;
    }

    public void setProfileService(ProfileService profileService) {
        if (profileService == null) {
            throw new IllegalArgumentException("profileService is null");
        }
        this.profileService = profileService;
    }

    public void setProfileFactory(ProfileFactory profileFactory) {
        if (profileFactory == null) {
            throw new IllegalArgumentException("profileFactory is null");
        }
        this.profileFactory = profileFactory;
    }

    public void setOnDemandContextIntegrator(OnDemandContextIntegrator contextManager) {
        if (contextManager == null) {
            throw new IllegalArgumentException("contextManager is null");
        }
        this.contextIntegrator = contextManager;
    }

    public boolean isActivateOnDemand() {
        return this.activateOnDemand;
    }

    public void setActivateOnDemand(boolean activateOnDemand) {
        this.activateOnDemand = activateOnDemand;
    }

    public void start() throws Exception {
        if (this.profileFactory == null) {
            throw new IllegalStateException("Must configure ProfileFactory");
        }
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure ProfileService");
        }
        if (this.contextIntegrator == null) {
            throw new IllegalStateException("Must configure OnDemandContextManager");
        }
        if (this.serviceName == null) {
            throw new IllegalStateException("Must configure serviceName");
        }
        if (this.hostName == null) {
            throw new IllegalStateException("Must configure hostName");
        }
        if (this.contextName == null) {
            throw new IllegalStateException("Must configure contextName");
        }
        if (this.uriList.size() == 0) {
            throw new IllegalStateException("Must configure URIList");
        }
        URI[] rootURIs = this.uriList.toArray(new URI[this.uriList.size()]);
        String[] rootSubProfiles = new String[]{};
        ProfileMetaData metadata = this.createProfileMetaData(false, rootURIs, rootSubProfiles);
        Profile profile = this.profileFactory.createProfile(this.getProfileKey(), metadata);
        this.profileService.registerProfile(profile);
        if (this.activateOnDemand) {
            this.contextIntegrator.registerContextDemandListener(this.contextDemandListener);
            this.contextPath = this.contextName.length() == 0 || '/' == this.contextName.charAt(0) ? this.contextName : "/" + this.contextName;
            this.contextIntegrator.registerOnDemandContext(this.serviceName, this.hostName, this.contextPath);
        } else {
            this.activateProfile(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        ProfileKey profKey = null;
        try {
            profKey = this.getProfileKey();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (this.profileService != null && profKey != null) {
            try {
                try {
                    if (this.profileService.getActiveProfileKeys().contains(profKey)) {
                        this.releaseProfile();
                    }
                    this.profileService.unregisterProfile(profKey);
                }
                catch (NoSuchProfileException e) {
                    this.log.warn((Object)("Could not unregister unknown profile " + profKey));
                    Object var4_5 = null;
                    if (this.contextIntegrator != null) {
                        this.contextIntegrator.removeContextDemandListener(this.contextDemandListener);
                    }
                }
                Object var4_4 = null;
                if (this.contextIntegrator != null) {
                    this.contextIntegrator.removeContextDemandListener(this.contextDemandListener);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.contextIntegrator != null) {
                    this.contextIntegrator.removeContextDemandListener(this.contextDemandListener);
                }
                throw throwable;
            }
        }
    }

    public void activateProfile() throws Exception {
        this.activateProfile(true);
    }

    public ProfileKey getProfileKey() {
        if (this.profileKey == null) {
            String name = this.getProfileName();
            if (name == null) {
                throw new IllegalStateException("Must configure profileName or contextName before calling getProfileKey()");
            }
            this.profileKey = new ProfileKey(this.getProfileDomain(), this.getProfileServer(), this.getProfileName());
        }
        return this.profileKey;
    }

    protected ProfileSourceMetaData createSource(URI[] uris, boolean hotDeployment) {
        Object source = null;
        source = hotDeployment ? new HotDeploymentProfileSourceMetaData() : new ImmutableProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }

    private ProfileMetaData createProfileMetaData(boolean hotDeployment, URI[] uris, String[] subProfiles) {
        BasicProfileMetaData metaData = new BasicProfileMetaData();
        metaData.setDomain(this.getProfileDomain());
        metaData.setServer(this.getProfileServer());
        metaData.setName(this.getProfileName());
        ProfileSourceMetaData source = this.createSource(uris, hotDeployment);
        metaData.setSource(source);
        ArrayList<BasicSubProfileMetaData> profileList = new ArrayList<BasicSubProfileMetaData>();
        for (String subProfile : subProfiles) {
            BasicSubProfileMetaData md = new BasicSubProfileMetaData();
            md.setName(subProfile);
            profileList.add(md);
        }
        metaData.setSubprofiles(profileList);
        return metaData;
    }

    private synchronized void activateProfile(boolean validate) throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure the ProfileService");
        }
        ProfileKey profKey = this.getProfileKey();
        if (!this.profileService.getActiveProfileKeys().contains(profKey)) {
            this.profileService.activateProfile(profKey);
            if (validate) {
                this.profileService.validateProfile(profKey);
            }
            this.activated = true;
        } else {
            this.log.warn((Object)("Profile " + profKey + " is already activated"));
            this.activated = true;
        }
    }

    private synchronized void releaseProfile() throws Exception {
        if (this.activated) {
            try {
                this.profileService.deactivateProfile(this.getProfileKey());
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("No Profile is registered under key " + this.getProfileKey()));
            }
            this.activated = false;
        }
    }

    private class Listener
    implements ContextDemandListener {
        private Listener() {
        }

        public void contextDemanded(String serviceName, String hostName, String contextName) {
            if (OnDemandContextProfileManager.this.contextPath.equals(contextName) && OnDemandContextProfileManager.this.hostName.equals(hostName) && OnDemandContextProfileManager.this.serviceName.equals(serviceName)) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            OnDemandContextProfileManager.this.activateProfile();
                        }
                        catch (Exception e) {
                            OnDemandContextProfileManager.this.log.error((Object)("Unable to activate profile " + OnDemandContextProfileManager.this.getProfileKey()), (Throwable)e);
                        }
                        return null;
                    }
                });
            }
        }
    }
}

