/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;

public class ClusteringDefaultsDeployer
extends AbstractDeployer {
    public static final int IGNORED = -1;
    private String cacheName;
    private String fieldGranularityCacheName;
    private SnapshotMode snapshotMode;
    private int snapshotInterval;
    private ReplicationGranularity replicationGranularity;
    private ReplicationTrigger replicationTrigger;
    private boolean replicationFieldBatchMode = true;
    private Boolean useJK;
    private int maxUnreplicatedInterval;
    private boolean useSessionPassivation;
    private int passivationMinIdleTime = -1;
    private int passivationMaxIdleTime = -1;
    private boolean useLocalCache = true;

    public ClusteringDefaultsDeployer() {
        this.setStage(DeploymentStages.POST_PARSE);
        this.setInput(JBossWebMetaData.class);
        this.setOutput(JBossWebMetaData.class);
    }

    public Boolean isUseJK() {
        return this.useJK;
    }

    public void setUseJK(Boolean useJK) {
        this.useJK = useJK;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getFieldGranularityCacheName() {
        return this.fieldGranularityCacheName;
    }

    public void setFieldGranularityCacheName(String fieldGranularityCacheName) {
        this.fieldGranularityCacheName = fieldGranularityCacheName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setSnapshotMode(SnapshotMode snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval = snapshotInterval;
    }

    public ReplicationGranularity getReplicationGranularity() {
        return this.replicationGranularity;
    }

    public void setReplicationGranularity(ReplicationGranularity granularity) {
        this.replicationGranularity = granularity;
    }

    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger;
    }

    public void setReplicationTrigger(ReplicationTrigger trigger) {
        this.replicationTrigger = trigger;
    }

    public boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode;
    }

    public void setReplicationFieldBatchMode(boolean fieldBatchMode) {
        this.replicationFieldBatchMode = fieldBatchMode;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public boolean isUseSessionPassivation() {
        return this.useSessionPassivation;
    }

    public void setUseSessionPassivation(boolean useSessionPassivation) {
        this.useSessionPassivation = useSessionPassivation;
    }

    public int getPassivationMinIdleTime() {
        return this.passivationMinIdleTime;
    }

    public void setPassivationMinIdleTime(int passivationMinIdleTime) {
        this.passivationMinIdleTime = passivationMinIdleTime;
    }

    public int getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime;
    }

    public void setPassivationMaxIdleTime(int passivationMaxIdleTime) {
        this.passivationMaxIdleTime = passivationMaxIdleTime;
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (metaData != null) {
            this.addReplicationConfigDefaults(metaData);
            this.addPassivationConfigDefaults(metaData);
        }
    }

    private void addPassivationConfigDefaults(JBossWebMetaData metaData) {
        PassivationConfig passCfg = metaData.getPassivationConfig();
        if (passCfg == null) {
            passCfg = new PassivationConfig();
            metaData.setPassivationConfig(passCfg);
        }
        if (passCfg.getUseSessionPassivation() == null) {
            passCfg.setUseSessionPassivation(Boolean.valueOf(this.useSessionPassivation));
        }
        if (passCfg.getPassivationMinIdleTime() == null) {
            passCfg.setPassivationMinIdleTime(new Integer(this.passivationMinIdleTime));
        }
        if (passCfg.getPassivationMinIdleTime() == null) {
            passCfg.setPassivationMaxIdleTime(new Integer(this.passivationMaxIdleTime));
        }
    }

    private void addReplicationConfigDefaults(JBossWebMetaData metaData) {
        ReplicationConfig repCfg = metaData.getReplicationConfig();
        if (repCfg == null) {
            repCfg = new ReplicationConfig();
            metaData.setReplicationConfig(repCfg);
        }
        if (repCfg.getUseJK() == null && this.useJK != null) {
            repCfg.setUseJK(this.useJK);
        }
        if (repCfg.getSnapshotMode() == null) {
            repCfg.setSnapshotMode(this.snapshotMode);
        }
        if (repCfg.getSnapshotInterval() == null) {
            repCfg.setSnapshotInterval(new Integer(this.snapshotInterval));
        }
        if (repCfg.getReplicationGranularity() == null) {
            repCfg.setReplicationGranularity(this.replicationGranularity);
        }
        if (repCfg.getReplicationTrigger() == null) {
            repCfg.setReplicationTrigger(this.replicationTrigger);
        }
        if (repCfg.getReplicationFieldBatchMode() == null) {
            repCfg.setReplicationFieldBatchMode(Boolean.valueOf(this.replicationFieldBatchMode));
        }
        if (repCfg.getCacheName() == null) {
            String cacheConfig = ReplicationGranularity.FIELD == repCfg.getReplicationGranularity() ? this.fieldGranularityCacheName : this.cacheName;
            repCfg.setCacheName(cacheConfig);
        }
        if (repCfg.getMaxUnreplicatedInterval() == null) {
            repCfg.setMaxUnreplicatedInterval(new Integer(this.maxUnreplicatedInterval));
        }
    }
}

