/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.DtdAwareContentHandler {
    private static final Logger log = Logger.getLogger(SundayContentHandler.class);
    private static final Object NIL = new Object();
    private final SchemaBinding schema;
    private final SchemaBindingResolver schemaResolver;
    private final StackImpl stack = new StackImpl();
    private Object root;
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private ParticleHandler defParticleHandler = DefaultHandlers.ELEMENT_HANDLER;
    private UnmarshallingContextImpl ctx = new UnmarshallingContextImpl();
    private String dtdRootName;
    private String dtdPublicId;
    private String dtdSystemId;
    private boolean sawDTD;
    private final boolean trace = log.isTraceEnabled();

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
    }

    public void startDTD(String dtdRootName, String dtdPublicId, String dtdSystemId) {
        this.dtdRootName = dtdRootName;
        this.dtdPublicId = dtdPublicId;
        this.dtdSystemId = dtdSystemId;
    }

    public void endDTD() {
        this.sawDTD = true;
    }

    public void characters(char[] ch, int start, int length) {
        int i;
        StackItem stackItem = this.stack.peek();
        if (stackItem.cursor != null) {
            return;
        }
        ElementBinding e = (ElementBinding)stackItem.particle.getTerm();
        if (stackItem.ended) {
            stackItem = this.stack.peek1();
            if (stackItem.cursor != null) {
                for (i = this.stack.size() - 3; i >= 0; --i) {
                    stackItem = this.stack.peek(i);
                    if (stackItem.cursor == null) break;
                }
            }
            e = (ElementBinding)stackItem.particle.getTerm();
        }
        if (e.getType().isTextContentAllowed()) {
            if (stackItem.indentation != Boolean.FALSE) {
                if (e.getType().isSimple()) {
                    stackItem.indentation = Boolean.FALSE;
                    stackItem.ignorableCharacters = false;
                } else if (e.getSchema() != null && !e.getSchema().isIgnoreWhitespacesInMixedContent()) {
                    stackItem.indentation = Boolean.FALSE;
                    stackItem.ignorableCharacters = false;
                } else {
                    for (i = start; i < start + length; ++i) {
                        if (ch[i] == '\n') {
                            stackItem.indentation = Boolean.TRUE;
                            continue;
                        }
                        if (Character.isWhitespace(ch[i])) continue;
                        stackItem.indentation = Boolean.FALSE;
                        stackItem.ignorableCharacters = false;
                        break;
                    }
                }
            }
            if (stackItem.textContent == null) {
                stackItem.textContent = new StringBuffer();
            }
            stackItem.textContent.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        StackItem item;
        ElementBinding elementBinding = null;
        QName endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        while (true) {
            item = this.stack.peek();
            if (item.cursor == null) {
                if (item.ended) {
                    this.pop();
                    if (!item.particle.isRepeatable()) continue;
                    StackItem parentItem = this.stack.peek();
                    if (parentItem.repeatableParticleValue == null) continue;
                    StackItem notSkippedParent = parentItem;
                    if (parentItem.particle.getTerm().isSkip()) {
                        notSkippedParent = this.stack.peek1();
                    }
                    int i = this.stack.size() - 2;
                    while (notSkippedParent.particle.getTerm().isSkip() && i >= 0) {
                        notSkippedParent = this.stack.peek(i--);
                    }
                    this.endRepeatableParticle(parentItem, item.qName, item.particle, notSkippedParent.particle);
                    continue;
                }
                break;
            }
            if (!item.ended) {
                this.endParticle(item, this.stack.peek1());
            }
            ParticleBinding currentParticle = item.cursor.getCurrentParticle();
            if (item.repeatableParticleValue != null && currentParticle.getTerm().isWildcard()) {
                this.endRepeatableParticle(item, item.qName, currentParticle, item.particle);
            }
            this.pop();
            if (!item.particle.isRepeatable()) continue;
            StackItem parentItem = this.stack.peek();
            if (parentItem.repeatableParticleValue == null) continue;
            this.endRepeatableParticle(parentItem, item.qName, item.particle, parentItem.particle);
        }
        elementBinding = (ElementBinding)item.particle.getTerm();
        item.ended = true;
        if (elementBinding == null) {
            throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
        }
        if (!elementBinding.getQName().equals(endName)) {
            throw new JBossXBRuntimeException("Failed to end element " + new QName(namespaceURI, localName) + ": element on the stack is " + elementBinding.getQName());
        }
        this.endElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition xercesType) {
        QName startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        ParticleBinding particle = null;
        ParticleHandler handler = null;
        TypeBinding parentType = null;
        boolean repeated = false;
        boolean repeatedParticle = false;
        StackItem item = null;
        ModelGroupBinding.Cursor cursor = null;
        SchemaBinding schemaBinding = this.schema;
        atts = this.preprocessAttributes(atts);
        if (this.stack.isEmpty()) {
            if (schemaBinding != null) {
                particle = schemaBinding.getElementParticle(startName);
            } else {
                String schemaLocation;
                if (this.schemaResolver == null) throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is available!");
                String string = schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                if (schemaLocation == null || schemaLocation.length() == 0) {
                    if (this.sawDTD) {
                        schemaLocation = this.dtdSystemId;
                    }
                    if (schemaLocation == null && (namespaceURI == null || namespaceURI.length() == 0)) {
                        schemaLocation = localName;
                    }
                }
                if ((schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation)) == null) throw new JBossXBRuntimeException("Failed to resolve schema nsURI=" + namespaceURI + " location=" + schemaLocation);
                particle = schemaBinding.getElementParticle(startName);
            }
        } else {
            while (!this.stack.isEmpty()) {
                ParticleBinding curParticle;
                item = this.stack.peek();
                if (item.cursor == null) {
                    ModelGroupBinding modelGroup;
                    TermBinding term = item.particle.getTerm();
                    ElementBinding element = (ElementBinding)term;
                    if (item.ended) {
                        StackItem parentItem;
                        if (element.getQName().equals(startName)) {
                            if (item.particle.isRepeatable()) {
                                parentItem = this.stack.peek1();
                                if (parentItem.cursor.repeatElement(startName)) {
                                    item.reset();
                                    particle = item.particle;
                                    parentType = item.parentType;
                                    repeated = true;
                                    break;
                                }
                                this.pop();
                                if (parentItem.repeatableParticleValue == null) continue;
                                this.endRepeatableParticle(parentItem, item.qName, item.particle, parentItem.particle);
                                continue;
                            }
                            item.reset();
                            particle = item.particle;
                            parentType = item.parentType;
                            repeated = true;
                            this.endRepeatableParent(startName);
                            break;
                        }
                        this.pop();
                        if (!item.particle.isRepeatable()) continue;
                        parentItem = this.stack.peek();
                        if (parentItem.repeatableParticleValue == null) continue;
                        this.endRepeatableParticle(parentItem, item.qName, item.particle, parentItem.particle);
                        continue;
                    }
                    parentType = element.getType();
                    ParticleBinding typeParticle = parentType.getParticle();
                    ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
                    if (modelGroup == null) {
                        if (startName.equals(Constants.QNAME_XOP_INCLUDE)) {
                            TypeBinding anyUriType = this.schema.getType(Constants.QNAME_ANYURI);
                            if (anyUriType == null) {
                                log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
                            }
                            TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
                            xopIncludeType.setSchemaBinding(this.schema);
                            xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
                            xopIncludeType.setHandler(new XOPIncludeHandler(parentType, this.schema.getXopUnmarshaller()));
                            ElementBinding xopInclude = new ElementBinding(this.schema, Constants.QNAME_XOP_INCLUDE, xopIncludeType);
                            particle = new ParticleBinding(xopInclude);
                            ElementBinding parentElement = (ElementBinding)item.particle.getTerm();
                            parentElement.setXopUnmarshaller(this.schema.getXopUnmarshaller());
                            this.flushIgnorableCharacters();
                            item.handler = DefaultHandlers.XOP_HANDLER;
                            item.ignoreCharacters = true;
                            item.o = item.handler.startParticle(this.stack.peek().o, startName, this.stack.peek().particle, null, this.nsRegistry);
                            break;
                        }
                        QName typeName = parentType.getQName();
                        throw new JBossXBRuntimeException((typeName == null ? "Anonymous" : typeName.toString()) + " type of element " + element.getQName() + " should be complex and contain " + startName + " as a child element.");
                    }
                    cursor = modelGroup.newCursor(typeParticle);
                    List<ModelGroupBinding.Cursor> newCursors = cursor.startElement(startName, atts);
                    if (newCursors.isEmpty()) {
                        throw new JBossXBRuntimeException(startName + " not found as a child of " + ((ElementBinding)term).getQName() + " in " + modelGroup);
                    }
                    this.flushIgnorableCharacters();
                    Object o = item.o;
                    for (int i = newCursors.size() - 1; i >= 0; --i) {
                        cursor = newCursors.get(i);
                        ParticleBinding modelGroupParticle = cursor.getParticle();
                        if (modelGroupParticle.isRepeatable()) {
                            this.startRepeatableParticle(this.stack.peek(), o, startName, modelGroupParticle);
                        }
                        handler = this.getHandler(modelGroupParticle);
                        o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
                        this.push(startName, cursor, o, handler, parentType);
                    }
                    particle = cursor.getCurrentParticle();
                    break;
                }
                cursor = item.cursor;
                if (cursor == null) {
                    throw new JBossXBRuntimeException("No cursor for " + startName);
                }
                ParticleBinding prevParticle = cursor.isPositioned() ? cursor.getCurrentParticle() : null;
                List<ModelGroupBinding.Cursor> newCursors = cursor.startElement(startName, atts);
                if (newCursors.isEmpty()) {
                    if (!item.ended) {
                        this.endParticle(item, this.stack.peek1());
                    }
                    StackItem poped = this.pop();
                    if (poped.particle.isRepeatable() || this.stack.peek().cursor != null) continue;
                    TermBinding t = cursor.getParticle().getTerm();
                    StringBuffer sb = new StringBuffer(250);
                    sb.append(startName).append(" cannot appear in this position. Expected content of ").append(((ElementBinding)this.stack.peek().particle.getTerm()).getQName()).append(" is ").append(t);
                    throw new JBossXBRuntimeException(sb.toString());
                }
                if (item.ended) {
                    if (!item.particle.isRepeatable()) {
                        throw new JBossXBRuntimeException("The particle expected to be repeatable but it's not: " + item.particle.getTerm());
                    }
                    item.reset();
                    handler = this.getHandler(item.particle);
                    item.o = handler.startParticle(this.stack.peek1().o, startName, item.particle, atts, this.nsRegistry);
                }
                if ((curParticle = cursor.getCurrentParticle()) != prevParticle) {
                    if (item.repeatableParticleValue != null && prevParticle != null && prevParticle.isRepeatable() && prevParticle.getTerm().isModelGroup()) {
                        this.endRepeatableParticle(item, item.qName, prevParticle, item.particle);
                    }
                    if (newCursors.size() > 1 && curParticle.isRepeatable()) {
                        this.startRepeatableParticle(this.stack.peek1(), this.stack.peek1().o, startName, curParticle);
                    }
                } else {
                    repeatedParticle = true;
                }
                parentType = item.parentType;
                Object o = item.o;
                for (int i = newCursors.size() - 2; i >= 0; --i) {
                    cursor = newCursors.get(i);
                    ParticleBinding modelGroupParticle = cursor.getParticle();
                    handler = this.getHandler(modelGroupParticle);
                    o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
                    this.push(startName, cursor, o, handler, parentType);
                }
                cursor = newCursors.get(0);
                particle = cursor.getCurrentParticle();
                break;
            }
        }
        Object o = null;
        if (particle != null) {
            String nil;
            TypeBinding type;
            ElementBinding element;
            Object parent;
            Object object = this.stack.isEmpty() ? null : (parent = repeated ? this.stack.peek1().o : this.stack.peek().o);
            if (particle.getTerm().isWildcard()) {
                element = cursor.getElement();
                if (element == null) {
                    throw new JBossXBRuntimeException("Failed to resolve element " + startName + " for wildcard.");
                }
                if (!repeatedParticle && particle.isRepeatable()) {
                    this.startRepeatableParticle(this.stack.peek(), parent, startName, particle);
                }
                particle = new ParticleBinding(element);
            }
            element = (ElementBinding)particle.getTerm();
            String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (xsiType != null) {
                String xsiTypeLocal;
                String xsiTypePrefix;
                int colon;
                if (this.trace) {
                    log.trace((Object)(element.getQName() + " uses xsi:type " + xsiType));
                }
                if (item != null && item.nonXsiParticle == null) {
                    item.nonXsiParticle = particle;
                }
                if ((colon = xsiType.indexOf(58)) == -1) {
                    xsiTypePrefix = "";
                    xsiTypeLocal = xsiType;
                } else {
                    xsiTypePrefix = xsiType.substring(0, colon);
                    xsiTypeLocal = xsiType.substring(colon + 1);
                }
                String xsiTypeNs = this.nsRegistry.getNamespaceURI(xsiTypePrefix);
                QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
                TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
                if (xsiTypeBinding == null) {
                    throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + startName);
                }
                ElementBinding xsiElement = new ElementBinding(schemaBinding, startName, xsiTypeBinding);
                xsiElement.setRepeatableHandler(element.getRepeatableHandler());
                particle = new ParticleBinding(xsiElement, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
            }
            if (!repeated && particle.isRepeatable()) {
                this.startRepeatableParticle(this.stack.peek(), parent, startName, particle);
            }
            if ((type = element.getType()) == null) {
                throw new JBossXBRuntimeException("No type for element " + element);
            }
            handler = type.getHandler();
            if (handler == null) {
                handler = this.defParticleHandler;
            }
            List<ElementInterceptor> localInterceptors = parentType == null ? Collections.EMPTY_LIST : parentType.getInterceptors(startName);
            List<ElementInterceptor> interceptors = element.getInterceptors();
            if (interceptors.size() + localInterceptors.size() > 0) {
                ElementInterceptor interceptor;
                int i;
                if (repeated) {
                    this.pop();
                }
                for (i = 0; i < localInterceptors.size(); ++i) {
                    interceptor = localInterceptors.get(i);
                    parent = interceptor.startElement(parent, startName, type);
                    this.push(startName, particle, parent, handler, parentType);
                    interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
                }
                for (i = 0; i < interceptors.size(); ++i) {
                    interceptor = interceptors.get(i);
                    parent = interceptor.startElement(parent, startName, type);
                    this.push(startName, particle, parent, handler, parentType);
                    interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
                }
                if (repeated) {
                    this.stack.push(item);
                }
            }
            o = (nil = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) == null || !"1".equals(nil) && !"true".equals(nil) ? handler.startParticle(parent, startName, particle, atts, this.nsRegistry) : NIL;
        } else {
            TermBinding parentBinding = null;
            if (!this.stack.isEmpty()) {
                ParticleBinding stackParticle;
                ParticleBinding particleBinding = stackParticle = repeated ? this.stack.peek1().particle : this.stack.peek().particle;
                if (stackParticle != null) {
                    parentBinding = (ElementBinding)stackParticle.getTerm();
                }
            }
            if (parentBinding != null && parentBinding.getSchema() != null) {
                schemaBinding = parentBinding.getSchema();
            }
            String msg = "Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + ((ElementBinding)parentBinding).getType().getQName());
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException(msg);
            }
            if (this.trace) {
                log.trace((Object)msg);
            }
        }
        if (repeated) {
            item.o = o;
            item.particle = particle;
            return;
        } else {
            this.push(startName, particle, o, handler, parentType);
        }
    }

    private ParticleHandler getHandler(ParticleBinding modelGroupParticle) {
        ParticleHandler handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
        return handler == null ? this.defParticleHandler : handler;
    }

    private void endRepeatableParent(QName startName) {
        ParticleHandler handler;
        StackItem item;
        int stackIndex = this.stack.size() - 2;
        StackItem parentItem = this.stack.peek1();
        ParticleBinding parentParticle = null;
        while (true) {
            if (parentItem.cursor == null) {
                throw new JBossXBRuntimeException("Failed to start " + startName + ": the element is not repeatable, repeatable parent expected to be a model group but got element " + ((ElementBinding)parentItem.particle.getTerm()).getQName());
            }
            item = parentItem;
            parentParticle = parentItem.particle;
            if (parentParticle.isRepeatable()) {
                parentItem = this.stack.peek(stackIndex - 1);
                this.endParticle(item, parentItem);
                handler = this.getHandler(item.particle);
                item.reset();
                item.o = handler.startParticle(parentItem.o, item.qName, item.particle, null, this.nsRegistry);
                break;
            }
            ParticleBinding currentParticle = parentItem.cursor.getCurrentParticle();
            if (currentParticle.getTerm().isWildcard() && currentParticle.isRepeatable()) break;
            parentItem = this.stack.peek(--stackIndex);
            this.endParticle(item, parentItem);
        }
        while (++stackIndex < this.stack.size() - 1) {
            parentItem = item;
            item = this.stack.peek(stackIndex);
            handler = this.getHandler(item.particle);
            item.reset();
            item.o = handler.startParticle(parentItem.o, item.qName, item.particle, null, this.nsRegistry);
        }
    }

    private void startRepeatableParticle(StackItem parentItem, Object parent, QName startName, ParticleBinding particle) {
        RepeatableParticleHandler repeatableHandler;
        Object repeatableContainer;
        if (this.trace) {
            log.trace((Object)(" start repeatable (" + this.stack.size() + "): " + particle.getTerm()));
        }
        if ((repeatableContainer = (repeatableHandler = particle.getTerm().getRepeatableHandler()).startRepeatableParticle(parent, startName, particle)) != null) {
            parentItem.repeatableParticleValue = repeatableContainer;
            parentItem.repeatableHandler = repeatableHandler;
        }
    }

    private void endRepeatableParticle(StackItem parentItem, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (this.trace) {
            log.trace((Object)(" end repeatable (" + this.stack.size() + "): " + particle.getTerm()));
        }
        RepeatableParticleHandler repeatableHandler = parentItem.repeatableHandler;
        repeatableHandler.endRepeatableParticle(parentItem.o, parentItem.repeatableParticleValue, elementName, particle, parentParticle);
        parentItem.repeatableParticleValue = null;
        parentItem.repeatableHandler = null;
    }

    private void endParticle(StackItem item, StackItem parentItem) {
        if (item.ended) {
            throw new JBossXBRuntimeException(item.particle.getTerm() + " has already been ended.");
        }
        ParticleHandler handler = item.handler;
        Object o = handler.endParticle(item.o, item.qName, item.particle);
        item.ended = true;
        if (parentItem.o != null) {
            ParticleBinding parentParticle = this.getNotSkippedParent().particle;
            if (parentParticle == null) {
                parentParticle = parentItem.particle;
            }
            if (parentItem.repeatableParticleValue == null) {
                this.setParent(handler, parentItem.o, o, item.qName, item.particle, parentParticle);
            } else {
                parentItem.repeatableHandler.addTermValue(parentItem.repeatableParticleValue, o, item.qName, item.particle, parentParticle, handler);
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        return this.root;
    }

    private Attributes preprocessAttributes(Attributes attrs) {
        SchemaBindingResolver resolver;
        SchemaBindingResolver schemaBindingResolver = resolver = this.schemaResolver == null ? this.schema.getSchemaResolver() : this.schemaResolver;
        if (resolver == null || !(resolver instanceof MutableSchemaResolver)) {
            return attrs;
        }
        int ind = attrs.getIndex("http://www.jboss.org/xml/ns/jbxb", "schemabinding");
        if (ind != -1) {
            MutableSchemaResolver defaultResolver = (MutableSchemaResolver)resolver;
            String value = attrs.getValue(ind);
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new JBossXBRuntimeException("jbxb:schemabinding attribute value is invalid: ns uri '" + uri + "' is missing value in '" + value + "'");
                }
                String cls = tokenizer.nextToken();
                try {
                    defaultResolver.mapURIToClass(uri, cls);
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to addClassBinding: uri='" + uri + "', class='" + cls + "'", e);
                }
            }
            AttributesImpl attrsImpl = new AttributesImpl(attrs.getLength() - 1);
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (i == ind) continue;
                attrsImpl.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
            attrs = attrsImpl;
        }
        return attrs;
    }

    private void flushIgnorableCharacters() {
        StackItem stackItem = this.stack.peek();
        if (stackItem.cursor != null || stackItem.textContent == null) {
            return;
        }
        if (stackItem.indentation == Boolean.TRUE || stackItem.ignorableCharacters) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ignored characters: " + ((ElementBinding)stackItem.particle.getTerm()).getQName() + " '" + stackItem.textContent + "'"));
            }
            stackItem.textContent = null;
            stackItem.indentation = null;
        }
    }

    private StackItem getNotSkippedParent() {
        StackItem item = this.stack.peek1();
        if (item == null) {
            return null;
        }
        ParticleBinding particle = item.particle;
        if (!particle.getTerm().isSkip() || item.repeatableParticleValue != null) {
            return item;
        }
        for (int i = this.stack.size() - 3; i >= 0; --i) {
            item = this.stack.peek(i);
            particle = item.particle;
            if (particle.getTerm().isSkip() && item.repeatableParticleValue == null) continue;
            return item;
        }
        return null;
    }

    private void endElement() {
        ElementInterceptor interceptor;
        StackItem item = this.stack.peek();
        Object o = item.o;
        ParticleBinding particle = item.particle;
        ElementBinding element = (ElementBinding)particle.getTerm();
        QName endName = element.getQName();
        TypeBinding type = element.getType();
        List<ElementInterceptor> interceptors = element.getInterceptors();
        List<ElementInterceptor> localInterceptors = item.parentType == null ? Collections.EMPTY_LIST : item.parentType.getInterceptors(endName);
        int allInterceptors = interceptors.size() + localInterceptors.size();
        if (o != NIL) {
            String textContent;
            this.flushIgnorableCharacters();
            TypeBinding charType = type.getSimpleType();
            if (charType == null) {
                charType = type;
            }
            CharactersHandler charHandler = item.ignoreCharacters ? null : charType.getCharactersHandler();
            String string = textContent = item.textContent == null ? "" : item.textContent.toString();
            if (textContent.length() > 0 || charHandler != null && !type.isIgnoreEmptyString()) {
                Object unmarshalled;
                String dataContent;
                SchemaBinding schema = element.getSchema();
                if (textContent.length() == 0) {
                    dataContent = null;
                } else {
                    dataContent = textContent.toString();
                    if (schema != null && schema.isReplacePropertyRefs()) {
                        dataContent = StringPropertyReplacer.replaceProperties((String)dataContent);
                    }
                    if (element.isNormalizeSpace()) {
                        dataContent = dataContent.trim();
                    }
                }
                if (charHandler == null) {
                    if (!type.isSimple() && schema != null && schema.isStrictSchema() && !element.isSkip()) {
                        throw new JBossXBRuntimeException("Element " + endName + " with type binding " + type.getQName() + " does not include text content binding: " + dataContent);
                    }
                    unmarshalled = dataContent;
                } else {
                    CharactersMetaData charactersMetaData;
                    ValueMetaData valueMetaData = element.getValueMetaData();
                    if (valueMetaData == null && (charactersMetaData = type.getCharactersMetaData()) != null) {
                        valueMetaData = charactersMetaData.getValue();
                    }
                    Object object = unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(endName, charType, this.nsRegistry, valueMetaData) : charHandler.unmarshal(endName, charType, this.nsRegistry, valueMetaData, dataContent);
                }
                if (unmarshalled != null) {
                    if (o == null) {
                        o = unmarshalled;
                    } else if (charHandler != null) {
                        TermBeforeSetParentCallback beforeSetParent = charType.getBeforeSetParentCallback();
                        if (beforeSetParent != null) {
                            this.ctx.parent = o;
                            this.ctx.particle = particle;
                            this.ctx.parentParticle = this.getNotSkippedParent().particle;
                            unmarshalled = beforeSetParent.beforeSetParent(unmarshalled, this.ctx);
                            this.ctx.clear();
                        }
                        charHandler.setValue(endName, element, o, unmarshalled);
                    }
                }
                if (allInterceptors > 0) {
                    ElementInterceptor interceptor2;
                    int i;
                    int interceptorIndex = this.stack.size() - 1 - allInterceptors;
                    for (i = interceptors.size() - 1; i >= 0; --i) {
                        interceptor2 = interceptors.get(i);
                        interceptor2.characters(this.stack.peek((int)interceptorIndex++).o, endName, type, this.nsRegistry, dataContent);
                    }
                    for (i = localInterceptors.size() - 1; i >= 0; --i) {
                        interceptor2 = localInterceptors.get(i);
                        interceptor2.characters(this.stack.peek((int)interceptorIndex++).o, endName, type, this.nsRegistry, dataContent);
                    }
                }
            }
        } else {
            o = null;
        }
        StackItem parentItem = this.stack.size() == 1 ? null : this.stack.peek1();
        Object parent = parentItem == null ? null : parentItem.o;
        ParticleHandler handler = this.stack.peek().handler;
        o = handler.endParticle(o, endName, particle);
        if (!interceptors.isEmpty()) {
            int interceptorIndex = this.stack.size() - 1 - interceptors.size();
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                interceptor = interceptors.get(i);
                interceptor.endElement(this.stack.peek((int)interceptorIndex++).o, endName, type);
            }
        }
        if (allInterceptors == 0) {
            StackItem notSkippedParentItem = this.getNotSkippedParent();
            if (notSkippedParentItem != null) {
                WildcardBinding wildcard;
                ParticleBinding parentParticle = notSkippedParentItem.particle;
                boolean hasWildcard = false;
                if (parentParticle != null && parentParticle.getTerm().isElement() && (wildcard = ((ElementBinding)parentParticle.getTerm()).getType().getWildcard()) != null) {
                    ParticleHandler wh;
                    hasWildcard = true;
                    if (parentItem.cursor.isWildcardContent() && (wh = wildcard.getWildcardHandler()) != null) {
                        handler = wh;
                    }
                }
                if (parent != null) {
                    if (notSkippedParentItem.repeatableParticleValue == null) {
                        this.setParent(handler, parent, o, endName, particle, parentParticle);
                    } else {
                        notSkippedParentItem.repeatableHandler.addTermValue(notSkippedParentItem.repeatableParticleValue, o, endName, particle, parentParticle, handler);
                    }
                } else if (parentParticle != null && hasWildcard && this.stack.size() > 1) {
                    for (int i = this.stack.size() - 2; i >= 0; --i) {
                        StackItem peeked = this.stack.peek(i);
                        peeked.o = o;
                        if (peeked.cursor == null) break;
                    }
                    if (this.trace) {
                        log.trace((Object)("Value of " + endName + " " + o + " is promoted as the value of its parent element."));
                    }
                }
            }
        } else {
            int i;
            StackItem popped = this.pop();
            for (i = interceptors.size() - 1; i >= 0; --i) {
                interceptor = interceptors.get(i);
                parent = this.pop().o;
                interceptor.add(parent, o, endName);
                o = parent;
            }
            for (i = localInterceptors.size() - 1; i >= 0; --i) {
                interceptor = localInterceptors.get(i);
                parent = this.pop().o;
                interceptor.add(parent, o, endName);
                o = parent;
            }
            this.stack.push(popped);
        }
        if (this.stack.size() == 1) {
            this.root = o = type.getValueAdapter().cast(o, Object.class);
            this.stack.clear();
            if (this.sawDTD) {
                try {
                    Class[] sig = new Class[]{String.class, String.class, String.class};
                    Method setDTD = o.getClass().getMethod("setDTD", sig);
                    Object[] args = new Object[]{this.dtdRootName, this.dtdPublicId, this.dtdSystemId};
                    setDTD.invoke(o, args);
                }
                catch (Exception e) {
                    log.debug((Object)("No setDTD found on root: " + o));
                }
            }
        }
    }

    private void setParent(ParticleHandler handler, Object parent, Object o, QName endName, ParticleBinding particle, ParticleBinding parentParticle) {
        TermBeforeSetParentCallback beforeSetParent = particle.getTerm().getBeforeSetParentCallback();
        if (beforeSetParent != null) {
            this.ctx.parent = parent;
            this.ctx.particle = particle;
            this.ctx.parentParticle = parentParticle;
            o = beforeSetParent.beforeSetParent(o, this.ctx);
            this.ctx.clear();
        }
        handler.setParent(parent, o, endName, particle, parentParticle);
    }

    private void push(QName qName, ParticleBinding particle, Object o, ParticleHandler handler, TypeBinding parentType) {
        StackItem item = new StackItem(qName, particle);
        item.o = o;
        item.handler = handler;
        item.parentType = parentType;
        this.stack.push(item);
        if (this.trace) {
            if (particle != null) {
                log.trace((Object)("pushed " + ((ElementBinding)particle.getTerm()).getQName() + "=" + o));
            } else {
                log.trace((Object)("pushed null particle, o=" + o));
            }
        }
    }

    private void push(QName qName, ModelGroupBinding.Cursor cursor, Object o, ParticleHandler handler, TypeBinding parentType) {
        StackItem item = new StackItem(qName, cursor);
        item.o = o;
        item.handler = handler;
        item.parentType = parentType;
        this.stack.push(item);
        if (this.trace) {
            log.trace((Object)("pushed cursor " + cursor + ", o=" + o));
        }
    }

    private StackItem pop() {
        StackItem item = this.stack.pop();
        if (this.trace) {
            if (item.cursor == null) {
                log.trace((Object)("poped " + ((ElementBinding)item.particle.getTerm()).getQName() + "=" + item.particle));
            } else {
                log.trace((Object)("poped " + item.cursor.getParticle().getTerm()));
            }
        }
        return item;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnmarshallingContextImpl
    implements UnmarshallingContext {
        Object parent;
        ParticleBinding particle;
        ParticleBinding parentParticle;

        private UnmarshallingContextImpl() {
        }

        @Override
        public Object getParentValue() {
            return this.parent;
        }

        @Override
        public ParticleBinding getParticle() {
            return this.particle;
        }

        @Override
        public ParticleBinding getParentParticle() {
            return this.parentParticle;
        }

        @Override
        public String resolvePropertyName() {
            String prop;
            TermBinding term = this.particle.getTerm();
            PropertyMetaData propertyMetaData = term.getPropertyMetaData();
            String string = prop = propertyMetaData == null ? null : propertyMetaData.getName();
            if (prop != null) {
                return prop;
            }
            if (term.isElement()) {
                QName name = ((ElementBinding)term).getQName();
                prop = Util.xmlNameToFieldName(name.getLocalPart(), term.getSchema().isIgnoreLowLine());
            }
            return prop;
        }

        @Override
        public Class<?> resolvePropertyType() {
            FieldInfo fieldInfo;
            if (this.parent == null) {
                return null;
            }
            String prop = this.resolvePropertyName();
            if (prop != null && (fieldInfo = FieldInfo.getFieldInfo(this.parent.getClass(), prop, false)) != null) {
                return fieldInfo.getType();
            }
            return null;
        }

        void clear() {
            ((SundayContentHandler)SundayContentHandler.this).ctx.parent = null;
            ((SundayContentHandler)SundayContentHandler.this).ctx.particle = null;
            ((SundayContentHandler)SundayContentHandler.this).ctx.parentParticle = null;
        }
    }

    static class StackImpl {
        private List<StackItem> list = new ArrayList<StackItem>();
        private StackItem head;
        private StackItem peek1;

        StackImpl() {
        }

        public void clear() {
            this.list.clear();
            this.head = null;
            this.peek1 = null;
        }

        public void push(StackItem o) {
            this.list.add(o);
            this.peek1 = this.head;
            this.head = o;
        }

        public StackItem pop() {
            this.head = this.peek1;
            int index = this.list.size() - 1;
            this.peek1 = index > 1 ? this.list.get(index - 2) : null;
            return this.list.remove(index);
        }

        public StackItem peek() {
            return this.head;
        }

        public StackItem peek1() {
            return this.peek1;
        }

        public StackItem peek(int i) {
            return this.list.get(i);
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public int size() {
            return this.list.size();
        }
    }

    private static class StackItem {
        final QName qName;
        final ModelGroupBinding.Cursor cursor;
        ParticleBinding particle;
        ParticleBinding nonXsiParticle;
        ParticleHandler handler;
        TypeBinding parentType;
        boolean ignoreCharacters;
        Object o;
        Object repeatableParticleValue;
        RepeatableParticleHandler repeatableHandler;
        StringBuffer textContent;
        Boolean indentation;
        boolean ignorableCharacters = true;
        boolean ended;

        public StackItem(QName qName, ModelGroupBinding.Cursor cursor) {
            if (cursor == null) {
                throw new IllegalArgumentException("Null cursor");
            }
            this.cursor = cursor;
            if (qName == null) {
                throw new IllegalArgumentException("Null qName");
            }
            this.qName = qName;
            this.particle = cursor.getParticle();
        }

        public StackItem(QName qName, ParticleBinding particle) {
            if (particle == null) {
                throw new IllegalArgumentException("Null particle");
            }
            this.cursor = null;
            if (qName == null) {
                throw new IllegalArgumentException("Null qName");
            }
            this.qName = qName;
            this.particle = particle;
        }

        void reset() {
            if (!this.ended) {
                throw new JBossXBRuntimeException("Attempt to reset a particle that has already been reset: " + this.particle.getTerm());
            }
            this.ended = false;
            this.o = null;
            if (this.textContent != null) {
                this.textContent.setLength(0);
            }
            this.indentation = null;
            this.ignorableCharacters = true;
            if (this.nonXsiParticle != null) {
                this.particle = this.nonXsiParticle;
            }
        }
    }
}

