/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayWrapperRepeatableParticleHandler
implements RepeatableParticleHandler {
    protected static final Logger log = Logger.getLogger(ArrayWrapperRepeatableParticleHandler.class);
    protected boolean trace = log.isTraceEnabled();
    private final BeanAdapterFactory beanAdapterFactory;

    public ArrayWrapperRepeatableParticleHandler(BeanAdapterFactory beanAdapterFactory) {
        if (beanAdapterFactory == null) {
            throw new IllegalArgumentException("beanAdapterFactory is null");
        }
        this.beanAdapterFactory = beanAdapterFactory;
    }

    @Override
    public void addTermValue(Object particleValue, Object termValue, QName elementName, ParticleBinding particle, ParticleBinding parentParticle, ParticleHandler handler) {
        if (particle.getTerm().isSkip()) {
            return;
        }
        ValueAdapter valueAdapter = particle.getTerm().getValueAdapter();
        if (valueAdapter != null) {
            termValue = valueAdapter.cast(termValue, null);
        }
        ((List)particleValue).add(termValue);
        if (this.trace) {
            log.trace((Object)("added " + elementName + " " + termValue));
        }
    }

    @Override
    public void endRepeatableParticle(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        AbstractPropertyHandler propertyHandler;
        if (this.trace) {
            log.trace((Object)("endRepeatableParticle " + elementName));
        }
        if ((propertyHandler = this.beanAdapterFactory.getPropertyHandler(elementName)) == null) {
            AbstractPropertyHandler wildcardHandler = this.beanAdapterFactory.getWildcardHandler();
            if (wildcardHandler != null && o != null) {
                o = this.toArray((List)o, (ArrayInfo)wildcardHandler.getPropertyType());
                wildcardHandler.doHandle(parent, o, elementName);
                return;
            }
            if (particle.getTerm().getSchema().isStrictSchema()) {
                throw new RuntimeException("QName " + elementName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + this.beanAdapterFactory.getAvailable());
            }
            if (this.trace) {
                log.trace((Object)("QName " + elementName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
            }
            return;
        }
        o = this.toArray((List)o, (ArrayInfo)propertyHandler.getPropertyType());
        propertyHandler.doHandle(parent, o, elementName);
    }

    @Override
    public Object startRepeatableParticle(Object parent, QName startName, ParticleBinding particle) {
        if (this.trace) {
            log.trace((Object)("startRepeatableParticle " + startName));
        }
        return new ArrayList();
    }

    private Object[] toArray(List<Object> elements, ArrayInfo arrayInfo) {
        try {
            Object[] arr = (Object[])arrayInfo.newArrayInstance(elements.size());
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = elements.get(i);
            }
            return arr;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating array of type " + arrayInfo.getName() + " from " + elements, t);
        }
    }
}

