/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import javax.jms.JMSException;
import org.jboss.messaging.core.contract.MessageReference;

class ReferenceHolder {
    private Long mid;
    private long refCount;
    private long pendingSentCount;

    public ReferenceHolder(Long id) throws JMSException {
        this.mid = id;
        this.refCount = 1L;
        this.pendingSentCount = 0L;
    }

    public void markSending() {
        ++this.pendingSentCount;
    }

    public long unmarkSending() {
        if (this.pendingSentCount > 0L) {
            --this.pendingSentCount;
        }
        return this.pendingSentCount;
    }

    public boolean isPending() {
        return this.pendingSentCount > 0L;
    }

    public int isAvailable(MessageReference exRef) {
        if (this.matchMessage(exRef)) {
            if (this.pendingSentCount < this.refCount) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public void addRef() {
        ++this.refCount;
    }

    public long releaseRef() {
        if (this.refCount > 0L) {
            --this.refCount;
        }
        return this.refCount;
    }

    public long releaseSendnRef() {
        --this.refCount;
        --this.pendingSentCount;
        return this.refCount;
    }

    public boolean matchMessage(MessageReference newRef) {
        Long mid1 = newRef.getMessage().getMessageID();
        return mid1.equals(this.mid);
    }

    public Long getMessageID() {
        return this.mid;
    }
}

