/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.IoWorkerRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelGroupFuture
implements ChannelGroupFuture {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelGroupFuture.class);
    private final ChannelGroup group;
    final Map<Integer, ChannelFuture> futures;
    private volatile ChannelGroupFutureListener firstListener;
    private volatile List<ChannelGroupFutureListener> otherListeners;
    private boolean done;
    int successCount;
    int failureCount;
    private int waiters;
    private final ChannelFutureListener childListener = new ChannelFutureListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean success = future.isSuccess();
            boolean callSetDone = false;
            DefaultChannelGroupFuture defaultChannelGroupFuture = DefaultChannelGroupFuture.this;
            synchronized (defaultChannelGroupFuture) {
                if (success) {
                    ++DefaultChannelGroupFuture.this.successCount;
                } else {
                    ++DefaultChannelGroupFuture.this.failureCount;
                }
                boolean bl = callSetDone = DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount == DefaultChannelGroupFuture.this.futures.size();
                assert (DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount <= DefaultChannelGroupFuture.this.futures.size());
            }
            if (callSetDone) {
                DefaultChannelGroupFuture.this.setDone();
            }
        }
    };

    public DefaultChannelGroupFuture(ChannelGroup group, Collection<ChannelFuture> futures) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (futures == null) {
            throw new NullPointerException("futures");
        }
        this.group = group;
        HashMap<Integer, ChannelFuture> futureMap = new HashMap<Integer, ChannelFuture>();
        for (ChannelFuture f : futures) {
            futureMap.put(f.getChannel().getId(), f);
        }
        this.futures = Collections.unmodifiableMap(futureMap);
        for (ChannelFuture f : this.futures.values()) {
            f.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setDone();
        }
    }

    DefaultChannelGroupFuture(ChannelGroup group, Map<Integer, ChannelFuture> futures) {
        this.group = group;
        this.futures = Collections.unmodifiableMap(futures);
        for (ChannelFuture f : this.futures.values()) {
            f.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setDone();
        }
    }

    @Override
    public ChannelGroup getGroup() {
        return this.group;
    }

    @Override
    public ChannelFuture find(Integer channelId) {
        return this.futures.get(channelId);
    }

    @Override
    public ChannelFuture find(Channel channel) {
        return this.futures.get(channel.getId());
    }

    @Override
    public Iterator<ChannelFuture> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized boolean isCompleteSuccess() {
        return this.successCount == this.futures.size();
    }

    @Override
    public synchronized boolean isPartialSuccess() {
        return !this.futures.isEmpty() && this.successCount != 0;
    }

    @Override
    public synchronized boolean isPartialFailure() {
        return !this.futures.isEmpty() && this.failureCount != 0;
    }

    @Override
    public synchronized boolean isCompleteFailure() {
        return this.failureCount == this.futures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelGroupFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (this.done) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<ChannelGroupFutureListener>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelGroupFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (!this.done) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelGroupFuture await() throws InterruptedException {
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            while (!this.done) {
                Object var3_2;
                this.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                    var3_2 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ChannelGroupFuture awaitUninterruptibly() {
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            while (!this.done) {
                Object var4_3;
                this.checkDeadLock();
                ++this.waiters;
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        var4_3 = null;
                        --this.waiters;
                        continue;
                    }
                    var4_3 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
            return this;
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        long startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
        long waitTime = timeoutNanos;
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            boolean bl;
            if (this.done) {
                return this.done;
            }
            if (waitTime <= 0L) {
                return this.done;
            }
            this.checkDeadLock();
            ++this.waiters;
            try {
                do {
                    block10: {
                        try {
                            this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                        }
                        catch (InterruptedException e) {
                            if (!interruptable) break block10;
                            throw e;
                        }
                    }
                    if (!this.done) continue;
                    boolean bl2 = true;
                    Object var11_9 = null;
                    --this.waiters;
                    return bl2;
                } while ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L);
                bl = this.done;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                --this.waiters;
                throw throwable;
            }
            Object var11_10 = null;
            --this.waiters;
            return bl;
        }
    }

    private void checkDeadLock() {
        if (IoWorkerRunnable.IN_IO_THREAD.get().booleanValue()) {
            throw new IllegalStateException("await*() in I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDone() {
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (this.done) {
                return false;
            }
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (ChannelGroupFutureListener l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(ChannelGroupFutureListener l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + ".", t);
        }
    }
}

