/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.spi.structure.ClassPathEntry;

public class ClassPathEntryImpl
implements ClassPathEntry,
Externalizable {
    private static final long serialVersionUID = -6463413458528845538L;
    static final List<ClassPathEntry> DEFAULT = Collections.singletonList(new ClassPathEntryImpl());
    private String path;
    private String suffixes;

    public ClassPathEntryImpl() {
        this.setPath("");
    }

    public ClassPathEntryImpl(String path) {
        this.setPath(path);
    }

    public ClassPathEntryImpl(String path, String suffixes) {
        this.setPath(path);
        this.setSuffixes(suffixes);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.path = path;
    }

    public String getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(String suffixes) {
        this.suffixes = suffixes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        this.toString(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
        builder.append("path=").append(this.getPath());
        String suffixes = this.getSuffixes();
        if (suffixes != null) {
            builder.append(" suffixes=").append(suffixes);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassPathEntry)) {
            return false;
        }
        ClassPathEntry other = (ClassPathEntry)obj;
        if (!this.getPath().equals(other.getPath())) {
            return false;
        }
        String thisSuffixes = this.getSuffixes();
        String otherSuffixes = other.getSuffixes();
        if (thisSuffixes == null) {
            return otherSuffixes == null;
        }
        return thisSuffixes.equals(otherSuffixes);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setPath(in.readUTF());
        boolean hasSuffixes = in.readBoolean();
        if (hasSuffixes) {
            this.setSuffixes(in.readUTF());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getPath());
        String suffixes = this.getSuffixes();
        out.writeBoolean(suffixes != null);
        if (suffixes != null) {
            out.writeUTF(suffixes);
        }
    }
}

