/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ExtensionBeanDeployer;
import org.jboss.weld.bootstrap.ExtensionBeanDeployerEnvironment;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.AfterDeploymentValidationImpl;
import org.jboss.weld.bootstrap.events.BeforeBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.NumericConversationIdGenerator;
import org.jboss.weld.conversation.ServletConversationManager;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.ForbiddenArgumentException;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.jsf.JsfApiAbstraction;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.logging.messages.VersionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.SingleThreadScheduledExecutorServiceFactory;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ScheduledExecutorServiceFactory;
import org.jboss.weld.serialization.ContextualStoreImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.servlet.HttpSessionManager;
import org.jboss.weld.servlet.ServletApiAbstraction;
import org.jboss.weld.servlet.api.ServletServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.JavassistCleaner;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.serviceProvider.DefaultServiceLoaderFactory;
import org.jboss.weld.util.serviceProvider.ServiceLoaderFactory;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldBootstrap
implements Bootstrap {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private BeanManagerImpl deploymentManager;
    private Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private Environment environment;
    private Deployment deployment;
    private ExtensionBeanDeployerEnvironment extensionDeployerEnvironment;
    private DeploymentVisitor deploymentVisitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap startContainer(Environment environment, Deployment deployment, BeanStore applicationBeanStore) {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (deployment == null) {
                throw new ForbiddenArgumentException(BootstrapMessage.DEPLOYMENT_REQUIRED, new Object[0]);
            }
            if (!deployment.getServices().contains(ResourceLoader.class)) {
                deployment.getServices().add(ResourceLoader.class, (Service)new DefaultResourceLoader());
            }
            if (!deployment.getServices().contains(ScheduledExecutorServiceFactory.class)) {
                deployment.getServices().add(ScheduledExecutorServiceFactory.class, (Service)new SingleThreadScheduledExecutorServiceFactory());
            }
            WeldBootstrap.verifyServices(deployment.getServices(), environment.getRequiredDeploymentServices());
            if (!deployment.getServices().contains(TransactionServices.class)) {
                log.info((Enum)BootstrapMessage.JTA_UNAVAILABLE, new Object[0]);
            }
            if (applicationBeanStore == null) {
                throw new ForbiddenStateException(BootstrapMessage.BEAN_STORE_MISSING, new Object[0]);
            }
            this.deployment = deployment;
            ServiceRegistry implementationServices = this.getImplementationServices((ResourceLoader)deployment.getServices().get(ResourceLoader.class));
            deployment.getServices().addAll((Collection)implementationServices.entrySet());
            SimpleServiceRegistry deploymentServices = new SimpleServiceRegistry();
            deploymentServices.add(ClassTransformer.class, implementationServices.get(ClassTransformer.class));
            deploymentServices.add(MetaAnnotationStore.class, implementationServices.get(MetaAnnotationStore.class));
            deploymentServices.add(TypeStore.class, implementationServices.get(TypeStore.class));
            this.environment = environment;
            this.deploymentManager = BeanManagerImpl.newRootManager("deployment", (ServiceRegistry)deploymentServices);
            Container.initialize(this.deploymentManager, ServiceRegistries.unmodifiableServiceRegistry((ServiceRegistry)deployment.getServices()));
            Container.instance().setState(ContainerState.STARTING);
            this.createContexts();
            this.initializeContexts();
            ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).beginApplication(applicationBeanStore);
            this.extensionDeployerEnvironment = new ExtensionBeanDeployerEnvironment(EjbDescriptors.EMPTY, this.deploymentManager);
            this.deploymentVisitor = new DeploymentVisitor(this.deploymentManager, environment, deployment);
            this.beanDeployments = this.deploymentVisitor.visit();
            return this;
        }
    }

    private ServiceRegistry getImplementationServices(ResourceLoader resourceLoader) {
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.add(EJBApiAbstraction.class, (Service)new EJBApiAbstraction(resourceLoader));
        services.add(JsfApiAbstraction.class, (Service)new JsfApiAbstraction(resourceLoader));
        services.add(PersistenceApiAbstraction.class, (Service)new PersistenceApiAbstraction(resourceLoader));
        services.add(WSApiAbstraction.class, (Service)new WSApiAbstraction(resourceLoader));
        services.add(ServletApiAbstraction.class, (Service)new ServletApiAbstraction(resourceLoader));
        services.add(Validator.class, (Service)new Validator());
        services.add(TypeStore.class, (Service)new TypeStore());
        services.add(ClassTransformer.class, (Service)new ClassTransformer((TypeStore)services.get(TypeStore.class)));
        services.add(MetaAnnotationStore.class, (Service)new MetaAnnotationStore((ClassTransformer)services.get(ClassTransformer.class)));
        services.add(ContextualStore.class, (Service)new ContextualStoreImpl());
        services.add(ServiceLoaderFactory.class, (Service)new DefaultServiceLoaderFactory());
        services.add(JavassistCleaner.class, (Service)new JavassistCleaner());
        services.add(CurrentInjectionPoint.class, (Service)new CurrentInjectionPoint());
        return services;
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        if (this.beanDeployments.containsKey(beanDeploymentArchive)) {
            return this.beanDeployments.get(beanDeploymentArchive).getBeanManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap startInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (this.deploymentManager == null) {
                throw new ForbiddenStateException(BootstrapMessage.MANAGER_NOT_INITIALIZED, new Object[0]);
            }
            ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.deploymentManager, this.deployment, this.beanDeployments);
            extensionBeanDeployer.addExtensions(((ServiceLoaderFactory)this.deployment.getServices().get(ServiceLoaderFactory.class)).load(Extension.class));
            extensionBeanDeployer.deployBeans();
            this.deploymentManager.addBean(new BeanManagerBean(this.deploymentManager));
            this.beanDeployments = this.deploymentVisitor.visit();
            BeforeBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments);
            this.beanDeployments = this.deploymentVisitor.visit();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap deployBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                entry.getValue().deployBeans(this.environment);
            }
            AfterBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments);
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                entry.getValue().afterBeanDiscovery(this.environment);
            }
            this.beanDeployments = this.deploymentVisitor.visit();
            Container.instance().putBeanDeployments(this.beanDeployments);
            Container.instance().setState(ContainerState.INITIALIZED);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap validateBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            log.debug((Enum)BootstrapMessage.VALIDATING_BEANS, new Object[0]);
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                ((Validator)this.deployment.getServices().get(Validator.class)).validateDeployment(entry.getValue().getBeanManager(), (BeanDeployerEnvironment)entry.getValue().getBeanDeployer().getEnvironment());
            }
            AfterDeploymentValidationImpl.fire(this.deploymentManager, this.beanDeployments);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap endInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            Container.instance().setState(ContainerState.VALIDATED);
        }
        return this;
    }

    protected void initializeContexts() {
        Lifecycle lifecycle = (Lifecycle)this.deployment.getServices().get(ContextLifecycle.class);
        this.deploymentManager.addContext(lifecycle.getDependentContext());
        this.deploymentManager.addContext(lifecycle.getRequestContext());
        this.deploymentManager.addContext(lifecycle.getConversationContext());
        this.deploymentManager.addContext(lifecycle.getSessionContext());
        this.deploymentManager.addContext(lifecycle.getApplicationContext());
        this.deploymentManager.addContext(lifecycle.getSingletonContext());
    }

    protected void createContexts() {
        ApplicationContext applicationContext = new ApplicationContext();
        SingletonContext singletonContext = new SingletonContext();
        SessionContext sessionContext = new SessionContext();
        ConversationContext conversationContext = new ConversationContext();
        RequestContext requestContext = new RequestContext();
        DependentContext dependentContext = new DependentContext();
        this.deployment.getServices().add(ContextLifecycle.class, (Service)new ContextLifecycle(applicationContext, singletonContext, sessionContext, conversationContext, requestContext, dependentContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).endApplication();
            ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).beginApplication((BeanStore)new HashMapBeanStore());
            BeforeShutdownImpl.fire(this.deploymentManager, this.beanDeployments);
            ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).endApplication();
        }
        finally {
            Container.instance().setState(ContainerState.SHUTDOWN);
            Container.instance().cleanup();
        }
    }

    protected static void verifyServices(ServiceRegistry services, Set<Class<? extends Service>> requiredServices) {
        for (Class<? extends Service> serviceType : requiredServices) {
            if (services.contains(serviceType)) continue;
            throw new ForbiddenStateException(BootstrapMessage.UNSPECIFIED_REQUIRED_SERVICE, serviceType.getName());
        }
    }

    static {
        LoggerFactory.loggerFactory().getLogger(Category.VERSION).info((Enum)VersionMessage.VERSION, new Object[]{Names.version(WeldBootstrap.class.getPackage())});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentVisitor {
        private final BeanManagerImpl deploymentManager;
        private final Environment environment;
        private final Deployment deployment;
        private final Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives;
        private final BeanDeploymentArchive implementationBeanDeploymentArchive;

        public DeploymentVisitor(BeanManagerImpl deploymentManager, Environment environment, final Deployment deployment) {
            this.deploymentManager = deploymentManager;
            this.environment = environment;
            this.deployment = deployment;
            this.managerAwareBeanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanDeployment>();
            this.implementationBeanDeploymentArchive = new BeanDeploymentArchive(){
                private final ServiceRegistry serviceRegistry = new SimpleServiceRegistry();
                private final Set<Class<?>> beanClasses = deployment.getServices().contains(ServletServices.class) ? Arrays2.asSet(ConversationImpl.class, ServletConversationManager.class, NumericConversationIdGenerator.class, HttpSessionManager.class) : Collections.emptySet();

                public ServiceRegistry getServices() {
                    return this.serviceRegistry;
                }

                public String getId() {
                    return "weld";
                }

                public Collection<EjbDescriptor<?>> getEjbs() {
                    return Collections.emptySet();
                }

                public Collection<URL> getBeansXml() {
                    return Collections.emptySet();
                }

                public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
                    return Collections.emptySet();
                }

                public Collection<Class<?>> getBeanClasses() {
                    return this.beanClasses;
                }
            };
        }

        public Map<BeanDeploymentArchive, BeanDeployment> visit() {
            this.visit(this.implementationBeanDeploymentArchive, this.managerAwareBeanDeploymentArchives, new HashSet<BeanDeploymentArchive>(), false);
            for (BeanDeploymentArchive archvive : this.deployment.getBeanDeploymentArchives()) {
                this.visit(archvive, this.managerAwareBeanDeploymentArchives, new HashSet<BeanDeploymentArchive>(), true);
            }
            return this.managerAwareBeanDeploymentArchives;
        }

        private BeanDeployment visit(BeanDeploymentArchive beanDeploymentArchive, Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives, Set<BeanDeploymentArchive> seenBeanDeploymentArchives, boolean validate) {
            if (validate) {
                WeldBootstrap.verifyServices(beanDeploymentArchive.getServices(), this.environment.getRequiredBeanDeploymentArchiveServices());
            }
            if (beanDeploymentArchive.getId() == null) {
                throw new ForbiddenArgumentException(BootstrapMessage.DEPLOYMENT_ARCHIVE_NULL, beanDeploymentArchive);
            }
            BeanDeployment parent = managerAwareBeanDeploymentArchives.get(beanDeploymentArchive);
            if (parent == null) {
                parent = new BeanDeployment(beanDeploymentArchive, this.deploymentManager, this.deployment.getServices());
                managerAwareBeanDeploymentArchives.put(beanDeploymentArchive, parent);
            }
            seenBeanDeploymentArchives.add(beanDeploymentArchive);
            for (BeanDeploymentArchive archive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                if (seenBeanDeploymentArchives.contains(archive)) continue;
                BeanDeployment child = this.visit(archive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives, validate);
                parent.getBeanManager().addAccessibleBeanManager(child.getBeanManager());
            }
            parent.getBeanManager().addAccessibleBeanManager(managerAwareBeanDeploymentArchives.get(this.implementationBeanDeploymentArchive).getBeanManager());
            return parent;
        }
    }
}

