/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.exceptions;

import java.io.Serializable;
import org.jboss.weld.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldExceptionMessage
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String message;
    private Enum<?> messageKey;
    private Object[] messageArguments;

    public WeldExceptionMessage(String message) {
        this.message = message;
    }

    public <E extends Enum<?>> WeldExceptionMessage(E key, Object ... args) {
        this.messageKey = key;
        if (args != null && args.length > 0) {
            this.messageArguments = new String[args.length];
            int index = 0;
            for (Object arg : args) {
                this.messageArguments[index++] = arg.toString();
            }
        }
    }

    public String getAsString() {
        String result = this.message;
        if (result == null) {
            try {
                result = LoggerFactory.loggerFactory().getMessageConveyor().getMessage(this.messageKey, this.messageArguments);
            }
            catch (Exception e) {
                result = "Exception message for key " + this.messageKey + " not found due to " + e.getLocalizedMessage();
            }
            if (result == null) {
                result = "Exception message for key " + this.messageKey + " not found";
            }
        }
        return result;
    }
}

